/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedErrorHandlerMBean;
import org.apache.camel.processor.ErrorHandlerSupport;
import org.apache.camel.processor.RedeliveryErrorHandler;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.RouteContext;

@ManagedResource(description="Managed ErrorHandler")
public class ManagedErrorHandler
implements ManagedErrorHandlerMBean {
    private final RouteContext routeContext;
    private final Processor errorHandler;
    private final ErrorHandlerFactory errorHandlerBuilder;

    public ManagedErrorHandler(RouteContext routeContext, Processor errorHandler, ErrorHandlerFactory builder) {
        this.routeContext = routeContext;
        this.errorHandler = errorHandler;
        this.errorHandlerBuilder = builder;
    }

    public void init(ManagementStrategy strategy) {
    }

    public RouteContext getRouteContext() {
        return this.routeContext;
    }

    public Processor getErrorHandler() {
        return this.errorHandler;
    }

    public ErrorHandlerFactory getErrorHandlerBuilder() {
        return this.errorHandlerBuilder;
    }

    @Override
    public String getCamelId() {
        return this.routeContext.getCamelContext().getName();
    }

    @Override
    public String getCamelManagementName() {
        return this.routeContext.getCamelContext().getManagementName();
    }

    @Override
    public boolean isSupportRedelivery() {
        return this.errorHandler instanceof RedeliveryErrorHandler;
    }

    @Override
    public boolean isDeadLetterChannel() {
        if (!this.isSupportRedelivery()) {
            return false;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getDeadLetter() != null;
    }

    @Override
    public boolean isDeadLetterUseOriginalMessage() {
        if (!this.isSupportRedelivery()) {
            return false;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.isUseOriginalMessagePolicy();
    }

    @Override
    public boolean isDeadLetterHandleNewException() {
        if (!this.isSupportRedelivery()) {
            return false;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return this.isDeadLetterChannel() && redelivery.isDeadLetterHandleNewException();
    }

    @Override
    public boolean isSupportTransactions() {
        if (this.errorHandler instanceof ErrorHandlerSupport) {
            ErrorHandlerSupport ehs = (ErrorHandlerSupport)this.errorHandler;
            return ehs.supportTransacted();
        }
        return false;
    }

    @Override
    public String getDeadLetterChannelEndpointUri() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getDeadLetterUri();
    }

    @Override
    public Integer getMaximumRedeliveries() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().getMaximumRedeliveries();
    }

    @Override
    public void setMaximumRedeliveries(Integer maximum) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setMaximumRedeliveries(maximum);
    }

    @Override
    public Long getMaximumRedeliveryDelay() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().getMaximumRedeliveryDelay();
    }

    @Override
    public void setMaximumRedeliveryDelay(Long delay) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setMaximumRedeliveryDelay(delay);
    }

    @Override
    public Long getRedeliveryDelay() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().getRedeliveryDelay();
    }

    @Override
    public void setRedeliveryDelay(Long delay) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setRedeliveryDelay(delay);
    }

    @Override
    public Double getBackOffMultiplier() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().getBackOffMultiplier();
    }

    @Override
    public void setBackOffMultiplier(Double multiplier) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setBackOffMultiplier(multiplier);
    }

    @Override
    public Double getCollisionAvoidanceFactor() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().getCollisionAvoidanceFactor();
    }

    @Override
    public void setCollisionAvoidanceFactor(Double factor) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setCollisionAvoidanceFactor(factor);
    }

    @Override
    public Double getCollisionAvoidancePercent() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().getCollisionAvoidancePercent();
    }

    @Override
    public void setCollisionAvoidancePercent(Double percent) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setCollisionAvoidancePercent(percent);
    }

    @Override
    public String getDelayPattern() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().getDelayPattern();
    }

    @Override
    public void setDelayPattern(String pattern) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setDelayPattern(pattern);
    }

    @Override
    public String getRetriesExhaustedLogLevel() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().getRetriesExhaustedLogLevel().name();
    }

    @Override
    public void setRetriesExhaustedLogLevel(String level) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setRetriesExhaustedLogLevel(LoggingLevel.valueOf(level));
    }

    @Override
    public String getRetryAttemptedLogLevel() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().getRetryAttemptedLogLevel().name();
    }

    @Override
    public void setRetryAttemptedLogLevel(String level) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setRetryAttemptedLogLevel(LoggingLevel.valueOf(level));
    }

    @Override
    public Boolean getLogStackTrace() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isLogStackTrace();
    }

    @Override
    public void setLogStackTrace(Boolean log) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setLogStackTrace(log);
    }

    @Override
    public Boolean getLogRetryStackTrace() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isLogRetryStackTrace();
    }

    @Override
    public void setLogRetryStackTrace(Boolean log) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setLogRetryStackTrace(log);
    }

    @Override
    public Boolean getLogHandled() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isLogHandled();
    }

    @Override
    public void setLogHandled(Boolean log) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setLogHandled(log);
    }

    @Override
    public Boolean getLogNewException() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isLogNewException();
    }

    @Override
    public void setLogNewException(Boolean log) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setLogNewException(log);
    }

    @Override
    public Boolean getLogExhaustedMessageHistory() {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isLogExhaustedMessageHistory();
    }

    @Override
    public void setLogExhaustedMessageHistory(Boolean log) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setLogExhaustedMessageHistory(log);
    }

    @Override
    public Boolean getLogContinued() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isLogHandled();
    }

    @Override
    public void setLogContinued(Boolean log) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setLogContinued(log);
    }

    @Override
    public Boolean getLogExhausted() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isLogExhausted();
    }

    @Override
    public void setLogExhausted(Boolean log) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setLogExhausted(log);
    }

    @Override
    public Boolean getUseCollisionAvoidance() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isUseCollisionAvoidance();
    }

    @Override
    public void setUseCollisionAvoidance(Boolean avoidance) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setUseCollisionAvoidance(avoidance);
    }

    @Override
    public Boolean getUseExponentialBackOff() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isUseExponentialBackOff();
    }

    @Override
    public void setUseExponentialBackOff(Boolean backoff) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setUseExponentialBackOff(backoff);
    }

    @Override
    public Boolean getAllowRedeliveryWhileStopping() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getRedeliveryPolicy().isAllowRedeliveryWhileStopping();
    }

    @Override
    public void setAllowRedeliveryWhileStopping(Boolean allow) {
        if (!this.isSupportRedelivery()) {
            throw new IllegalArgumentException("This error handler does not support redelivery");
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        redelivery.getRedeliveryPolicy().setAllowRedeliveryWhileStopping(allow);
    }

    @Override
    public Integer getPendingRedeliveryCount() {
        if (!this.isSupportRedelivery()) {
            return null;
        }
        RedeliveryErrorHandler redelivery = (RedeliveryErrorHandler)this.errorHandler;
        return redelivery.getPendingRedeliveryCount();
    }
}

