/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.crankstart.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.launch.Framework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrankstartContext {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Framework osgiFramework;
    private final Map<String, String> osgiFrameworkProperties = new HashMap<String, String>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<String, String> defaults = new HashMap<String, String>();
    public static final String DEFAULT_BUNDLE_START_LEVEL = "crankstart.bundle.start.level";
    public static final String ATTR_STOP_CRANKSTART_PROCESSING = "crankstart.stop.processing";
    public static final String ATTR_STOP_OSGI_FRAMEWORK = "stop.osgi.framework";

    public void setOsgiFrameworkProperty(String key, String value) {
        this.osgiFrameworkProperties.put(key, value);
    }

    public Map<String, String> getOsgiFrameworkProperties() {
        return Collections.unmodifiableMap(this.osgiFrameworkProperties);
    }

    public void setOsgiFramework(Framework f) {
        if (this.osgiFramework != null) {
            throw new IllegalStateException("OSGi framework already set");
        }
        this.osgiFramework = f;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (CrankstartContext.this.osgiFramework != null && CrankstartContext.this.osgiFramework.getState() == 32) {
                    try {
                        CrankstartContext.this.log.info("Stopping the OSGi framework");
                        CrankstartContext.this.osgiFramework.stop();
                        CrankstartContext.this.log.info("Waiting for the OSGi framework to exit");
                        CrankstartContext.this.osgiFramework.waitForStop(0L);
                        CrankstartContext.this.log.info("OSGi framework stopped");
                    }
                    catch (Exception e) {
                        CrankstartContext.this.log.error("Exception while stopping OSGi framework", (Throwable)e);
                    }
                }
            }
        });
    }

    public Framework getOsgiFramework() {
        return this.osgiFramework;
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Map<String, String> getDefaults() {
        return this.defaults;
    }
}

