/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Scope {
    private Scope parent = null;
    private int parms;
    private int vars;
    private Map<String, Integer> namedVariables = null;
    private Map<Integer, Integer> hoistedVariables = null;

    public Scope(Scope scope, String ... parameters) {
        if (parameters != null) {
            this.parms = parameters.length;
            this.namedVariables = new LinkedHashMap<String, Integer>();
            for (int p = 0; p < this.parms; ++p) {
                this.namedVariables.put(parameters[p], p);
            }
        } else {
            this.parms = 0;
        }
        this.vars = 0;
        this.parent = scope;
    }

    public int hashCode() {
        return this.namedVariables == null ? 0 : this.parms ^ this.namedVariables.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Scope)) {
            return false;
        }
        Scope scope = (Scope)o;
        if (this.parms != scope.parms) {
            return false;
        }
        if (this.namedVariables == null) {
            return scope.namedVariables == null;
        }
        return this.namedVariables.equals(scope.namedVariables);
    }

    public Integer getSymbol(String name) {
        return this.getSymbol(name, true);
    }

    private Integer getSymbol(String name, boolean hoist) {
        Integer pr;
        Integer register;
        Integer n = register = this.namedVariables != null ? this.namedVariables.get(name) : null;
        if (register == null && hoist && this.parent != null && (pr = this.parent.getSymbol(name, false)) != null) {
            if (this.hoistedVariables == null) {
                this.hoistedVariables = new LinkedHashMap<Integer, Integer>();
            }
            if (this.namedVariables == null) {
                this.namedVariables = new LinkedHashMap<String, Integer>();
            }
            register = this.namedVariables.size();
            this.namedVariables.put(name, register);
            this.hoistedVariables.put(register, pr);
        }
        return register;
    }

    public boolean isHoistedSymbol(int symbol) {
        return this.hoistedVariables != null && this.hoistedVariables.containsKey(symbol);
    }

    public void declareParameter(String name) {
        if (this.namedVariables == null) {
            this.namedVariables = new LinkedHashMap<String, Integer>();
        } else if (this.vars > 0) {
            throw new IllegalStateException("cant declare parameters after variables");
        }
        Integer register = this.namedVariables.get(name);
        if (register == null) {
            register = this.namedVariables.size();
            this.namedVariables.put(name, register);
            ++this.parms;
        }
    }

    public Integer declareVariable(String name) {
        Integer register;
        if (this.namedVariables == null) {
            this.namedVariables = new LinkedHashMap<String, Integer>();
        }
        if ((register = this.namedVariables.get(name)) == null) {
            register = this.namedVariables.size();
            this.namedVariables.put(name, register);
            ++this.vars;
        }
        return register;
    }

    public Frame createFrame(Frame frame) {
        if (this.namedVariables != null) {
            Object[] arguments = new Object[this.namedVariables.size()];
            if (frame != null && this.hoistedVariables != null && this.parent != null) {
                for (Map.Entry<Integer, Integer> hoist : this.hoistedVariables.entrySet()) {
                    Object arg;
                    Integer target = hoist.getKey();
                    Integer source = hoist.getValue();
                    arguments[target.intValue()] = arg = frame.get(source);
                }
            }
            return new Frame(this, arguments, 0);
        }
        return null;
    }

    public Integer getHoisted(int symbol) {
        if (this.hoistedVariables != null) {
            for (Map.Entry<Integer, Integer> hoist : this.hoistedVariables.entrySet()) {
                Integer source = hoist.getValue();
                if (source != symbol) continue;
                return hoist.getKey();
            }
        }
        return null;
    }

    public int getArgCount() {
        return this.parms;
    }

    public String[] getSymbols() {
        return this.namedVariables != null ? this.namedVariables.keySet().toArray(new String[0]) : new String[]{};
    }

    public String[] getParameters() {
        if (this.namedVariables != null && this.parms > 0) {
            String[] pa = new String[this.parms];
            int p = 0;
            for (Map.Entry<String, Integer> entry : this.namedVariables.entrySet()) {
                if (entry.getValue() >= this.parms) continue;
                pa[p++] = entry.getKey();
            }
            return pa;
        }
        return null;
    }

    public String[] getLocalVariables() {
        if (this.namedVariables != null && this.vars > 0) {
            String[] pa = new String[this.parms - (this.hoistedVariables == null ? 0 : this.hoistedVariables.size())];
            int p = 0;
            for (Map.Entry<String, Integer> entry : this.namedVariables.entrySet()) {
                int symnum = entry.getValue();
                if (symnum < this.parms || this.hoistedVariables != null && this.hoistedVariables.containsKey(symnum)) continue;
                pa[p++] = entry.getKey();
            }
            return pa;
        }
        return null;
    }

    public static final class Frame {
        private final Scope scope;
        private final Object[] stack;
        private int curried = 0;

        public Frame(Scope s, Object[] r, int c) {
            this.scope = s;
            this.stack = r;
            this.curried = c;
        }

        public Scope getScope() {
            return this.scope;
        }

        public int hashCode() {
            return Arrays.deepHashCode(this.stack);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Frame other = (Frame)obj;
            return Arrays.deepEquals(this.stack, other.stack);
        }

        public Object get(int s) {
            return this.stack[s];
        }

        public void set(int r, Object value) {
            this.stack[r] = value;
        }

        public Frame assign(Object ... values) {
            if (this.stack != null && values != null && values.length > 0) {
                Object[] copy = (Object[])this.stack.clone();
                int ncopy = Math.min(copy.length - this.curried, values.length);
                System.arraycopy(values, 0, copy, this.curried, ncopy);
                return new Frame(this.scope, copy, this.curried + ncopy);
            }
            return this;
        }
    }
}

