/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.security.Principal;
import java.util.Arrays;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.Privilege;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.internal.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLPipe
extends BasePipe {
    private static Logger logger = LoggerFactory.getLogger(ACLPipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/acl";
    public static final String PN_USERNAME = "userName";
    public static final String PN_ALLOW = "allow";
    public static final String PN_DENY = "deny";
    public static final String PN_AUTHORIZABLE = "authorizable";
    public static final String PATH_KEY = "path";
    public static final String PRIVILEGES_KEY = "rep:privileges";
    public static final String ACE_GRANT_KEY = "rep:GrantACE";
    public static final String ACE_DENY_KEY = "rep:DenyACE";
    public static final String JCR_PRIVILEGES_INPUT = "jcr:privileges";
    public static final String PRIVILEGES_JSON_KEY = "privileges";
    Session session;
    UserManager userManager;
    Privilege[] privileges;
    String[] privilegesInput;
    boolean allow;
    boolean deny;
    Object outputBinding;

    @Override
    public Object getOutputBinding() {
        if (this.outputBinding != null) {
            return this.outputBinding;
        }
        return super.getOutputBinding();
    }

    @Override
    public boolean modifiesContent() {
        return this.allow || this.deny;
    }

    public ACLPipe(Plumber plumber, Resource resource, PipeBindings upperBindings) {
        super(plumber, resource, upperBindings);
        this.session = (Session)this.resolver.adaptTo(Session.class);
        this.userManager = (UserManager)this.resolver.adaptTo(UserManager.class);
        this.privilegesInput = (String[])this.properties.get(JCR_PRIVILEGES_INPUT, (Object)new String[0]);
        this.allow = (Boolean)this.properties.get(PN_ALLOW, (Object)false);
        this.deny = (Boolean)this.properties.get(PN_DENY, (Object)false);
    }

    Iterator<Resource> computeAllowDenyOutput(Resource resource) throws RepositoryException {
        logger.debug("Going to changing ACL for the resource at path {}", (Object)resource.getPath());
        if (StringUtils.isEmpty((CharSequence)this.getExpr())) {
            throw new IllegalArgumentException("expression for the principal or authorizable Id should be provided or provided correctly for privileges to be set");
        }
        Principal principal = this.getPrincipalFor(this.getExpr());
        if (ArrayUtils.isEmpty((Object[])this.privilegesInput)) {
            this.privileges = this.allow ? AccessControlUtils.privilegesFromNames((Session)this.session, (String[])new String[]{"{http://www.jcp.org/jcr/1.0}all"}) : AccessControlUtils.privilegesFromNames((Session)this.session, (String[])new String[]{"{http://www.jcp.org/jcr/1.0}read"});
        } else {
            this.privilegesInput = this.processPrivilegesInput(this.privilegesInput);
            this.privileges = AccessControlUtils.privilegesFromNames((Session)this.session, (String[])this.privilegesInput);
        }
        this.addAccessControlEntry(resource, principal);
        return super.computeOutput();
    }

    @Override
    public Iterator<Resource> computeOutput() {
        Resource resource = this.getInput();
        try {
            if (resource != null) {
                if (this.allow || this.deny) {
                    return this.computeAllowDenyOutput(resource);
                }
                this.bindACLs(resource);
                return super.computeOutput();
            }
        }
        catch (RepositoryException e) {
            logger.error("unable to properly treat ACLs, returning empty iterator", (Throwable)e);
        }
        return EMPTY_ITERATOR;
    }

    void bindACLs(Resource resource) {
        try {
            Authorizable auth = this.checkIsAuthorizableResource(resource);
            if (null != auth) {
                this.bindAclsForAuthorizableResource(auth);
                return;
            }
            logger.info("binding acls for resource at path {}", (Object)resource.getPath());
            JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList((Session)this.session, (String)resource.getPath());
            JackrabbitAccessControlEntry[] entries = (JackrabbitAccessControlEntry[])acl.getAccessControlEntries();
            JsonArrayBuilder principalPrivilegesArray = Json.createArrayBuilder();
            for (JackrabbitAccessControlEntry entry : entries) {
                JsonObjectBuilder principalPrivilegesMappings = Json.createObjectBuilder();
                JsonArrayBuilder privilegeSet = Json.createArrayBuilder();
                for (Privilege privilege : entry.getPrivileges()) {
                    privilegeSet.add(privilege.getName());
                }
                principalPrivilegesMappings.add(PN_AUTHORIZABLE, entry.getPrincipal().getName());
                principalPrivilegesMappings.add(PRIVILEGES_JSON_KEY, privilegeSet);
                if (entry.isAllow()) {
                    principalPrivilegesMappings.add(PN_ALLOW, true);
                } else {
                    principalPrivilegesMappings.add(PN_DENY, true);
                }
                principalPrivilegesArray.add(principalPrivilegesMappings);
            }
            this.outputBinding = JsonUtil.toString(principalPrivilegesArray);
        }
        catch (Exception e) {
            this.outputBinding = JsonUtil.toString(Json.createObjectBuilder());
            logger.error("unable to bind acls", (Throwable)e);
        }
    }

    void bindAclsForAuthorizableResource(Authorizable auth) throws RepositoryException {
        logger.info("binding acls for authorizable {} and authID {}", (Object)auth.getPath(), (Object)auth.getID());
        String query = "/jcr:root//element(*, rep:ACE)[@rep:principalName = '" + auth.getID() + "']";
        Iterator resources = this.resolver.findResources(query, "xpath");
        JsonObjectBuilder authPermisions = Json.createObjectBuilder();
        JsonArrayBuilder allowArray = Json.createArrayBuilder();
        JsonArrayBuilder denyArray = Json.createArrayBuilder();
        resources.forEachRemaining(res -> {
            String[] privilegeSet = (String[])((ValueMap)res.adaptTo(ValueMap.class)).get(PRIVILEGES_KEY, String[].class);
            JsonArrayBuilder privilegesArray = Json.createArrayBuilder();
            for (String privilege : privilegeSet) {
                privilegesArray.add(privilege);
            }
            JsonObjectBuilder aceObj = Json.createObjectBuilder();
            aceObj.add(PATH_KEY, res.getParent().getParent().getPath());
            aceObj.add(PRIVILEGES_JSON_KEY, privilegesArray);
            if (res.getResourceType().equals(ACE_GRANT_KEY)) {
                allowArray.add(aceObj);
            } else if (res.getResourceType().equals(ACE_DENY_KEY)) {
                denyArray.add(aceObj);
            }
        });
        authPermisions.add(PN_AUTHORIZABLE, auth.getID());
        authPermisions.add(PN_ALLOW, allowArray);
        authPermisions.add(PN_DENY, denyArray);
        this.outputBinding = JsonUtil.toString(authPermisions);
    }

    Authorizable checkIsAuthorizableResource(Resource resource) {
        return (Authorizable)resource.adaptTo(Authorizable.class);
    }

    Principal getPrincipalFor(String prinicipalName) {
        Principal principal = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)prinicipalName)) {
                logger.debug("try to find principalId {}", (Object)prinicipalName);
                JackrabbitSession jackrabbitSession = (JackrabbitSession)this.session;
                PrincipalManager principalManager = jackrabbitSession.getPrincipalManager();
                principal = principalManager.getPrincipal(prinicipalName);
            }
        }
        catch (Exception e) {
            logger.error("unable to get principal for principalName {} ", (Object)prinicipalName, (Object)e);
        }
        return principal;
    }

    private void addAccessControlEntry(Resource resource, Principal principal) throws RepositoryException {
        if (logger.isInfoEnabled()) {
            logger.info("adding privileges {} for principal {} allow {} deny {} with dryRun {} ", new Object[]{ArrayUtils.toString((Object)this.privileges), principal.getName(), this.allow, this.deny, this.isDryRun()});
        }
        if (!this.isDryRun()) {
            if (this.allow) {
                AccessControlUtils.addAccessControlEntry((Session)this.session, (String)resource.getPath(), (Principal)principal, (Privilege[])this.privileges, (boolean)true);
            } else if (this.deny) {
                AccessControlUtils.addAccessControlEntry((Session)this.session, (String)resource.getPath(), (Principal)principal, (Privilege[])this.privileges, (boolean)false);
            }
        }
    }

    private String[] processPrivilegesInput(String[] privilegesInput) {
        String expr = this.bindings.instantiateExpression(ArrayUtils.toString((Object)privilegesInput));
        if (expr.indexOf("[") > -1 && expr.indexOf("]") > -1) {
            return (String[])Arrays.stream(expr.substring(expr.indexOf("[") + 1, expr.indexOf("]")).split(",")).map(String::trim).toArray(String[]::new);
        }
        return privilegesInput;
    }
}

