/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.compiler.expression.nodes;

import org.apache.sling.scripting.sightly.compiler.expression.NodeVisitor;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.Atom;

public final class BooleanConstant
implements Atom {
    private String rawText;
    public static final BooleanConstant FALSE = new BooleanConstant(Boolean.toString(false));
    public static final BooleanConstant TRUE = new BooleanConstant(Boolean.toString(true));

    public BooleanConstant(String text) {
        this.rawText = text;
    }

    public BooleanConstant(boolean value) {
        this(Boolean.toString(value));
    }

    public boolean getValue() {
        return Boolean.parseBoolean(this.rawText);
    }

    @Override
    public String getText() {
        return this.rawText;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.evaluate(this);
    }

    public String toString() {
        return "BooleanConstant{rawText='" + this.rawText + '\'' + '}';
    }
}

