/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.frontend;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.impl.plugin.AggregatePluginInvoke;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

public class ElementContext {
    private final String tagName;
    private final String openTagStartMarkup;
    private final List<PrioritizedInvoke> invokeList = new ArrayList<PrioritizedInvoke>();
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private PluginInvoke aggregateInvoke;

    public ElementContext(String tagName, String openTagStartMarkup) {
        this.tagName = tagName;
        this.openTagStartMarkup = openTagStartMarkup;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getOpenTagStartMarkup() {
        return this.openTagStartMarkup;
    }

    public void addPlugin(PluginInvoke invoke, int priority) {
        this.invokeList.add(new PrioritizedInvoke(invoke, priority));
    }

    public void addAttribute(String name, String value, char quoteChar) {
        this.attributes.add(new Attribute(name, value, quoteChar));
    }

    public void addPluginCall(String name, PluginCallInfo info, Expression expression) {
        this.attributes.add(new Attribute(name, new AbstractMap.SimpleEntry<PluginCallInfo, Expression>(info, expression), '0'));
    }

    public Iterable<Attribute> getAttributes() {
        return this.attributes;
    }

    public PluginInvoke pluginInvoke() {
        if (this.aggregateInvoke == null) {
            Collections.sort(this.invokeList);
            ArrayList<PluginInvoke> result = new ArrayList<PluginInvoke>();
            for (PrioritizedInvoke prioritizedInvoke : this.invokeList) {
                result.add(prioritizedInvoke.invoke);
            }
            this.aggregateInvoke = new AggregatePluginInvoke(result);
        }
        return this.aggregateInvoke;
    }

    private static final class PrioritizedInvoke
    implements Comparable<PrioritizedInvoke> {
        private final PluginInvoke invoke;
        private final int priority;

        private PrioritizedInvoke(PluginInvoke invoke, int priority) {
            this.invoke = invoke;
            this.priority = priority;
        }

        @Override
        public int compareTo(PrioritizedInvoke o) {
            if (this.priority < o.priority) {
                return -1;
            }
            if (this.priority == o.priority) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PrioritizedInvoke)) {
                return false;
            }
            PrioritizedInvoke that = (PrioritizedInvoke)obj;
            return this.priority == that.priority;
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 42;
        }
    }

    public static class Attribute {
        private String name;
        private Object value;
        private char quoteChar;

        public Attribute(String name, Object value, char quoteChar) {
            this.name = name;
            this.value = value;
            this.quoteChar = quoteChar;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public char getQuoteChar() {
            return this.quoteChar;
        }
    }
}

