/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.sling.testing.mock.jcr.MockUserManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockPrincipalManager
implements PrincipalManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected MockUserManager mockUserManager;
    private Principal everyone = () -> "everyone";

    MockPrincipalManager(MockUserManager mockUserManager) {
        this.mockUserManager = mockUserManager;
    }

    @NotNull
    public PrincipalIterator findPrincipals(@Nullable String simpleFilter) {
        return this.findPrincipals(simpleFilter, 3);
    }

    @NotNull
    public PrincipalIterator findPrincipals(@Nullable String simpleFilter, int searchType) {
        HashSet<Principal> principals;
        block3: {
            principals = new HashSet<Principal>();
            try {
                @NotNull Iterator<Authorizable> authorizables = this.mockUserManager.findAuthorizables("rep:principalName", simpleFilter, searchType);
                while (authorizables.hasNext()) {
                    Authorizable next = authorizables.next();
                    principals.add(next.getPrincipal());
                }
            }
            catch (RepositoryException e) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug("Failed to find principals", (Throwable)e);
            }
        }
        return new PrincipalIteratorAdapter(principals);
    }

    @NotNull
    public Principal getEveryone() {
        return this.everyone;
    }

    @NotNull
    public PrincipalIterator getGroupMembership(@NotNull Principal principal) {
        HashSet<Principal> groups;
        block4: {
            groups = new HashSet<Principal>();
            try {
                @Nullable Authorizable authorizable = this.mockUserManager.getAuthorizable(principal);
                if (authorizable != null) {
                    @NotNull Iterator memberOf = authorizable.memberOf();
                    while (memberOf.hasNext()) {
                        groups.add(((Group)memberOf.next()).getPrincipal());
                    }
                }
            }
            catch (RepositoryException e) {
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.debug("Failed to get group membership", (Throwable)e);
            }
        }
        return new PrincipalIteratorAdapter(groups);
    }

    @Nullable
    public Principal getPrincipal(@NotNull String principalName) {
        Principal value;
        block3: {
            value = null;
            try {
                @Nullable Authorizable authorizable = this.mockUserManager.getAuthorizable(principalName);
                if (authorizable != null) {
                    value = authorizable.getPrincipal();
                }
            }
            catch (RepositoryException e) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug("Failed to get principal", (Throwable)e);
            }
        }
        return value;
    }

    @NotNull
    public PrincipalIterator getPrincipals(int searchType) {
        HashSet<Principal> principals;
        block3: {
            principals = new HashSet<Principal>();
            try {
                @NotNull Set<Authorizable> authorizables = this.mockUserManager.all(searchType);
                for (Authorizable authorizable : authorizables) {
                    principals.add(authorizable.getPrincipal());
                }
            }
            catch (RepositoryException e) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug("Failed to get principals", (Throwable)e);
            }
        }
        return new PrincipalIteratorAdapter(principals);
    }

    public boolean hasPrincipal(@NotNull String principalName) {
        boolean value;
        block2: {
            value = false;
            try {
                value = this.mockUserManager.getAuthorizable(principalName) != null;
            }
            catch (RepositoryException e) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug("Failed to determine principal exists", (Throwable)e);
            }
        }
        return value;
    }

    static class PrincipalIteratorAdapter
    extends RangeIteratorAdapter
    implements PrincipalIterator {
        public PrincipalIteratorAdapter(Collection<Principal> collection) {
            super(collection);
        }

        @NotNull
        public Principal nextPrincipal() {
            return (Principal)this.next();
        }
    }
}

