/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.PropertyMetaData;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Payload;

public final class SingletonTokenStream
extends TokenStream {
    private String value;
    private Payload payload;
    private boolean consumed = false;

    public SingletonTokenStream(String value, int type) {
        this.value = value;
        this.payload = new Payload(new PropertyMetaData(type).toByteArray());
    }

    public SingletonTokenStream(Token t) {
        this.value = t.term();
        this.payload = t.getPayload();
    }

    public Token next(Token reusableToken) throws IOException {
        if (this.consumed) {
            return null;
        }
        reusableToken.clear();
        reusableToken.setTermBuffer(this.value);
        reusableToken.setPayload(this.payload);
        reusableToken.setStartOffset(0);
        reusableToken.setEndOffset(this.value.length());
        this.consumed = true;
        return reusableToken;
    }

    public void reset() throws IOException {
        this.consumed = false;
    }

    public void close() throws IOException {
        this.consumed = true;
        this.value = null;
        this.payload = null;
    }
}

