/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.serversetup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.apache.sling.testing.tools.serversetup.SetupPhase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSetup {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Object> context = new HashMap<String, Object>();
    private final List<String> phasesToRun = new ArrayList<String>();
    private Properties config;
    public static final String PROP_NAME_PREFIX = "server.setup";
    public static final String PHASES_TO_RUN_PROP = "server.setup.phases";
    public static final String SHUTDOWN_ID_SUFFIX = ".shutdown";
    private final Map<String, SetupPhase> phases = new HashMap<String, SetupPhase>();
    private final Set<String> donePhases = new HashSet<String>();
    private final Set<String> failedPhases = new HashSet<String>();
    public static final String SERVER_BASE_URL = "server.base.url";
    private Thread shutdownHook;

    public synchronized void setupTestServer() throws Exception {
        if (this.donePhases.isEmpty() && this.log.isInfoEnabled()) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.addAll(this.phases.keySet());
            Collections.sort(ids);
            this.log.info("Will run SetupPhases {} out of {}", this.phasesToRun, ids);
        }
        this.runRemainingPhases(true);
        if (this.shutdownHook == null) {
            this.shutdownHook = new Thread(this.getClass().getSimpleName() + "Shutdown"){

                @Override
                public void run() {
                    try {
                        ServerSetup.this.shutdown();
                    }
                    catch (Exception e) {
                        ServerSetup.this.log.warn("Exception in shutdown hook", (Throwable)e);
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            this.log.info("Shutdown hook added to run shutdown phases");
        }
    }

    private void runRemainingPhases(boolean isStartup) throws Exception {
        String mode;
        String string = mode = isStartup ? "startup" : "shutdown";
        if (isStartup && !this.failedPhases.isEmpty()) {
            throw new SetupException("Some SetupPhases previously failed: " + this.failedPhases);
        }
        for (String id : this.phasesToRun) {
            SetupPhase p = this.phases.get(id);
            if (this.donePhases.contains(id)) {
                this.log.debug("SetupPhase ({}) with id {} already ran, ignored", (Object)mode, (Object)id);
                continue;
            }
            if (p == null) {
                this.log.info("SetupPhase ({}) with id {} not found, ignored", (Object)mode, (Object)id);
                this.donePhases.add(id);
                continue;
            }
            if (p.isStartupPhase() != isStartup) continue;
            this.log.info("Executing {} phase: {}", (Object)mode, (Object)p);
            try {
                p.run(this);
            }
            catch (Exception e) {
                this.failedPhases.add(id);
                throw e;
            }
            catch (AssertionFailedError ae) {
                this.failedPhases.add(id);
                throw new Exception("AssertionFailedError in runRemainingPhases", ae);
            }
            finally {
                this.donePhases.add(id);
            }
        }
    }

    public void shutdown() throws Exception {
        this.runRemainingPhases(false);
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public void setConfig(Properties props) {
        this.config = props;
        String str = props.getProperty(PHASES_TO_RUN_PROP);
        this.phasesToRun.clear();
        String[] phases = str == null ? new String[]{} : str.split(",");
        for (int i = 0; i < phases.length; ++i) {
            phases[i] = phases[i].trim();
        }
        this.phasesToRun.addAll(Arrays.asList(phases));
        if (this.phasesToRun.isEmpty()) {
            this.log.warn("No setup phases defined, {} is empty, is that on purpose?", (Object)PHASES_TO_RUN_PROP);
        }
        this.donePhases.clear();
        this.failedPhases.clear();
    }

    public Properties getConfig() {
        return this.config;
    }

    public List<String> getPhasesToRun() {
        return Collections.unmodifiableList(this.phasesToRun);
    }

    public void addSetupPhase(SetupPhase p) throws SetupException {
        if (this.phases.containsKey(p.getId())) {
            throw new SetupException("A SetupPhase with ID=" + p.getId() + " is already in our list:" + this.phases.keySet());
        }
        this.phases.put(p.getId(), p);
    }

    public static class SetupException
    extends Exception {
        public SetupException(String reason) {
            super(reason);
        }

        public SetupException(String reason, Throwable cause) {
            super(reason, cause);
        }
    }
}

