/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference;

import java.util.Map;
import org.owasp.esapi.AccessControlRule;
import org.owasp.esapi.AccessController;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.errors.AccessControlException;
import org.owasp.esapi.reference.accesscontrol.policyloader.ACRPolicyFileLoader;
import org.owasp.esapi.reference.accesscontrol.policyloader.PolicyDTO;

public class DefaultAccessController
implements AccessController {
    private Map ruleMap;
    private static volatile AccessController singletonInstance = null;
    protected final Logger logger = ESAPI.getLogger("DefaultAccessController");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AccessController getInstance() throws AccessControlException {
        if (singletonInstance != null) return singletonInstance;
        Class<DefaultAccessController> clazz = DefaultAccessController.class;
        synchronized (DefaultAccessController.class) {
            if (singletonInstance != null) return singletonInstance;
            singletonInstance = new DefaultAccessController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonInstance;
        }
    }

    private DefaultAccessController() throws AccessControlException {
        ACRPolicyFileLoader policyDescriptor = new ACRPolicyFileLoader();
        PolicyDTO policyDTO = policyDescriptor.load();
        this.ruleMap = policyDTO.getAccessControlRules();
    }

    public boolean isAuthorized(Object key, Object runtimeParameter) {
        try {
            AccessControlRule rule = (AccessControlRule)this.ruleMap.get(key);
            if (rule == null) {
                throw new AccessControlException("Access Denied", "AccessControlRule was not found for key: " + key);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(Logger.EVENT_SUCCESS, "Evaluating Authorization Rule \"" + key + "\" Using class: " + rule.getClass().getCanonicalName());
            }
            return rule.isAuthorized(runtimeParameter);
        }
        catch (Exception e) {
            try {
                throw new AccessControlException("Access Denied", "An unhandled Exception was caught, so access is denied.", e);
            }
            catch (AccessControlException ace) {
                return false;
            }
        }
    }

    public void assertAuthorized(Object key, Object runtimeParameter) throws AccessControlException {
        boolean isAuthorized;
        try {
            AccessControlRule rule = (AccessControlRule)this.ruleMap.get(key);
            if (rule == null) {
                throw new AccessControlException("Access Denied", "AccessControlRule was not found for key: " + key);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(Logger.EVENT_SUCCESS, "Asserting Authorization Rule \"" + key + "\" Using class: " + rule.getClass().getCanonicalName());
            }
            isAuthorized = rule.isAuthorized(runtimeParameter);
        }
        catch (Exception e) {
            throw new AccessControlException("Access Denied", "An unhandled Exception was caught, so access is denied.AccessControlException.", e);
        }
        if (!isAuthorized) {
            throw new AccessControlException("Access Denied", "Access Denied for key: " + key + " runtimeParameter: " + runtimeParameter);
        }
    }

    public void assertAuthorizedForData(String action, Object data) throws AccessControlException {
        this.assertAuthorized("AC 1.0 Data", new Object[]{action, data});
    }

    public void assertAuthorizedForFile(String filepath) throws AccessControlException {
        this.assertAuthorized("AC 1.0 File", new Object[]{filepath});
    }

    public void assertAuthorizedForFunction(String functionName) throws AccessControlException {
        this.assertAuthorized("AC 1.0 Function", new Object[]{functionName});
    }

    public void assertAuthorizedForService(String serviceName) throws AccessControlException {
        this.assertAuthorized("AC 1.0 Service", new Object[]{serviceName});
    }

    public void assertAuthorizedForURL(String url) throws AccessControlException {
        this.assertAuthorized("AC 1.0 URL", new Object[]{url});
    }

    public boolean isAuthorizedForData(String action, Object data) {
        return this.isAuthorized("AC 1.0 Data", new Object[]{action, data});
    }

    public boolean isAuthorizedForFile(String filepath) {
        return this.isAuthorized("AC 1.0 File", new Object[]{filepath});
    }

    public boolean isAuthorizedForFunction(String functionName) {
        return this.isAuthorized("AC 1.0 Function", new Object[]{functionName});
    }

    public boolean isAuthorizedForService(String serviceName) {
        return this.isAuthorized("AC 1.0 Service", new Object[]{serviceName});
    }

    public boolean isAuthorizedForURL(String url) {
        return this.isAuthorized("AC 1.0 URL", new Object[]{url});
    }
}

