/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;

public class DateGetYear2Method
extends AbstractSQLMethod {
    @Override
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (!(expr instanceof TemporalExpression)) {
            throw new NucleusException(LOCALISER.msg("060001", (Object)"getYear()", (Object)expr));
        }
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        JavaTypeMapping mapping = storeMgr.getMappingManager().getMapping(String.class);
        SQLExpression yyyy = this.exprFactory.newLiteral(this.stmt, mapping, "YYYY");
        ArrayList<SQLExpression> funcArgs = new ArrayList<SQLExpression>();
        funcArgs.add(expr);
        funcArgs.add(yyyy);
        ArrayList<StringExpression> funcArgs2 = new ArrayList<StringExpression>();
        funcArgs2.add(new StringExpression(this.stmt, mapping, "TO_CHAR", funcArgs));
        return new NumericExpression(this.stmt, this.getMappingForClass(Integer.TYPE), "TO_NUMBER", funcArgs2);
    }
}

