/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.util.Collection;
import java.util.Map;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.JsonModeMarshallException;
import org.directwebremoting.extend.NestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.util.LocalUtil;

public class ObjectOutboundVariable
extends NestedOutboundVariable {
    private final boolean isNamed;
    private final String scriptClassName;
    private Map<String, OutboundVariable> childMap;

    public ObjectOutboundVariable(OutboundContext context, Class<?> type, String scriptClassName) {
        super(context);
        if (context.isJsonMode() && scriptClassName != null) {
            throw new JsonModeMarshallException(type, "Can't used named Javascript objects in JSON mode");
        }
        this.scriptClassName = scriptClassName;
        this.isNamed = scriptClassName != null && scriptClassName.length() > 0;
    }

    public ObjectOutboundVariable(OutboundContext context) {
        super(context);
        this.scriptClassName = null;
        this.isNamed = false;
    }

    @Override
    public void setChildren(Collection<OutboundVariable> children) {
        throw new IllegalStateException("Use ObjectOutboundVariable.setChildren(Map<String, OutboundVariable>)");
    }

    public void setChildren(Map<String, OutboundVariable> childMap) {
        this.childMap = childMap;
        super.setChildren(childMap.values());
    }

    @Override
    public String getDeclareCode() {
        if (this.isInline()) {
            return this.getChildDeclareCodes();
        }
        if (!this.isNamed) {
            return this.getChildDeclareCodes() + "var " + this.getVariableName() + "={};";
        }
        return this.getChildDeclareCodes() + "var " + this.getVariableName() + "=new " + this.scriptClassName + "();";
    }

    @Override
    public String getBuildCode() {
        if (this.isInline()) {
            return this.getChildBuildCodes();
        }
        StringBuffer buildCode = new StringBuffer(this.getChildBuildCodes());
        String variableName = this.getVariableName();
        for (Map.Entry<String, OutboundVariable> entry : this.childMap.entrySet()) {
            String name = entry.getKey();
            OutboundVariable nested = entry.getValue();
            String nestedAssignCode = nested.getAssignCode();
            if (LocalUtil.isSimpleName(name)) {
                buildCode.append(variableName);
                buildCode.append('.');
                buildCode.append(name);
                buildCode.append('=');
                buildCode.append(nestedAssignCode);
                buildCode.append(';');
                continue;
            }
            buildCode.append(variableName);
            buildCode.append("['");
            buildCode.append(name);
            buildCode.append("']=");
            buildCode.append(nestedAssignCode);
            buildCode.append(';');
        }
        buildCode.append("\r\n");
        return buildCode.toString();
    }

    @Override
    public String getAssignCode() {
        if (this.isInline()) {
            StringBuffer buffer = new StringBuffer();
            if (this.isNamed) {
                buffer.append(EnginePrivate.remoteNewObjectFunction() + "(\"");
                buffer.append(this.scriptClassName);
                buffer.append("\",{");
            } else {
                buffer.append('{');
            }
            boolean first = true;
            for (Map.Entry<String, OutboundVariable> entry : this.childMap.entrySet()) {
                String name = entry.getKey();
                OutboundVariable nested = entry.getValue();
                String innerAssignCode = nested.getAssignCode();
                if (!first) {
                    buffer.append(',');
                }
                if (LocalUtil.isSimpleName(name) && !this.isJsonMode()) {
                    buffer.append(name);
                    buffer.append(':');
                    buffer.append(innerAssignCode);
                } else {
                    buffer.append('\"');
                    buffer.append(name);
                    buffer.append("\":");
                    buffer.append(innerAssignCode);
                }
                first = false;
            }
            if (this.isNamed) {
                buffer.append("})");
            } else {
                buffer.append('}');
            }
            return buffer.toString();
        }
        return this.getVariableName();
    }

    public String toString() {
        return "ObjectOutboundVariable:" + this.childMap;
    }
}

