/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.codegen;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.hops.codegen.SpoofCompiler;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.codegen.ByteClassLoader;
import org.apache.sysds.runtime.codegen.SpoofOperator;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.LocalFileUtils;
import org.apache.sysds.utils.Statistics;
import org.codehaus.janino.SimpleCompiler;

public class CodegenUtils {
    private static final Log LOG = LogFactory.getLog((String)CodegenUtils.class.getName());
    private static ConcurrentHashMap<String, Class<?>> _cache = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> _src = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Integer> _CUDA_op_IDs = new ConcurrentHashMap();
    private static ConcurrentHashMap<Integer, String> _CUDA_op_src = new ConcurrentHashMap();
    private static String _workingDir = null;

    public static Class<?> compileClass(String name, String src) {
        Class<?> ret = _cache.get(name);
        if (ret != null) {
            return ret;
        }
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        ret = SpoofCompiler.JAVA_COMPILER == SpoofCompiler.CompilerType.JANINO ? CodegenUtils.compileClassJanino(name, src) : CodegenUtils.compileClassJavac(name, src);
        _cache.put(name, ret);
        if (DMLScript.STATISTICS) {
            Statistics.incrementCodegenClassCompile();
            Statistics.incrementCodegenClassCompileTime(System.nanoTime() - t0);
        }
        return ret;
    }

    public static Class<?> getClass(String name) {
        return CodegenUtils.getClass(name, null);
    }

    public static synchronized Class<?> getClassSync(String name, byte[] classBytes) {
        return CodegenUtils.getClass(name, classBytes);
    }

    public static Class<?> getClass(String name, byte[] classBytes) {
        Class<?> ret = _cache.get(name);
        if (ret != null) {
            return ret;
        }
        ret = SpoofCompiler.JAVA_COMPILER == SpoofCompiler.CompilerType.JANINO ? CodegenUtils.compileClassJanino(name, new String(classBytes)) : CodegenUtils.loadFromClassFile(name, classBytes);
        _cache.put(name, ret);
        return ret;
    }

    public static byte[] getClassData(String name) {
        if (SpoofCompiler.JAVA_COMPILER == SpoofCompiler.CompilerType.JANINO) {
            return _src.get(name).getBytes();
        }
        return CodegenUtils.getClassAsByteArray(name);
    }

    public static void clearClassCache() {
        _cache.clear();
        _src.clear();
    }

    public static void clearClassCache(Class<?> cla) {
        Iterator<Map.Entry<String, Class<?>>> iter = _cache.entrySet().iterator();
        while (iter.hasNext()) {
            if (iter.next().getValue() != cla) continue;
            iter.remove();
        }
    }

    public static SpoofOperator createInstance(Class<?> cla) {
        SpoofOperator ret = null;
        try {
            ret = (SpoofOperator)cla.newInstance();
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return ret;
    }

    public static Integer getCUDAopID(String name) {
        return _CUDA_op_IDs.get(name);
    }

    public static void putCUDAOpID(String name, int id) {
        _CUDA_op_IDs.put(name, id);
    }

    public static void putCUDASource(int id, String src) {
        _CUDA_op_src.put(id, src);
    }

    public static SpoofOperator.SideInput createSideInput(MatrixBlock in) {
        SpoofOperator.SideInput ret = in.isInSparseFormat() || !in.isAllocated() ? new SpoofOperator.SideInput(null, in, in.getNumColumns()) : new SpoofOperator.SideInput(in.getDenseBlock(), null, in.getNumColumns());
        return ret.mdat != null ? new SpoofOperator.SideInputSparseCell(ret) : ret;
    }

    private static Class<?> compileClassJanino(String name, String src) {
        try {
            SimpleCompiler compiler = new SimpleCompiler();
            compiler.cook(src);
            _src.put(name, src);
            return compiler.getClassLoader().loadClass(name);
        }
        catch (Exception ex) {
            LOG.error((Object)("Failed to compile class " + name + ": \n" + src));
            throw new DMLRuntimeException("Failed to compile class " + name + ".", ex);
        }
    }

    /*
     * Exception decompiling
     */
    private static Class<?> compileClassJavac(String name, String src) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class<?> loadFromClassFile(String name, byte[] classBytes) {
        if (classBytes != null) {
            try (ByteClassLoader byteLoader = new ByteClassLoader(new URL[0], CodegenUtils.class.getClassLoader(), classBytes);){
                Class<?> clazz = byteLoader.findClass(name);
                return clazz;
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
        }
        URL runDir = CodegenUtils.class.getProtectionDomain().getCodeSource().getLocation();
        try (URLClassLoader classLoader = new URLClassLoader(new URL[]{new File(_workingDir).toURI().toURL(), runDir}, CodegenUtils.class.getClassLoader());){
            Class<?> clazz = classLoader.loadClass(name);
            return clazz;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
    }

    private static byte[] getClassAsByteArray(String name) {
        byte[] byArray;
        String classAsPath = name.replace('.', '/') + ".class";
        URLClassLoader classLoader = null;
        InputStream stream = null;
        try {
            URL runDir = CodegenUtils.class.getProtectionDomain().getCodeSource().getLocation();
            classLoader = new URLClassLoader(new URL[]{new File(_workingDir).toURI().toURL(), runDir}, CodegenUtils.class.getClassLoader());
            stream = classLoader.getResourceAsStream(classAsPath);
            byArray = IOUtils.toByteArray((InputStream)stream);
        }
        catch (IOException e) {
            try {
                throw new DMLRuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtilFunctions.closeSilently(classLoader);
                IOUtilFunctions.closeSilently(stream);
                throw throwable;
            }
        }
        IOUtilFunctions.closeSilently(classLoader);
        IOUtilFunctions.closeSilently(stream);
        return byArray;
    }

    private static void createWorkingDir() {
        if (_workingDir != null) {
            return;
        }
        String tmp = LocalFileUtils.getWorkingDir("codegen");
        LocalFileUtils.createLocalFileIfNotExist(tmp);
        _workingDir = tmp;
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i)) || str.charAt(i) == '-' && i == 0) continue;
            return false;
        }
        return true;
    }

    public static String printWithLineNumber(String src) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        Scanner scanner = new Scanner(src);
        int line_count = 0;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            sb.append(line_count++ + ": " + line + System.lineSeparator());
        }
        scanner.close();
        return sb.toString();
    }
}

