/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.readers;

import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderColumnSelectionSparseTransposed
extends ReaderColumnSelection {
    private SparseBlock a;
    private int[] sparsePos = null;

    public ReaderColumnSelectionSparseTransposed(MatrixBlock data, int[] colIndexes) {
        super(colIndexes, data.getNumColumns());
        this.sparsePos = new int[colIndexes.length];
        this.a = data.getSparseBlock();
        for (int i = 0; i < colIndexes.length; ++i) {
            this.sparsePos[i] = this.a.isEmpty(this._colIndexes[i]) ? -1 : this.a.pos(this._colIndexes[i]);
        }
    }

    @Override
    protected DblArray getNextRow() {
        if (this._lastRow == this._numRows - 1) {
            return null;
        }
        ++this._lastRow;
        boolean zeroResult = true;
        for (int i = 0; i < this._colIndexes.length; ++i) {
            int colidx = this._colIndexes[i];
            if (this.sparsePos[i] == -1) continue;
            int alen = this.a.size(colidx) + this.a.pos(colidx);
            int[] aix = this.a.indexes(colidx);
            double[] avals = this.a.values(colidx);
            while (this.sparsePos[i] < alen && aix[this.sparsePos[i]] < this._lastRow) {
                int n = i;
                this.sparsePos[n] = this.sparsePos[n] + 1;
            }
            if (this.sparsePos[i] >= alen) {
                this.sparsePos[i] = -1;
                this.reusableArr[i] = 0.0;
                continue;
            }
            if (aix[this.sparsePos[i]] == this._lastRow) {
                this.reusableArr[i] = avals[this.sparsePos[i]];
                zeroResult = false;
                continue;
            }
            this.reusableArr[i] = 0.0;
        }
        return zeroResult ? this.emptyReturn : this.reusableReturn;
    }
}

