/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.IOException;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.bitmap.ABitmap;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToBit;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToChar;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToInt;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public final class MapToFactory {
    public static AMapToData create(int size, ABitmap ubm) {
        if (ubm == null || ubm.isEmpty()) {
            return null;
        }
        return MapToFactory.create(size, ubm.containsZero(), ubm.getOffsetList());
    }

    public static AMapToData create(int size, boolean zeros, IntArrayList[] values) {
        AMapToData _data = MapToFactory.create(size, values.length + (zeros ? 1 : 0));
        if (zeros) {
            _data.fill(values.length);
        }
        for (int i = 0; i < values.length; ++i) {
            IntArrayList tmpList = values[i];
            int sz = tmpList.size();
            for (int k = 0; k < sz; ++k) {
                _data.set(tmpList.get(k), i);
            }
        }
        return _data;
    }

    public static AMapToData create(int size, int numTuples) {
        if (numTuples <= 1) {
            return new MapToBit(numTuples, size);
        }
        if (numTuples < 256) {
            return new MapToByte(numTuples, size);
        }
        if (numTuples <= 65535) {
            return new MapToChar(numTuples, size);
        }
        return new MapToInt(numTuples, size);
    }

    public static AMapToData resize(AMapToData d, int numTuples) {
        AMapToData ret;
        int size = d.size();
        if (d instanceof MapToBit) {
            return d;
        }
        if (numTuples <= 1) {
            ret = new MapToBit(numTuples, size);
        } else {
            if (d instanceof MapToByte) {
                return d;
            }
            if (numTuples < 256) {
                ret = new MapToByte(numTuples, size);
            } else {
                if (d instanceof MapToChar) {
                    return d;
                }
                if (numTuples <= 65535) {
                    ret = new MapToChar(numTuples, size);
                } else {
                    return d;
                }
            }
        }
        ret.copy(d);
        return ret;
    }

    public static long estimateInMemorySize(int size, int numTuples) {
        if (numTuples <= 1) {
            return MapToBit.getInMemorySize(size);
        }
        if (numTuples < 256) {
            return MapToByte.getInMemorySize(size);
        }
        if (numTuples <= 65535) {
            return MapToChar.getInMemorySize(size);
        }
        return MapToInt.getInMemorySize(size);
    }

    public static AMapToData readIn(DataInput in) throws IOException {
        MAP_TYPE t = MAP_TYPE.values()[in.readByte()];
        switch (t) {
            case BIT: {
                return MapToBit.readFields(in);
            }
            case BYTE: {
                return MapToByte.readFields(in);
            }
            case CHAR: {
                return MapToChar.readFields(in);
            }
        }
        return MapToInt.readFields(in);
    }

    public static AMapToData join(AMapToData left, AMapToData right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        int nVL = left.getUnique();
        int nVR = right.getUnique();
        int size = left.size();
        long maxUnique = (long)nVL * (long)nVR;
        if (maxUnique > Integer.MAX_VALUE) {
            throw new DMLCompressionException("Joining impossible using linearized join, since each side has a large number of unique values");
        }
        if (size != right.size()) {
            throw new DMLCompressionException("Invalid input maps to join, must contain same number of rows");
        }
        return MapToFactory.computeJoin(left, right, size, nVL, (int)maxUnique);
    }

    private static AMapToData computeJoin(AMapToData left, AMapToData right, int size, int nVL, int maxUnique) {
        AMapToData tmp = MapToFactory.create(size, maxUnique);
        return MapToFactory.computeJoinUsingLinearizedMap(tmp, left, right, size, nVL, maxUnique);
    }

    private static AMapToData computeJoinUsingLinearizedMap(AMapToData tmp, AMapToData left, AMapToData right, int size, int nVL, int maxUnique) {
        int[] map = new int[maxUnique];
        int newUID = 1;
        for (int i = 0; i < size; ++i) {
            int nv = left.getIndex(i) + right.getIndex(i) * nVL;
            int mapV = map[nv];
            if (mapV == 0) {
                tmp.set(i, newUID - 1);
                map[nv] = newUID++;
                continue;
            }
            tmp.set(i, mapV - 1);
        }
        tmp.setUnique(newUID - 1);
        return tmp;
    }

    public static enum MAP_TYPE {
        BIT,
        BYTE,
        CHAR,
        INT;

    }
}

