/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.base;

import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

public abstract class BaseClientElement
implements ClientElement {
    private Element element;
    private String clientId;
    @Inject
    protected ComponentResources resources;
    @Environmental
    protected JavaScriptSupport javaScriptSupport;

    protected void storeElement(Element element) {
        assert (element != null);
        this.element = element;
        this.clientId = null;
    }

    @Override
    public String getClientId() {
        if (this.clientId == null) {
            if (this.element == null) {
                throw new IllegalStateException(String.format("Component %s has not yet rendered; it is not possible to request its client id until after it has begun rendering.", this.resources.getCompleteId()));
            }
            this.clientId = this.javaScriptSupport.allocateClientId(this.resources);
            this.element.forceAttributes("id", this.clientId);
        }
        return this.clientId;
    }
}

