/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalProduct;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;

public final class TraversalUtil {
    private TraversalUtil() {
    }

    public static <S, E> E apply(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal) {
        Traverser<S> split = TraversalUtil.prepare(traverser, traversal);
        try {
            Object e = traversal.next();
            return e;
        }
        catch (NoSuchElementException e) {
            String clazzOfTraverserValue = null == split.get() ? "null" : split.get().getClass().getSimpleName();
            throw new IllegalArgumentException(String.format("The provided traverser does not map to a value: %s[%s]->%s[%s] parent[%s]", split, clazzOfTraverserValue, traversal, traversal.getClass().getSimpleName(), traversal.getParent().asStep().getTraversal()));
        }
        finally {
            CloseableIterator.closeIterator(traversal);
        }
    }

    public static <S, E> E apply(S start, Traversal.Admin<S, E> traversal) {
        traversal.reset();
        traversal.addStart(traversal.getTraverserGenerator().generate(start, traversal.getStartStep(), 1L));
        try {
            Object e = traversal.next();
            return e;
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("The provided start does not map to a value: " + start + "->" + traversal);
        }
        finally {
            CloseableIterator.closeIterator(traversal);
        }
    }

    public static <S, E> E applyNullable(S start, Traversal.Admin<S, E> traversal) {
        return (E)(null == traversal ? start : TraversalUtil.apply(start, traversal));
    }

    public static <S, E> E applyNullable(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal) {
        return (E)(null == traversal ? traverser.get() : TraversalUtil.apply(traverser, traversal));
    }

    public static <S, E> Iterator<E> applyAll(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal) {
        TraversalUtil.prepare(traverser, traversal);
        return traversal;
    }

    public static <S, E> Iterator<E> applyAll(S start, Traversal.Admin<S, E> traversal) {
        traversal.reset();
        traversal.addStart(traversal.getTraverserGenerator().generate(start, traversal.getStartStep(), 1L));
        return traversal;
    }

    public static <S, E> boolean test(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal, E end) {
        if (null == end) {
            return TraversalUtil.test(traverser, traversal);
        }
        TraversalUtil.prepare(traverser, traversal);
        Step<?, E> endStep = traversal.getEndStep();
        boolean result = false;
        while (traversal.hasNext()) {
            if (!((Traverser.Admin)endStep.next()).get().equals(end)) continue;
            result = true;
            break;
        }
        CloseableIterator.closeIterator(traversal);
        return result;
    }

    public static <S, E> TraversalProduct produce(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal) {
        if (null == traversal) {
            return new TraversalProduct(traverser.get());
        }
        TraversalUtil.prepare(traverser, traversal);
        try {
            if (traversal.hasNext()) {
                TraversalProduct traversalProduct = new TraversalProduct(traversal.next());
                return traversalProduct;
            }
            TraversalProduct traversalProduct = TraversalProduct.UNPRODUCTIVE;
            return traversalProduct;
        }
        finally {
            CloseableIterator.closeIterator(traversal);
        }
    }

    public static <S, E> TraversalProduct produce(S start, Traversal.Admin<S, E> traversal) {
        if (null == traversal) {
            return new TraversalProduct(start);
        }
        traversal.reset();
        traversal.addStart(traversal.getTraverserGenerator().generate(start, traversal.getStartStep(), 1L));
        try {
            if (traversal.hasNext()) {
                TraversalProduct traversalProduct = new TraversalProduct(traversal.next());
                return traversalProduct;
            }
            TraversalProduct traversalProduct = TraversalProduct.UNPRODUCTIVE;
            return traversalProduct;
        }
        finally {
            CloseableIterator.closeIterator(traversal);
        }
    }

    public static <S, E> boolean test(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal) {
        TraversalUtil.prepare(traverser, traversal);
        boolean val = traversal.hasNext();
        CloseableIterator.closeIterator(traversal);
        return val;
    }

    public static <S, E> boolean test(S start, Traversal.Admin<S, E> traversal, E end) {
        if (null == end) {
            return TraversalUtil.test(start, traversal);
        }
        traversal.reset();
        traversal.addStart(traversal.getTraverserGenerator().generate(start, traversal.getStartStep(), 1L));
        Step<?, E> endStep = traversal.getEndStep();
        boolean result = false;
        while (traversal.hasNext()) {
            if (!((Traverser.Admin)endStep.next()).get().equals(end)) continue;
            result = true;
            break;
        }
        CloseableIterator.closeIterator(traversal);
        return result;
    }

    public static <S, E> boolean test(S start, Traversal.Admin<S, E> traversal) {
        traversal.reset();
        traversal.addStart(traversal.getTraverserGenerator().generate(start, traversal.getStartStep(), 1L));
        boolean result = traversal.hasNext();
        CloseableIterator.closeIterator(traversal);
        return result;
    }

    public static <S, E> Traverser<S> prepare(Traverser.Admin<S> traverser, Traversal.Admin<S, E> traversal) {
        Traverser.Admin<S> split = traverser.split();
        split.setSideEffects(traversal.getSideEffects());
        split.setBulk(1L);
        traversal.reset();
        traversal.addStart(split);
        return split;
    }
}

