/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import ojb.broker.Identity;
import ojb.broker.ManageableCollection;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.CollectionDescriptor;
import ojb.broker.metadata.DescriptorRepository;
import ojb.broker.metadata.ObjectReferenceDescriptor;
import ojb.broker.util.ArrayIterator;
import ojb.odmg.DatabaseImpl;
import ojb.odmg.ObjectEnvelope;
import ojb.odmg.ObjectEnvelopeTable;
import ojb.odmg.TransactionTable;
import ojb.odmg.locking.LockManager;
import ojb.odmg.locking.LockManagerFactory;
import org.odmg.LockNotGrantedException;
import org.odmg.Transaction;
import org.odmg.TransactionAbortedException;
import org.odmg.TransactionInProgressException;
import org.odmg.TransactionNotInProgressException;

public class TransactionImpl
implements Transaction {
    private static String timestamp = Long.toHexString(System.currentTimeMillis());
    private static long txCount = 0L;
    private String id;
    private String longId = null;
    private Hashtable myNrm = null;
    private boolean useWriteLocks;
    private ObjectEnvelopeTable objectEnvelopeTable = null;
    private TransactionTable txTable = null;
    private DescriptorRepository dr = DescriptorRepository.getInstance();
    private boolean _isOpen = false;
    private DatabaseImpl curDB;
    static /* synthetic */ Class class$ojb$odmg$TransactionImpl;

    public String getGUID() {
        if (this.longId == null) {
            String hostname;
            try {
                hostname = InetAddress.getLocalHost().toString();
            }
            catch (UnknownHostException e) {
                hostname = "localhost";
            }
            this.longId = hostname + ":" + timestamp + ":" + this.id;
        }
        return this.longId;
    }

    public boolean isOpen() {
        return this._isOpen;
    }

    public void join() {
        this.txTable.remove(Thread.currentThread());
        this.txTable.put(Thread.currentThread(), this);
    }

    public void lock(Object obj, int lockMode) throws LockNotGrantedException {
        if (!this._isOpen) {
            throw new TransactionNotInProgressException();
        }
        LockManager lm = LockManagerFactory.getLockManager();
        if (lockMode == 1) {
            if (!lm.readLock(this, obj)) {
                throw new LockNotGrantedException("Can not lock " + obj + " for READ");
            }
        } else if (lockMode == 4) {
            if (!lm.writeLock(this, obj)) {
                throw new LockNotGrantedException("Can not lock " + obj + " for WRITE");
            }
        } else if (lockMode == 2 && !lm.upgradeLock(this, obj)) {
            throw new LockNotGrantedException("Can not lock " + obj + " for UPGRADE");
        }
        try {
            this.register(obj, lockMode);
        }
        catch (Throwable t) {
            throw new LockNotGrantedException(t.getMessage());
        }
    }

    public void leave() {
        this.txTable.remove(Thread.currentThread());
    }

    private synchronized void doCommit() throws TransactionAbortedException {
        ObjectEnvelope item;
        Enumeration enumeration = this.objectEnvelopeTable.elements();
        while (enumeration.hasMoreElements()) {
            item = (ObjectEnvelope)enumeration.nextElement();
            item.beforeCommit();
        }
        this.objectEnvelopeTable.commit();
        enumeration = this.objectEnvelopeTable.elements();
        while (enumeration.hasMoreElements()) {
            item = (ObjectEnvelope)enumeration.nextElement();
            item.afterCommit();
        }
    }

    private synchronized void doAbort() {
        ObjectEnvelope item;
        Enumeration objectsToAbort = this.objectEnvelopeTable.elements();
        while (objectsToAbort.hasMoreElements()) {
            item = (ObjectEnvelope)objectsToAbort.nextElement();
            item.beforeAbort();
        }
        this.objectEnvelopeTable.rollback();
        objectsToAbort = this.objectEnvelopeTable.elements();
        while (objectsToAbort.hasMoreElements()) {
            item = (ObjectEnvelope)objectsToAbort.nextElement();
            item.afterAbort();
        }
    }

    private synchronized void doClose() {
        Enumeration enumeration = this.objectEnvelopeTable.elements();
        while (enumeration.hasMoreElements()) {
            this.removeLock(((ObjectEnvelope)enumeration.nextElement()).getObject(), 4);
        }
        this._isOpen = false;
    }

    public void checkpoint() {
        if (!this._isOpen) {
            throw new TransactionNotInProgressException();
        }
        try {
            this.doCommit();
        }
        catch (Exception e) {
            this.doAbort();
        }
    }

    public boolean tryLock(Object obj, int lockMode) {
        if (!this._isOpen) {
            throw new TransactionNotInProgressException();
        }
        try {
            this.lock(obj, lockMode);
            return true;
        }
        catch (LockNotGrantedException ex) {
            return false;
        }
    }

    private void removeLock(Object obj, int lockType) {
        LockManagerFactory.getLockManager().releaseLock(this, obj);
    }

    public void commit() {
        if (!this._isOpen) {
            throw new TransactionNotInProgressException();
        }
        try {
            this.doCommit();
        }
        catch (TransactionAbortedException ex) {
            this.doAbort();
        }
        this.doClose();
    }

    public void abort() {
        if (!this._isOpen) {
            throw new TransactionNotInProgressException();
        }
        this.doAbort();
        this.doClose();
    }

    public synchronized void begin() {
        if (this._isOpen) {
            throw new TransactionInProgressException();
        }
        this.objectEnvelopeTable = new ObjectEnvelopeTable(this);
        this.myNrm = new Hashtable();
        this._isOpen = true;
    }

    public TransactionImpl(TransactionTable theTxTable, DatabaseImpl theCurrentDB) {
        Class clazz = class$ojb$odmg$TransactionImpl == null ? (class$ojb$odmg$TransactionImpl = TransactionImpl.class$("ojb.odmg.TransactionImpl")) : class$ojb$odmg$TransactionImpl;
        synchronized (clazz) {
        }
        this.id = Long.toHexString(++txCount);
        this.txTable = theTxTable;
        this.curDB = theCurrentDB;
        this.useWriteLocks = PersistenceBrokerFactory.getConfiguration().islockAssociationAsWrites();
    }

    public void markDelete(Object anObject) {
        ObjectEnvelope otw = this.objectEnvelopeTable.get(anObject);
        otw.setModificationState(otw.getModificationState().markDelete());
    }

    private void register(Object newTxObject, int lockMode) throws LockNotGrantedException, PersistenceBrokerException, IllegalAccessException {
        if (!this.objectEnvelopeTable.contains(newTxObject)) {
            this.objectEnvelopeTable.put(newTxObject, new ObjectEnvelope(newTxObject));
            ClassDescriptor cld = DescriptorRepository.getInstance().getDescriptorFor(newTxObject.getClass());
            int assLockMode = lockMode;
            if (!this.useWriteLocks) {
                assLockMode = 1;
            }
            this.lockReferences(cld, newTxObject, assLockMode);
            this.lockCollections(cld, newTxObject, assLockMode);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void lockCollections(ClassDescriptor cld, Object newTxObject, int lockMode) throws IllegalAccessException, PersistenceBrokerException {
        Iterator i = ((AbstractList)cld.getCollectionDescriptors()).iterator();
        while (i.hasNext()) {
            ArrayIterator colIterator;
            CollectionDescriptor cds = (CollectionDescriptor)i.next();
            Object col = cds.getPersistentField().get(newTxObject);
            if (col == null) continue;
            if (col instanceof ManageableCollection) {
                colIterator = ((ManageableCollection)col).ojbIterator();
            } else if (col instanceof Collection) {
                colIterator = ((Collection)col).iterator();
            } else {
                if (!col.getClass().isArray()) {
                    throw new RuntimeException(col.getClass() + " can not be managed by OJB, use Array, Collection or ManageableCollection instead !");
                }
                colIterator = new ArrayIterator(col);
            }
            while (colIterator.hasNext()) {
                this.register(colIterator.next(), lockMode);
            }
        }
    }

    private void lockReferences(ClassDescriptor cld, Object newTxObject, int lockMode) throws IllegalAccessException, PersistenceBrokerException {
        Iterator i = ((AbstractList)cld.getObjectReferenceDescriptors()).iterator();
        while (i.hasNext()) {
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
            Object refObj = rds.getPersistentField().get(newTxObject);
            if (refObj == null) continue;
            this.register(refObj, lockMode);
        }
    }

    Identity getNrmEntry(String name) {
        return (Identity)this.myNrm.get(name);
    }

    void putNrmEntry(String key, Identity value) {
        this.myNrm.put(key, value);
    }

    void unbindNrmEntry(String key) {
        this.myNrm.remove(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

