/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ecs.ConcreteElement;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.modules.GenericLoader;
import org.apache.turbine.modules.Loader;
import org.apache.turbine.modules.Screen;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.assemblerbroker.TurbineAssemblerBroker;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.RunData;

public class ScreenLoader
extends GenericLoader
implements Loader {
    private static final long serialVersionUID = -4825216334500657398L;
    private static Log log = LogFactory.getLog((Class)ScreenLoader.class);
    private static ScreenLoader instance = new ScreenLoader(Turbine.getConfiguration().getInt("screen.cache.size", 50));
    private static AssemblerBrokerService ab = TurbineAssemblerBroker.getService();

    private ScreenLoader() {
    }

    private ScreenLoader(int i) {
        super(i);
    }

    private void addInstance(String name, Screen screen) {
        if (this.cache()) {
            this.put(name, screen);
        }
    }

    public ConcreteElement eval(RunData data, String name) throws Exception {
        return this.getInstance(name).build(data);
    }

    public void exec(RunData data, String name) throws Exception {
        this.eval(data, name);
    }

    public Assembler getAssembler(String name) throws Exception {
        return this.getInstance(name);
    }

    public Screen getInstance(String name) throws Exception {
        Screen screen = null;
        if (this.cache() && this.containsKey(name)) {
            screen = (Screen)this.get(name);
            log.debug((Object)("Found Screen " + name + " in the cache!"));
        } else {
            log.debug((Object)("Loading Screen " + name + " from the Assembler Broker"));
            try {
                if (ab != null) {
                    screen = (Screen)ab.getAssembler("screen", name);
                }
            }
            catch (ClassCastException cce) {
                screen = null;
            }
            if (screen == null) {
                List packages = Turbine.getConfiguration().getList("module.packages");
                ObjectUtils.addOnce(packages, GenericLoader.getBasePackage());
                throw new ClassNotFoundException("\n\n\tRequested Screen not found: " + name + "\n\tTurbine looked in the following " + "modules.packages path: \n\t" + packages.toString() + "\n");
            }
            if (this.cache()) {
                this.addInstance(name, screen);
            }
        }
        return screen;
    }

    public static ScreenLoader getInstance() {
        return instance;
    }
}

