
-----------------------------------------------------------------------------
-- TURBINE_PERMISSION
-----------------------------------------------------------------------------
drop table TURBINE_PERMISSION;

CREATE TABLE TURBINE_PERMISSION
(
    PERMISSION_ID INTEGER NOT NULL,
    PERMISSION_NAME VARCHAR (64) NOT NULL,
    UNIQUE (PERMISSION_NAME)
);

ALTER TABLE TURBINE_PERMISSION
    ADD PRIMARY KEY (PERMISSION_ID);







-----------------------------------------------------------------------------
-- TURBINE_ROLE
-----------------------------------------------------------------------------
drop table TURBINE_ROLE;

CREATE TABLE TURBINE_ROLE
(
    ROLE_ID INTEGER NOT NULL,
    ROLE_NAME VARCHAR (64) NOT NULL,
    UNIQUE (ROLE_NAME)
);

ALTER TABLE TURBINE_ROLE
    ADD PRIMARY KEY (ROLE_ID);







-----------------------------------------------------------------------------
-- TURBINE_GROUP
-----------------------------------------------------------------------------
drop table TURBINE_GROUP;

CREATE TABLE TURBINE_GROUP
(
    GROUP_ID INTEGER NOT NULL,
    GROUP_NAME VARCHAR (64) NOT NULL,
    UNIQUE (GROUP_NAME)
);

ALTER TABLE TURBINE_GROUP
    ADD PRIMARY KEY (GROUP_ID);







-----------------------------------------------------------------------------
-- TURBINE_ROLE_PERMISSION
-----------------------------------------------------------------------------
drop table TURBINE_ROLE_PERMISSION;

CREATE TABLE TURBINE_ROLE_PERMISSION
(
    ROLE_ID INTEGER NOT NULL,
    PERMISSION_ID INTEGER NOT NULL
);

ALTER TABLE TURBINE_ROLE_PERMISSION
    ADD PRIMARY KEY (ROLE_ID,PERMISSION_ID);







-----------------------------------------------------------------------------
-- TURBINE_USER
-----------------------------------------------------------------------------
drop table TURBINE_USER;

CREATE TABLE TURBINE_USER
(
    USER_ID INTEGER NOT NULL,
    LOGIN_NAME VARCHAR (64) NOT NULL,
    PASSWORD_VALUE VARCHAR (16) NOT NULL,
    FIRST_NAME VARCHAR (64) NOT NULL,
    LAST_NAME VARCHAR (64) NOT NULL,
    EMAIL VARCHAR (64),
    CONFIRM_VALUE VARCHAR (16),
    MODIFIED TIMESTAMP,
    CREATED TIMESTAMP,
    LAST_LOGIN TIMESTAMP,
    OBJECTDATA VARCHAR(16) FOR BIT DATA,
    UNIQUE (LOGIN_NAME)
);

ALTER TABLE TURBINE_USER
    ADD PRIMARY KEY (USER_ID);







-----------------------------------------------------------------------------
-- TURBINE_USER_GROUP_ROLE
-----------------------------------------------------------------------------
drop table TURBINE_USER_GROUP_ROLE;

CREATE TABLE TURBINE_USER_GROUP_ROLE
(
    USER_ID INTEGER NOT NULL,
    GROUP_ID INTEGER NOT NULL,
    ROLE_ID INTEGER NOT NULL
);

ALTER TABLE TURBINE_USER_GROUP_ROLE
    ADD PRIMARY KEY (USER_ID,GROUP_ID,ROLE_ID);







-----------------------------------------------------------------------------
-- TURBINE_PERMISSION: FOREIGN KEYS
-----------------------------------------------------------------------------


-----------------------------------------------------------------------------
-- TURBINE_ROLE: FOREIGN KEYS
-----------------------------------------------------------------------------


-----------------------------------------------------------------------------
-- TURBINE_GROUP: FOREIGN KEYS
-----------------------------------------------------------------------------


-----------------------------------------------------------------------------
-- TURBINE_ROLE_PERMISSION: FOREIGN KEYS
-----------------------------------------------------------------------------
ALTER TABLE TURBINE_ROLE_PERMISSION
    ADD CONSTRAINT TURBINE_ROLE__FK_1 FOREIGN KEY (ROLE_ID)
    REFERENCES TURBINE_ROLE (ROLE_ID)
;
ALTER TABLE TURBINE_ROLE_PERMISSION
    ADD CONSTRAINT TURBINE_ROLE__FK_2 FOREIGN KEY (PERMISSION_ID)
    REFERENCES TURBINE_PERMISSION (PERMISSION_ID)
;


-----------------------------------------------------------------------------
-- TURBINE_USER: FOREIGN KEYS
-----------------------------------------------------------------------------


-----------------------------------------------------------------------------
-- TURBINE_USER_GROUP_ROLE: FOREIGN KEYS
-----------------------------------------------------------------------------
ALTER TABLE TURBINE_USER_GROUP_ROLE
    ADD CONSTRAINT TURBINE_USER__FK_1 FOREIGN KEY (USER_ID)
    REFERENCES TURBINE_USER (USER_ID)
;
ALTER TABLE TURBINE_USER_GROUP_ROLE
    ADD CONSTRAINT TURBINE_USER__FK_2 FOREIGN KEY (GROUP_ID)
    REFERENCES TURBINE_GROUP (GROUP_ID)
;
ALTER TABLE TURBINE_USER_GROUP_ROLE
    ADD CONSTRAINT TURBINE_USER__FK_3 FOREIGN KEY (ROLE_ID)
    REFERENCES TURBINE_ROLE (ROLE_ID)
;

