/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.session.SessionService;

public class TurbineSessionService
extends TurbineBaseService
implements SessionService {
    private Map<String, HttpSession> activeSessions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<HttpSession> getActiveSessions() {
        Map<String, HttpSession> map = this.activeSessions;
        synchronized (map) {
            return new ArrayList<HttpSession>(this.activeSessions.values());
        }
    }

    @Override
    public void addSession(HttpSession session) {
        this.activeSessions.put(session.getId(), session);
    }

    @Override
    public void removeSession(HttpSession session) {
        this.activeSessions.remove(session.getId());
    }

    @Override
    public boolean isUserLoggedIn(User user) {
        return this.getActiveUsers().contains(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<User> getActiveUsers() {
        ArrayList<User> users;
        Map<String, HttpSession> map = this.activeSessions;
        synchronized (map) {
            users = new ArrayList<User>((int)((double)this.activeSessions.size() * 0.7));
            Iterator<HttpSession> i = this.activeSessions.values().iterator();
            while (i.hasNext()) {
                User u = this.getUserFromSession(i.next());
                if (u == null || !u.hasLoggedIn()) continue;
                users.add(u);
            }
        }
        return users;
    }

    @Override
    public User getUserFromSession(HttpSession session) {
        try {
            return (User)session.getAttribute("turbine.user");
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @Override
    public HttpSession getSession(String sessionId) {
        return this.activeSessions.get(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<HttpSession> getSessionsForUser(User user) {
        ArrayList<HttpSession> sessions = new ArrayList<HttpSession>();
        Map<String, HttpSession> map = this.activeSessions;
        synchronized (map) {
            for (HttpSession session : this.activeSessions.values()) {
                User u = this.getUserFromSession(session);
                if (!user.equals(u)) continue;
                sessions.add(session);
            }
        }
        return sessions;
    }

    @Override
    public void init() {
        this.activeSessions = new Hashtable<String, HttpSession>();
        this.setInit(true);
    }

    @Override
    public void shutdown() {
        this.activeSessions = null;
        this.setInit(false);
    }
}

