/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntConsumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationPath;

public abstract class InternalAggregation
implements Aggregation,
NamedWriteable {
    protected final String name;
    protected final Map<String, Object> metaData;
    private final List<PipelineAggregator> pipelineAggregators;

    protected InternalAggregation(String name, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        this.name = name;
        this.pipelineAggregators = pipelineAggregators;
        this.metaData = metaData;
    }

    protected InternalAggregation(StreamInput in) throws IOException {
        this.name = in.readString();
        this.metaData = in.readMap();
        this.pipelineAggregators = in.readNamedWriteableList(PipelineAggregator.class);
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeGenericValue(this.metaData);
        out.writeNamedWriteableList(this.pipelineAggregators);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    @Override
    public String getName() {
        return this.name;
    }

    public final InternalAggregation reduce(List<InternalAggregation> aggregations, ReduceContext reduceContext) {
        InternalAggregation aggResult = this.doReduce(aggregations, reduceContext);
        if (reduceContext.isFinalReduce()) {
            for (PipelineAggregator pipelineAggregator : this.pipelineAggregators) {
                aggResult = pipelineAggregator.reduce(aggResult, reduceContext);
            }
        }
        return aggResult;
    }

    public abstract InternalAggregation doReduce(List<InternalAggregation> var1, ReduceContext var2);

    public boolean isMapped() {
        return true;
    }

    public Object getProperty(String path) {
        AggregationPath aggPath = AggregationPath.parse(path);
        return this.getProperty(aggPath.getPathElementsAsStringList());
    }

    public abstract Object getProperty(List<String> var1);

    protected static int readSize(StreamInput in) throws IOException {
        int size = in.readVInt();
        return size == 0 ? Integer.MAX_VALUE : size;
    }

    protected static void writeSize(int size, StreamOutput out) throws IOException {
        if (size == Integer.MAX_VALUE) {
            size = 0;
        }
        out.writeVInt(size);
    }

    @Override
    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public List<PipelineAggregator> pipelineAggregators() {
        return this.pipelineAggregators;
    }

    @Override
    public String getType() {
        return this.getWriteableName();
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (params.paramAsBoolean("typed_keys", false)) {
            builder.startObject(String.join((CharSequence)"#", this.getType(), this.getName()));
        } else {
            builder.startObject(this.getName());
        }
        if (this.metaData != null) {
            builder.field(Aggregation.CommonFields.META.getPreferredName());
            builder.map(this.metaData);
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public int hashCode() {
        return Objects.hash(this.name, this.metaData, this.pipelineAggregators);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        InternalAggregation other = (InternalAggregation)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.pipelineAggregators, other.pipelineAggregators) && Objects.equals(this.metaData, other.metaData);
    }

    public String toString() {
        return Strings.toString(this);
    }

    public static class ReduceContext {
        private final BigArrays bigArrays;
        private final ScriptService scriptService;
        private final IntConsumer multiBucketConsumer;
        private final boolean isFinalReduce;

        public ReduceContext(BigArrays bigArrays, ScriptService scriptService, boolean isFinalReduce) {
            this(bigArrays, scriptService, s -> {}, isFinalReduce);
        }

        public ReduceContext(BigArrays bigArrays, ScriptService scriptService, IntConsumer multiBucketConsumer, boolean isFinalReduce) {
            this.bigArrays = bigArrays;
            this.scriptService = scriptService;
            this.multiBucketConsumer = multiBucketConsumer;
            this.isFinalReduce = isFinalReduce;
        }

        public boolean isFinalReduce() {
            return this.isFinalReduce;
        }

        public BigArrays bigArrays() {
            return this.bigArrays;
        }

        public ScriptService scriptService() {
            return this.scriptService;
        }

        public void consumeBucketsAndMaybeBreak(int size) {
            this.multiBucketConsumer.accept(size);
        }
    }
}

