/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.index.fielddata.AbstractSortedDocValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;

public class SinglePackedOrdinals
extends Ordinals {
    private final PackedInts.Reader reader;
    private final int valueCount;

    public SinglePackedOrdinals(OrdinalsBuilder builder, float acceptableOverheadRatio) {
        assert (builder.getNumMultiValuesDocs() == 0);
        this.valueCount = (int)builder.getValueCount();
        PackedInts.Mutable reader = PackedInts.getMutable((int)builder.maxDoc(), (int)PackedInts.bitsRequired((long)this.valueCount), (float)acceptableOverheadRatio);
        PackedInts.copy((PackedInts.Reader)builder.getFirstOrdinals(), (int)0, (PackedInts.Mutable)reader, (int)0, (int)builder.maxDoc(), (int)8192);
        this.reader = reader;
    }

    @Override
    public long ramBytesUsed() {
        return (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + this.reader.ramBytesUsed();
    }

    public Collection<Accountable> getChildResources() {
        return Collections.singleton(Accountables.namedAccountable((String)"reader", (Accountable)this.reader));
    }

    @Override
    public SortedSetDocValues ordinals(Ordinals.ValuesHolder values) {
        return DocValues.singleton((SortedDocValues)new Docs(this, values));
    }

    private static class Docs
    extends AbstractSortedDocValues {
        private final int maxOrd;
        private final PackedInts.Reader reader;
        private final Ordinals.ValuesHolder values;
        private int currentDoc = -1;
        private int currentOrd;

        Docs(SinglePackedOrdinals parent, Ordinals.ValuesHolder values) {
            this.maxOrd = parent.valueCount;
            this.reader = parent.reader;
            this.values = values;
        }

        public int getValueCount() {
            return this.maxOrd;
        }

        public BytesRef lookupOrd(int ord) {
            return this.values.lookupOrd(ord);
        }

        public int ordValue() {
            return this.currentOrd;
        }

        public boolean advanceExact(int docID) throws IOException {
            this.currentDoc = docID;
            this.currentOrd = (int)(this.reader.get(docID) - 1L);
            return this.currentOrd != -1;
        }

        public int docID() {
            return this.currentDoc;
        }
    }
}

