/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.ops4j.pax.web.service.WebContainer;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.util.NamedThreadFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.http.HttpContext;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpContextProcessing
implements ManagedServiceFactory {
    public static Logger LOG = LoggerFactory.getLogger(HttpContextProcessing.class);
    public static final String PID = "org.ops4j.pax.web.context";
    private static final String KEY_CONTEXT_ID = "context.id";
    private static final String KEY_BUNDLE_SN = "bundle.symbolicName";
    private static final String PREFIX_CONTEXT_PARAM = "context.param.";
    private static final String PREFIX_LOGIN_CONFIG = "login.config.";
    private static final String PREFIX_SECURITY = "security.";
    private final ExecutorService configExecutor = new ThreadPoolExecutor(0, 1, 20L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("paxweb-context"));
    private final BundleContext serviceContext;
    private final ServerController serverController;
    private final ConcurrentMap<String, HttpContextTracker> httpContextTrackers = new ConcurrentHashMap<String, HttpContextTracker>();

    public HttpContextProcessing(BundleContext serviceContext, ServerController serverController) {
        this.serviceContext = serviceContext;
        this.serverController = serverController;
    }

    public String getName() {
        return PID;
    }

    public void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
        LOG.info("Updated configuration for pid={}", (Object)pid);
        this.configExecutor.submit(new ConfigurationChangeTask(pid, properties));
    }

    public void deleted(String pid) {
        LOG.info("Deleted configuration for pid={}", (Object)pid);
        this.configExecutor.submit(new ConfigurationChangeTask(pid, null));
    }

    public void destroy() {
        this.configExecutor.shutdown();
    }

    private class HttpContextTracker
    implements BundleTrackerCustomizer<Object> {
        private final String pid;
        private Dictionary<String, ?> properties;
        private String symbolicName;
        private BundleTracker<?> bundleTracker;
        private Bundle bundle;
        private Version version;
        private HttpContext httpContext;
        private Dictionary<String, String> contextParams;
        private LoginConfiguration loginConfiguration;
        private List<SecurityConstraintsMapping> securityMappings = new LinkedList<SecurityConstraintsMapping>();

        public HttpContextTracker(String pid) {
            this.pid = pid;
        }

        public void reconfigure(Dictionary<String, ?> props) {
            if (props == null) {
                HttpContextTracker tracker;
                if (this.bundleTracker != null) {
                    this.bundleTracker.close();
                }
                if ((tracker = (HttpContextTracker)HttpContextProcessing.this.httpContextTrackers.remove(this.pid)) != null && this.symbolicName != null) {
                    HttpContextProcessing.this.configExecutor.execute(tracker::cleanupContext);
                }
                this.properties = null;
            } else {
                if (this.bundleTracker != null) {
                    this.bundleTracker.close();
                    HttpContextProcessing.this.configExecutor.execute(this::cleanupContext);
                }
                if (props.get(HttpContextProcessing.KEY_BUNDLE_SN) == null) {
                    LOG.warn("Incorrect {} configuration - missing {} selector", (Object)this.pid, (Object)HttpContextProcessing.KEY_BUNDLE_SN);
                    return;
                }
                this.properties = props;
                this.symbolicName = this.properties.get(HttpContextProcessing.KEY_BUNDLE_SN).toString().trim();
                if (this.bundleTracker == null) {
                    this.bundleTracker = new BundleTracker(HttpContextProcessing.this.serviceContext, 32, (BundleTrackerCustomizer)this);
                }
                this.bundleTracker.open();
            }
        }

        private void processContext() {
            LOG.info("Customizing WebContainer for bundle {}/{}", (Object)this.symbolicName, (Object)this.version);
            WebContainer wc = this.getWebContainer();
            if (wc == null) {
                return;
            }
            String contextId = (String)this.properties.get(HttpContextProcessing.KEY_CONTEXT_ID);
            if (contextId == null) {
                contextId = WebContainerContext.DefaultContextIds.DEFAULT.getValue();
            }
            this.httpContext = wc.createDefaultHttpContext(contextId);
            this.contextParams = this.collectContextParams(this.properties);
            if (this.contextParams != null && !this.contextParams.isEmpty()) {
                LOG.info("Setting context parameters in WebContainer for bundle \"" + this.symbolicName + "\": {}", this.contextParams);
                wc.setContextParam(this.contextParams, this.httpContext);
            }
            this.loginConfiguration = this.collectLoginConfiguration(this.properties);
            if (this.loginConfiguration != null) {
                LOG.info("Registering login configuration in WebContainer for bundle \"" + this.symbolicName + "\": method={}, realm={}", (Object)this.loginConfiguration.authMethod, (Object)this.loginConfiguration.realmName);
                wc.registerLoginConfig(this.loginConfiguration.authMethod, this.loginConfiguration.realmName, this.loginConfiguration.formLoginPage, this.loginConfiguration.formErrorPage, this.httpContext);
            }
            this.securityMappings = this.collectSecurityMappings(this.properties);
            if (this.securityMappings != null && !this.securityMappings.isEmpty()) {
                for (SecurityConstraintsMapping scm : this.securityMappings) {
                    LOG.info("Registering security mappings in WebContainer for bundle \"" + this.symbolicName + "\": " + scm);
                    wc.registerConstraintMapping(scm.name, scm.method, scm.url, null, true, scm.roles, this.httpContext);
                }
            }
            wc.end(this.httpContext);
        }

        public void cleanupContext() {
            LOG.info("{}: Restoring WebContainer for bundle {}/{}", new Object[]{this, this.symbolicName, this.version});
            WebContainer wc = this.getWebContainer();
            if (wc == null || this.httpContext == null) {
                return;
            }
            if (this.securityMappings.size() > 0) {
                wc.unregisterConstraintMapping(this.httpContext);
                this.securityMappings.clear();
            }
            if (this.loginConfiguration != null) {
                wc.unregisterLoginConfig(this.httpContext);
                this.loginConfiguration = null;
            }
            if (this.contextParams != null && !this.contextParams.isEmpty()) {
                wc.setContextParam(null, this.httpContext);
                this.contextParams = null;
            }
            wc.end(this.httpContext);
            this.httpContext = null;
        }

        private LoginConfiguration collectLoginConfiguration(Dictionary<String, ?> properties) {
            if (properties != null && properties.get("login.config.authMethod") != null) {
                LoginConfiguration lc = new LoginConfiguration();
                lc.authMethod = properties.get("login.config.authMethod").toString();
                lc.realmName = (String)properties.get("login.config.realmName");
                if (lc.realmName == null) {
                    lc.realmName = UUID.randomUUID().toString();
                }
                lc.formLoginPage = (String)properties.get("login.config.formLoginPage");
                lc.formErrorPage = (String)properties.get("login.config.formErrorPage");
                return lc;
            }
            return null;
        }

        private Dictionary<String, String> collectContextParams(Dictionary<String, ?> properties) {
            Hashtable<String, String> result = new Hashtable<String, String>();
            if (properties != null) {
                Enumeration<String> e = properties.keys();
                while (e.hasMoreElements()) {
                    String k = e.nextElement();
                    if (k == null || !k.startsWith(HttpContextProcessing.PREFIX_CONTEXT_PARAM)) continue;
                    String v = (String)properties.get(k);
                    String paramName = k.substring(HttpContextProcessing.PREFIX_CONTEXT_PARAM.length());
                    result.put(paramName, v);
                }
            }
            return result;
        }

        private List<SecurityConstraintsMapping> collectSecurityMappings(Dictionary<String, ?> properties) {
            LinkedList<SecurityConstraintsMapping> result = new LinkedList<SecurityConstraintsMapping>();
            if (properties != null) {
                HashMap<String, SecurityConstraintsMapping> temp = new HashMap<String, SecurityConstraintsMapping>();
                Enumeration<String> e = properties.keys();
                while (e.hasMoreElements()) {
                    String paramName;
                    String k = e.nextElement();
                    if (k == null || !k.startsWith(HttpContextProcessing.PREFIX_SECURITY) || !(paramName = k.substring(HttpContextProcessing.PREFIX_SECURITY.length())).contains(".")) continue;
                    String constraintName = paramName.substring(0, paramName.lastIndexOf(46));
                    SecurityConstraintsMapping model = temp.computeIfAbsent(constraintName, n -> new SecurityConstraintsMapping());
                    model.name = constraintName;
                    String v = (String)properties.get(k);
                    if (paramName.endsWith(".url")) {
                        model.url = v;
                        continue;
                    }
                    if (paramName.endsWith(".method")) {
                        model.method = v;
                        continue;
                    }
                    if (!paramName.endsWith(".roles")) continue;
                    model.roles.addAll(Arrays.asList(v.split("\\s*,\\s*")));
                }
                for (SecurityConstraintsMapping scm : temp.values()) {
                    if (scm.url == null) continue;
                    result.add(scm);
                }
            }
            return result;
        }

        public Object addingBundle(Bundle bundle, BundleEvent event) {
            if (this.symbolicName.equals(bundle.getSymbolicName())) {
                this.bundle = bundle;
                this.version = bundle.getVersion();
                LOG.info("Found bundle \"" + this.symbolicName + "\", scheduling customization of its WebContainer");
                HttpContextProcessing.this.configExecutor.execute(this::processContext);
            }
            return null;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
            this.bundle = null;
        }

        private WebContainer getWebContainer() {
            Bundle _bundle = this.bundle;
            if (_bundle == null) {
                LOG.debug("Bundle context for {} bundle is no longer valid", (Object)this.symbolicName);
                return null;
            }
            BundleContext context = _bundle.getBundleContext();
            try {
                ServiceReference sr = context.getServiceReference(WebContainer.class);
                if (sr == null) {
                    LOG.warn("Can't obtain service reference for WebContainer for bundle {}", (Object)this.symbolicName);
                    return null;
                }
                WebContainer wc = (WebContainer)context.getService(sr);
                if (wc == null) {
                    LOG.warn("Can't obtain WebContainer service for bundle {}", (Object)this.symbolicName);
                    return null;
                }
                return wc;
            }
            catch (IllegalStateException e) {
                LOG.debug("Bundle context for {} bundle is no longer valid", (Object)this.symbolicName);
                return null;
            }
        }

        public String toString() {
            return "HTTP Context Processor {bundle=" + this.bundle + '}';
        }

        private class SecurityConstraintsMapping {
            String name;
            String url;
            String method;
            List<String> roles = new LinkedList<String>();

            private SecurityConstraintsMapping() {
            }

            public String toString() {
                return "SecurityConstraintsMapping{name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", roles=" + this.roles + '}';
            }
        }

        private class LoginConfiguration {
            String authMethod;
            String realmName;
            String formLoginPage;
            String formErrorPage;

            private LoginConfiguration() {
            }
        }
    }

    private class ConfigurationChangeTask
    implements Runnable {
        private final String pid;
        private final Dictionary<String, ?> properties;

        public ConfigurationChangeTask(String pid, Dictionary<String, ?> properties) {
            this.pid = pid;
            this.properties = properties;
        }

        @Override
        public void run() {
            try {
                LOG.debug("Processing {} PID {}", (Object)this.pid, (Object)(this.properties == null ? "removal" : "change"));
                HttpContextTracker p = HttpContextProcessing.this.httpContextTrackers.computeIfAbsent(this.pid, x$0 -> new HttpContextTracker((String)x$0));
                p.reconfigure(this.properties);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

