/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.include;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.servlet.ServletContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.resource.UrlResourceStream;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.UrlUtils;
import org.apache.wicket.resource.ResourceUtil;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.IResourceStream;

public class Include
extends WebComponent {
    private static final long serialVersionUID = 1L;

    public Include(String id) {
        super(id);
    }

    public Include(String id, IModel<String> model) {
        super(id, model);
    }

    public Include(String id, String modelObject) {
        super(id, new Model<String>(modelObject));
    }

    protected String importAsString() {
        String url = this.getDefaultModelObjectAsString();
        if (UrlUtils.isRelative((String)url)) {
            return this.importRelativeUrl(url);
        }
        return this.importAbsoluteUrl(url);
    }

    @Override
    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        String content = this.importAsString();
        this.replaceComponentTagBody(markupStream, openTag, content);
    }

    private String importRelativeUrl(String url) {
        Args.notEmpty((CharSequence)url, (String)"url");
        if (url.charAt(0) != '/') {
            url = '/' + url;
        }
        try {
            ServletContext servletContext = this.getWebApplication().getServletContext();
            URL resource = servletContext.getResource(url);
            return this.importUrl(resource);
        }
        catch (MalformedURLException mux) {
            throw new WicketRuntimeException(mux);
        }
    }

    private String importAbsoluteUrl(CharSequence url) {
        try {
            return this.importUrl(new URL(url.toString()));
        }
        catch (MalformedURLException e) {
            throw new WicketRuntimeException(e);
        }
    }

    public Charset getCharset() {
        return null;
    }

    private String importUrl(URL url) {
        return ResourceUtil.readString((IResourceStream)new UrlResourceStream(url), this.getCharset());
    }
}

