/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.atmosphere;

import java.util.Iterator;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.atmosphere.AjaxRequestInitializer;
import org.apache.wicket.atmosphere.AtmosphereEvent;
import org.apache.wicket.atmosphere.EventBus;
import org.apache.wicket.atmosphere.EventSubscription;
import org.apache.wicket.atmosphere.EventSubscriptionInvoker;
import org.apache.wicket.atmosphere.PageKey;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereRequestHandler
implements IRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtmosphereRequestHandler.class);
    private final PageKey pageKey;
    private final AtmosphereEvent event;
    private final Iterator<EventSubscription> subscriptions;
    private final EventSubscriptionInvoker eventSubscriptionInvoker;
    private boolean ajaxRequestScheduled = false;

    public AtmosphereRequestHandler(PageKey pageKey, Iterator<EventSubscription> subscriptions, AtmosphereEvent event, EventSubscriptionInvoker eventSubscriptionInvoker) {
        this.pageKey = pageKey;
        this.subscriptions = subscriptions;
        this.event = event;
        this.eventSubscriptionInvoker = (EventSubscriptionInvoker)Args.notNull((Object)eventSubscriptionInvoker, (String)"eventSubscriptionInvoker");
    }

    public void respond(IRequestCycle requestCycle) {
        WebApplication application = WebApplication.get();
        Integer pageId = this.pageKey.getPageId();
        Page page = (Page)Session.get().getPageManager().getPage(pageId.intValue());
        if (page != null) {
            page.dirty();
            AjaxRequestTarget target = application.newAjaxRequestTarget(page);
            this.executeHandlers(target, page);
        } else {
            LOGGER.warn("Could not find a page with id '{}' for session with id '{}' in the page stores. It will be unregistered", (Object)pageId, (Object)this.pageKey.getSessionId());
            EventBus.get((Application)application).unregister(this.pageKey);
        }
    }

    private void executeHandlers(AjaxRequestTarget target, Page page) {
        while (this.subscriptions.hasNext()) {
            EventSubscription curSubscription = this.subscriptions.next();
            if (!curSubscription.getContextAwareFilter().apply((Object)this.event)) continue;
            String componentPath = curSubscription.getComponentPath();
            Component component = page.get(componentPath);
            if (component != null) {
                Integer behaviorIndex = curSubscription.getBehaviorIndex();
                if (behaviorIndex == null) {
                    this.invokeMethod(target, curSubscription, component);
                    continue;
                }
                Behavior behavior = component.getBehaviorById(behaviorIndex.intValue());
                this.invokeMethod(target, curSubscription, behavior);
                continue;
            }
            LOGGER.debug("Cannot find component with path '{}' in page '{}'. Maybe it has been removed.", (Object)componentPath, (Object)page);
            EventBus.get().unregister(page, curSubscription);
        }
    }

    private void invokeMethod(final AjaxRequestTarget target, EventSubscription subscription, Object base) {
        AjaxRequestInitializer initializer = new AjaxRequestInitializer(){

            @Override
            public void initialize() {
                if (!AtmosphereRequestHandler.this.ajaxRequestScheduled) {
                    RequestCycle.get().scheduleRequestHandlerAfterCurrent((IRequestHandler)target);
                    AtmosphereRequestHandler.this.ajaxRequestScheduled = true;
                }
            }
        };
        this.eventSubscriptionInvoker.invoke(target, subscription, base, this.event, initializer);
    }

    public void detach(IRequestCycle requestCycle) {
    }
}

