var magnetos = props.globals.getNode("/controls/engines/engine/magnetos",1).getBoolValue();
var cranking = props.globals.getNode("/engines/engine/cranking",1).getBoolValue();
var running = props.globals.getNode("/engines/engine/running",1).getBoolValue();
var starter = props.globals.getNode("/controls/engines/engine/starter",1).getBoolValue();
var starter_serviceable = 0;
var cranking_serviceable = 0;
var engine_serviceable = 0;

setlistener("/sim/signals/fdm-initialized", func{
  setprop("/sim/sound/volume",1.0);
  setprop("/controls/gear/brake-parking",1);
  setprop("/controls/gear/brake-parking-pos",1);
  setprop("/consumables/fuel/tank[1]/selected",1);
  setprop("/instrumentation/dynon-efis/ready", 0);
print("Zenith Aircraft CH750 STOL loaded");
});

setlistener("/engines/engine/running", func(running) {
    var running = running.getBoolValue();
    if(running){ 
      interpolate("/engines/engine/oil-pressure-psi", 6, 0.9);
    }else{
      interpolate("/engines/engine/oil-pressure-psi", 0, 0.9);
    }
});

##############################################
############### CONVERT UNIT #################
##############################################

setlistener("/instrumentation/airspeed-indicator/indicated-speed-kt", func(asi) {
    var speed = asi.getValue();
    speed = speed * 1.852;
    setprop("/instrumentation/airspeed-indicator/indicated-speed-kmh", speed);
});

setlistener("/engines/engine/oil-temperature-degf", func(degf) {
    var degf = degf.getValue();
    var degc = (degf - 32) * (5 / 9);
    setprop("/engines/engine/oil-temperature-degc", degc);
});

##############################################
######### AUTOSTART / AUTOSHUTDOWN ###########
##############################################

setlistener("/sim/model/start-idling", func(idle){
    var run= idle.getBoolValue();
    if(run){
    Startup();
    }else{
    Shutdown();
    }
},0,0);

var Startup = func {
  setprop("/controls/engines/engine/master-bat",1);
  setprop("/controls/engines/engine/master-alt",1);
  setprop("/controls/lighting/beacon",1);
  setprop("/controls/engines/engine/fuel-pump",1);
setprop("/instrumentation/dynon-efis/loading-screen", 1);
interpolate("/instrumentation/dynon-efis/ready", 1, 5);
  setprop("/controls/electric/key",1);
  setprop("/controls/engines/engine/magnetos",3);
  setprop("/engines/engine/rpm",2700);
  setprop("/engines/engine/running",1);
  setprop("/controls/gear/brake-parking",0);
}

var Shutdown = func {
  setprop("/controls/engines/engine/master-bat",0);
  setprop("/controls/engines/engine/master-alt",0);
  setprop("/controls/lighting/beacon",0);
  setprop("/controls/engines/engine/fuel-pump",0);
setprop("/instrumentation/dynon-efis/loading-screen", 1);
interpolate("/instrumentation/dynon-efis/ready", 0, 5);
  setprop("/controls/electric/key",0);
  setprop("/controls/engines/engine/magnetos",0);
  setprop("/engines/engine/rpm",0);
  setprop("/engines/engine/running",0);
  setprop("/controls/gear/brake-parking",1);
}

