##################################################################
####      doors.nas - ePilot                                  ####
####                                                          ####
####    Interpolations for slow moving objects like doors     ####
####                                                          ####
##################################################################


var BowHatch = props.globals.initNode("/controls/doors/BowHatch",0,"DOUBLE");
var CargoHatch = props.globals.initNode("/controls/doors/CargoHatch",0,"DOUBLE");
var UCabin = props.globals.initNode("/controls/doors/CabinDoorUpper",0,"DOUBLE");
var LCabin = props.globals.initNode("/controls/doors/CabinDoorLower",0,"DOUBLE");
var CPDoor = props.globals.initNode("/controls/doors/CockpitDoor",1,"DOUBLE");
var LuaDoor = props.globals.initNode("/controls/doors/LuaDoor",0,"DOUBLE");
var StorageDoor = props.globals.initNode("/controls/doors/StorageDoor",0,"DOUBLE");
var BowDoor = props.globals.initNode("/controls/doors/BowDoor",0,"DOUBLE");
var CPHatchL = props.globals.initNode("/controls/doors/PilotHatch",0,"DOUBLE");
var CPHatchR = props.globals.initNode("/controls/doors/CoPilotHatch",0,"DOUBLE");
var Pedestal = props.globals.initNode("/controls/doors/Pedestal",0,"DOUBLE");
var ArmRestRight = props.globals.initNode("/controls/doors/ArmRestRight",0,"DOUBLE");
var ArmRestLeft = props.globals.initNode("/controls/doors/ArmRestLeft",0,"DOUBLE");
var RadiomanSeat = props.globals.initNode("/controls/doors/RadiomanSeat",0,"DOUBLE");
var NavigatorSeat = props.globals.initNode("/controls/doors/NavigatorSeat",0,"DOUBLE");
var TableLeaf = props.globals.initNode("/controls/doors/TableLeaf",1,"DOUBLE");
var GustLock = props.globals.initNode("/controls/doors/GustLock",0,"DOUBLE");
var SCLever = props.globals.initNode("/controls/doors/SCLever",0,"DOUBLE");
var LFuel = props.globals.initNode("/controls/doors/LFuel",0,"DOUBLE");
var RFuel = props.globals.initNode("/controls/doors/RFuel",0,"DOUBLE");

var move = func (indevice, rate) {
        var wdevice = props.globals.getNode(indevice) ;
        var devicevalue = wdevice.getValue();
        if ( devicevalue < 0.01 ) {
          interpolate(wdevice.getPath(), 1, rate);
        } else {
          interpolate(wdevice.getPath(), 0, rate);
        }

}

var flaps = func () {
  var newpos=getprop("/controls/flight/flaps");
          interpolate("/controls/doors/Flaps", newpos, 0.25);
}
setlistener("/controls/flight/flaps", flaps, 0, 0);

var glock = func () {
  var newpos=getprop("/controls/GustLock/lock-open");
          interpolate("/controls/doors/GustLock", newpos, 0.7);
}
setlistener("/controls/GustLock/lock-open", glock, 0, 0);

var lfuel = func (newpos) {
          interpolate("/controls/doors/LFuel", newpos, 0.7);
}

var rfuel = func (newpos) {
          interpolate("/controls/doors/RFuel", newpos, 0.7);
}

var LLights = func() {
  var electrical=getprop("/systems/electrical/on");
  var llswitch=getprop("/controls/electric/landing-light-switch");
  if (electrical and llswitch) {
    interpolate("/controls/doors/Landinglights", 1, 2.5);
  } else {
    interpolate("/controls/doors/Landinglights", 0, 2.5);
  }
}
setlistener("/systems/electrical/on", LLights, 0, 0);
setlistener("/controls/electric/landing-light-switch", LLights, 0, 0);
