####    jet engine electrical system    ####
####    Syd Adams                       ####
####    Updated BARANGER Emmanuel       ####

var count=0;
var ammeter_ave = 0.0;
var Lbus = props.globals.initNode("/systems/electrical/left-bus",0,"DOUBLE");
var Rbus = props.globals.initNode("/systems/electrical/right-bus",0,"DOUBLE");
var Amps = props.globals.initNode("/systems/electrical/amps",0,"DOUBLE");
var EXT  = props.globals.initNode("/controls/electric/external-power",0,"DOUBLE");
var XTie  = props.globals.initNode("/systems/electrical/xtie",0,"BOOL");
var lbus_volts = 0.0;
var rbus_volts = 0.0;

var lbus_input=[];
var lbus_output=[];
var lbus_load=[];

var rbus_input=[];
var rbus_output=[];
var rbus_load=[];

#var battery = Battery.new(switch-prop,volts,amps,amp_hours,charge_percent,charge_amps);
Battery = {
  new : func(swtch,vlt,amp,hr,chp,cha){
    m = { parents : [Battery] };
    m.switch = props.globals.getNode(swtch,1);
    m.switch.setBoolValue(0);
    m.ideal_volts = vlt;
    m.ideal_amps = amp;
    m.amp_hours = hr;
    m.charge_percent = chp;
    m.charge_amps = cha;
    return m;
  },

  apply_load : func(load,dt) {
    if (me.switch.getValue()) {
      var amphrs_used = load * dt / 3600.0;
      var percent_used = amphrs_used / me.amp_hours;
      me.charge_percent -= percent_used;
      if ( me.charge_percent < 0.0 ) {
        me.charge_percent = 0.0;
      } elsif ( me.charge_percent > 1.0 ) {
        me.charge_percent = 1.0;
      }
      var output =me.amp_hours * me.charge_percent;
      return output;
    } else {
      return 0;
    }
  },

  get_output_volts : func {
    if (me.switch.getValue()) {
      var x = 1.0 - me.charge_percent;
      var tmp = -(3.0 * x - 1.0);
      var factor = (tmp*tmp*tmp*tmp*tmp + 32) / 32;
      var output =me.ideal_volts * factor;
      return output;
    } else {
      return 0;
    }
  },

  get_output_amps : func {
    if (me.switch.getValue()) {
      var x = 1.0 - me.charge_percent;
      var tmp = -(3.0 * x - 1.0);
      var factor = (tmp*tmp*tmp*tmp*tmp + 32) / 32;
      var output =me.ideal_amps * factor;
      return output;
    } else {
      return 0;
    }
  }
};

# var alternator = Alternator.new(num,switch,rpm_source,rpm_threshold,volts,amps);
Alternator = {
  new : func (num,switch,src,thr,vlt,amp){
    m = { parents : [Alternator] };
    m.switch =  props.globals.getNode(switch,1);
    m.switch.setBoolValue(0);
    m.meter =  props.globals.getNode("systems/electrical/gen-load["~num~"]",1);
    m.meter.setDoubleValue(0);
    m.gen_output =  props.globals.getNode("engines/engine["~num~"]/amp-v",1);
    m.gen_output.setDoubleValue(0);
    m.meter.setDoubleValue(0);
    m.rpm_source =  props.globals.getNode(src,1);
    m.rpm_threshold = thr;
    m.ideal_volts = vlt;
    m.ideal_amps = amp;
    return m;
  },

  apply_load : func(load) {
    var cur_volt=me.gen_output.getValue();
    var cur_amp=me.meter.getValue();
    if (cur_volt >1) {
      var factor=1/cur_volt;
      gout = (load * factor);
      if(gout>1)gout=1;
    } else {
      gout=0;
    }
    me.meter.setValue(gout);
  },

  get_output_volts : func {
    var out = 0;
    if (me.switch.getBoolValue()) {
      var sur = me.rpm_source.getValue();
      var sous = me.rpm_threshold;
      if ( !sur ) {
        sur = 0;
      }
      if ( !sous ) {
        sous = 1;
      }
      var factor = sur / sous;
      if ( factor > 1.0 ) {
        factor = 1.0;
      }
      var out = (me.ideal_volts * factor);
    }
    me.gen_output.setValue(out);
    return out;
  },

  get_output_amps : func {
    var ampout =0;
    if(me.switch.getBoolValue()){
      var factor = me.rpm_source.getValue() / me.rpm_threshold;
      if ( factor > 1.0 ) {
          factor = 1.0;
      }
      ampout = me.ideal_amps * factor;
    }
    return ampout;
  }
};

var battery1 = Battery.new("/controls/electric/battery-switch",24,30,34,1.0,7.0);
var alternator1 = Alternator.new(0,"controls/electric/engine[0]/generator","/engines/engine[0]/fan",20.0,28.0,60.0);

#####################################
setlistener("/sim/signals/fdm-initialized", func {
  settimer(update_electrical,5);
  print("Electrical System ... ok");
});

update_virtual_bus = func( dt ) {
  var PWR = getprop("systems/electrical/serviceable");
  var xtie=0;
  load = 0.0;
  power_source = nil;

  var battery1_volts = battery1.get_output_volts();
  lbus_volts = battery1_volts;
  power_source = "battery";
  var alternator1_volts = alternator1.get_output_volts();
  if (alternator1_volts > lbus_volts) {
    lbus_volts = alternator1_volts;
    power_source = "alternator1";
  }
  lbus_volts *=PWR;
  Lbus.setValue(lbus_volts);
  load += lh_bus(lbus_volts)
    ;
  count=1-count;
  if (rbus_volts > 5 and  lbus_volts>5) {
    xtie=1;
  }
  XTie.setValue(xtie);

  ammeter = 0.0;
  if ( lbus_volts > 1.0 ) {
    load += 15.0;
  }

  if ( rbus_volts > 1.0 ) {
    load += 15.0;
  }

  if ( power_source == "battery1" ) {
    ammeter = -load;
    battery1.apply_load( load, dt );
  } else {
    ammeter = battery1.charge_amps;
    battery1.apply_load( -battery1.charge_amps, dt );
  }

  ammeter_ave = 0.8 * ammeter_ave + 0.2 * ammeter;

  alternator1.apply_load(load);

  return load;
}

rh_bus = func(bv) {
  var bus_volts = bv;
  var load = 0.0;
  var srvc = 0.0;

  for (var i=0; i<size(rbus_input); i+=1) {
    var srvc = rbus_input[i].getValue();
    load += rbus_load[i] * srvc;
    rbus_output[i].setValue(bus_volts * srvc);
  }
  return load;
}

lh_bus = func(bv) {
  var load = 0.0;
  var srvc = 0.0;

  for (var i=0; i<size(lbus_input); i+=1) {
    var srvc = lbus_input[i].getValue();
    load += lbus_load[i] * srvc;
    lbus_output[i].setValue(bv * srvc);
  }

  setprop("systems/electrical/outputs/flaps",bv);
  return load;
}

update_electrical = func {
  var scnd = getprop("sim/time/delta-sec");
  update_virtual_bus( scnd );
  settimer(update_electrical, 0);
}
