var INHG2HPA = 33.864;

var instruments_on = func {
	canvas_aera660.state = 2;
	canvas_epsi570.state = 2;
	atr833_ii.state = 2;
	trt800h.state = 2;
}

var state = props.globals.getNode( "/sim/aircraft-state", 1 );

var state_listener = setlistener(state, func{
	apply_state();
});

var init_listener = setlistener("/sim/signals/fdm-initialized", func{
	apply_state();

	# Set initial temperature
	var temp = props.globals.getNode("/environment/temperature-degc");

	print( temp.getValue() );

	setprop("/engines/engine/coolant-temp-degc/initial-integrator-value", temp.getDoubleValue() );

	removelistener( init_listener );
	init_listener = nil;
});

var apply_state = func(){
	if( state.getValue() == "parking" ){
		alphaelectro.auto_set_parking_brake(1);
	}elsif( state.getValue() == "take-off" ){
		setprop("/instrumentation/altimeter/setting-hpa", ( getprop("/environment/pressure-sea-level-inhg") or 29.92 ) * INHG2HPA );
		alphaelectro.engine.thr.setDoubleValue( 0.0 );
		alphaelectro.throttle_en.setBoolValue( 1 ); # bypass the throttle "seen zero" feature
		settimer(instruments_on, 0.2);
	}elsif( state.getValue() == "cruise" ){
		alphaelectro.throttle_en.setBoolValue( 1 ); # bypass the throttle "seen zero" feature
		alphaelectro.engine.thr.setDoubleValue( 0.5 );
		settimer(instruments_on, 0.2);
	}
}
