# LX Vario S3 by D-ECHO based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)

#Information based on manual http://www.lx-avionik.de/wp/download/manuals/LXS3ManualGermanVer0100.pdf
#######################################

var S3_start = nil;
var S3_main = nil;
var S3_display = nil;
var page = "main";

var base = "/instrumentation/S3/";
var inputs = base~"inputs/";


setprop(base~"mc", 1.5);

var mode_prop = base~"inputs/knob-mode";
	#Knob mode assignments: 0 = OFF  1 = STBY  2 = TEST (not avail) 3 = GND (not avail)  4=ON 5=ALT
var start_prop = base~"start";
var battery_prop = "/controls/electric/battery-switch";
var active_prop = inputs~"current-change";
var idcode_prop = base~"id-code";
var pushknob_prop = base~"knob-pushed";

setprop(start_prop, 0);

setprop(active_prop, 0);

var instrument_dir = "Aircraft/Antares23E/Models/Instruments/S3/";


var canvas_S3_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Bold.ttf";
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		 var svg_keys = me.getKeys();
		 
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var svg_keys = me.getKeys();
			foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
			}
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var battery = getprop(battery_prop) or 0;
		#var mode = getprop(mode_prop) or 0;
		var start = getprop(start_prop) or 0;
		if ( start == 1 and battery == 1) {
			S3_start.page.hide();
			S3_main.page.show();
		} else if ( start > 0 and start < 1 and battery == 1 ){
			S3_main.page.hide();
			S3_start.page.show();
		} else {
			S3_main.page.hide();
			S3_start.page.hide();
		}
		
		settimer(func me.update(), 0.02);
	},
};
	
	
var canvas_S3_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_S3_main , canvas_S3_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["altitude","average","average.needle","mccready.needle"];
	},
	update: func() {
		
		#Altimeter
		var alt = (getprop("instrumentation/altimeter/indicated-altitude-ft") or 0)*FT2M;
		me["altitude"].setText(sprintf("%4d", math.round(alt)));
		
		
		#Average climbrate
		var av = getprop(base~"te-average-mps") or 0;
		me["average"].setText(sprintf("%2.1f", av));
		if(av<5 and av>-5){
			var av2=av;
		}else if(av<-5){
			var av2=-5;
		}else if(av>5){
			var av2=5;
		}
		me["average.needle"].setRotation(av2*D2R*24);
		
		#McCready
		var mc = getprop(base~"mc") or 0;
		me["mccready.needle"].setRotation(mc*D2R*24);
		
		
		settimer(func me.update(), 0.02);
	}
	
};


var canvas_S3_start = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_S3_start , canvas_S3_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
	}
	
};




var identoff = func {
	setprop("/instrumentation/transponder/inputs/ident-btn", 0);
}

setlistener("/instrumentation/transponder/inputs/ident-btn-2", func{
	setprop("/instrumentation/transponder/inputs/ident-btn", 1);
	settimer(identoff, 18);
});


setlistener("sim/signals/fdm-initialized", func {
	S3_display = canvas.new({
		"name": "S3",
		"size": [320, 240],
		"view": [320, 240],
		"mipmapping": 1
	});
	S3_display.addPlacement({"node": "S3.display"});
	var groupMain = S3_display.createGroup();
	var groupStart = S3_display.createGroup();


	S3_main = canvas_S3_main.new(groupMain, instrument_dir~"S3_main.svg");
	S3_start = canvas_S3_start.new(groupStart, instrument_dir~"S3_start.svg");

	S3_main.update();
	canvas_S3_base.update();
});

var showS3 = func {
	var dlg = canvas.Window.new([320, 240], "dialog").set("resize", 1);
	dlg.setCanvas(S3_display);
}

var i=0;

var check_off = func () {
	if(getprop(pushknob_prop) == 1 and i<50){
		i=i+1;
		settimer(check_off, 0.1);
	}else if(getprop(pushknob_prop) == 1 and i >= 50){
		i=0;
		setprop(start_prop, 0); #put proper shutdown routine here later
	}else{
		i=0;
	}
}


setlistener(pushknob_prop, func {
	if(getprop(pushknob_prop) == 1){
		if(getprop(battery_prop) == 1 and getprop(start_prop) == 0){
			interpolate(start_prop, 1, 4 );
		}else if( getprop(battery_prop) == 0  and getprop(start_prop) != 0){
			setprop(start_prop, 0);
		}
		check_off();
	}
});


setlistener(battery_prop, func{
	if( getprop(battery_prop) == 0  and getprop(start_prop) != 0){
		setprop(start_prop, 0);
	}
});






#The following code is based on the ILEC SC7 e-vario and computes the different values shown by the display and the mechanical needle
io.include("Aircraft/Generic/soaring-instrumentation-sdk.nas");

# Initialize exported properties
setprop("/instrumentation/S3/te-reading-mps", 0);
setprop("/instrumentation/S3/te-average-mps", 0);


# Instrument setup:

# One TE probe feeds the vario needle and a 20s averager. 


var probe = TotalEnergyProbe.new();

var s3_needle = Dampener.new(
	input: probe,
	dampening: 1.5, 
	on_update: update_prop("/instrumentation/S3/te-reading-mps"));#1.5 is default dampening value according to POH

var averager = Averager.new(
	input: probe,
	buffer_size: 20,
	on_update: update_prop("/instrumentation/S3/te-average-mps")); #20s is default time according to POH

# Subscribe property listeners for instrument switches

#setlistener("instrumentation/S3/sensitivity",
#	func(n) { s3_needle.dampening = n.getValue() }, 0, 0);

# Wrap everything together into an instrument
var fast_instruments = UpdateLoop.new(
	update_period: 0,
	components: [probe, s3_needle],
	enable: 1);

var slow_instruments = UpdateLoop.new(
	update_period: 1,
	components: [averager],
	enable: 1);

	
