##################################################################
####      elec_loop.nas - ePilot                              ####
####                                                          ####
####    Main electrical system loop                           ####
####                                                          ####
##################################################################

var elec_loop = func {

var battery_on = getprop("controls/electric/battery-switch");
var external_on = getprop("controls/electric/external-power");
var engine1_on = getprop("engines/engine[0]/running");
var engine2_on = getprop("engines/engine[1]/running");
var gen1_on = getprop("controls/electric/engine[0]/generator");
var gen2_on = getprop("controls/electric/engine[1]/generator");
var inv1_switch = getprop("controls/electric/inv1-switch");
var inv2_switch = getprop("controls/electric/inv2-switch");
var inv3_switch = getprop("controls/electric/inv3-switch");
var neb_override = getprop("controls/electric/non-ess-bus-emer-override");
var inst_dim=getprop("controls/lighting/inst-lights-dim");
var inst_eng_dim=getprop("controls/lighting/inst-lights-eng-dim");

    if (battery_on or external_on or (engine1_on and gen1_on) or (engine2_on and gen2_on)) {
        setprop("systems/electrical/on", 1);
        setprop("systems/electrical/outputs/DG", 28);
        setprop("systems/electrical/outputs/MRG", 28);
        setprop("systems/electrical/outputs/adf", 28);
        setprop("systems/electrical/outputs/audio-panel", 28);
        setprop("systems/electrical/outputs/avionics-fan", 28);
        setprop("systems/electrical/outputs/comm", 28);
        setprop("systems/electrical/outputs/comm[1]", 28);
        setprop("instrumentation/comm[0]/serviceable", 1);
        setprop("instrumentation/comm[1]/serviceable", 1);
        setprop("systems/electrical/outputs/dme", 28);
        setprop("systems/electrical/outputs/efis", 28);
#        setprop("systems/electrical/outputs/fuel-pump", 28);
        setprop("systems/electrical/outputs/gps-mfd", 28);
        setprop("systems/electrical/outputs/gps", 28);
        setprop("systems/electrical/outputs/hsi", 28);
        setprop("systems/electrical/outputs/inst-lights", 28);
        setprop("systems/electrical/outputs/mk-viii", 28);
        setprop("systems/electrical/outputs/mk[0]", 28);
        setprop("systems/electrical/outputs/nav", 28);
        setprop("systems/electrical/outputs/nav[1]", 28);
        setprop("systems/electrical/outputs/nav-lights", 28);
        setprop("systems/electrical/outputs/tacan", 28);
        setprop("systems/electrical/outputs/transponder", 28);
        setprop("systems/electrical/outputs/turn-coordinator", 28);
        setprop("systems/electrical/outputs/voltmeter", 28);


        if (engine1_on and gen1_on) {
          setprop("controls/electric/gen1-warn", 0);
          setprop("systems/electrical/outputs/gen1-amps", 400);
        } else {
          setprop("controls/electric/gen1-warn", 1);
          setprop("systems/electrical/outputs/gen1-amps", 0);
        }

        if (engine2_on and gen2_on) {
          setprop("controls/electric/gen2-warn", 0);
          setprop("systems/electrical/outputs/gen2-amps", 400);
        } else {
          setprop("controls/electric/gen2-warn", 1);
          setprop("systems/electrical/outputs/gen2-amps", 0);
        }

        if (engine1_on and gen1_on and inv1_switch) {
          setprop("controls/electric/inv1-warn", 0);
        } else {
          setprop("controls/electric/inv1-warn", 1);
          setprop("controls/electric/inv1-switch", 0);
        }

        if (engine2_on and gen2_on and inv2_switch) {
          setprop("controls/electric/inv2-warn", 0);
        } else {
          setprop("controls/electric/inv2-warn", 1);
          setprop("controls/electric/inv2-switch", 0);
        }

        if (engine1_on and gen1_on and inv1_switch and engine2_on and gen2_on and inv2_switch and inv3_switch) {
          setprop("controls/electric/inv3-warn", 0);
        } else {
          if (neb_override) {
            setprop("controls/electric/inv3-warn", 0);
          } else {
            setprop("controls/electric/inv3-warn", 1);
          }
        }

    } else {
        setprop("systems/electrical/on", 0);
        setprop("systems/electrical/outputs/DG", 0);
        setprop("systems/electrical/outputs/MRG", 0);
        setprop("systems/electrical/outputs/adf", 0);
        setprop("systems/electrical/outputs/audio-panel", 0);
        setprop("systems/electrical/outputs/avionics-fan", 0);
        setprop("systems/electrical/outputs/comm", 0);
        setprop("systems/electrical/outputs/comm[1]", 0);
        setprop("instrumentation/comm[0]/serviceable", 0);
        setprop("instrumentation/comm[1]/serviceable", 0);
        setprop("systems/electrical/outputs/dme", 0);
        setprop("systems/electrical/outputs/efis", 0);
#        setprop("systems/electrical/outputs/fuel-pump", 0);
        setprop("systems/electrical/outputs/gps-mfd", 0);
        setprop("systems/electrical/outputs/gps", 0);
        setprop("systems/electrical/outputs/hsi", 0);
        setprop("systems/electrical/outputs/inst-lights", 0);
        setprop("systems/electrical/outputs/mk-viii", 0);
        setprop("systems/electrical/outputs/mk[0]", 0);
        setprop("systems/electrical/outputs/nav", 0);
        setprop("systems/electrical/outputs/nav[1]", 0);
        setprop("systems/electrical/outputs/nav-lights", 0);
        setprop("systems/electrical/outputs/tacan", 0);
        setprop("systems/electrical/outputs/transponder", 0);
        setprop("systems/electrical/outputs/turn-coordinator", 0);
        setprop("systems/electrical/outputs/voltmeter", 0);
        setprop("controls/electric/inv1-warn", 0);
        setprop("controls/electric/inv2-warn", 0);
        setprop("controls/electric/inv3-warn", 0);
        setprop("systems/electrical/outputs/gen1-amps", 0);
        setprop("systems/electrical/outputs/gen2-amps", 0);
    }


    settimer(elec_loop, 1);

}

elec_loop();
