#	Font Mapper
var font_mapper = func(family, weight) {
	if( weight == "bold" ){
		return "LiberationFonts/LiberationSans-Bold.ttf";
	} else {
		return "LiberationFonts/LiberationSans-Regular.ttf";
	}
};
	

#	Property Setup for all instruments (PFDs, MFDs, NDs, ED)
var volts = {
	pfd: [
		props.globals.initNode("systems/electrical/outputs/pfd[0]", 0.0, "DOUBLE"),
		props.globals.initNode("systems/electrical/outputs/pfd[1]", 0.0, "DOUBLE"),
	],
	mfd: [
		props.globals.initNode("systems/electrical/outputs/mfd[0]", 0.0, "DOUBLE"),
		props.globals.initNode("systems/electrical/outputs/mfd[1]", 0.0, "DOUBLE"),
	],
	ed:	props.globals.initNode("systems/electrical/outputs/esid", 0.0, "DOUBLE"),
};
var main_page = [
	props.globals.initNode("instrumentation/mfd[0]/inputs/main-page", "nd", "STRING"),
	props.globals.initNode("instrumentation/mfd[1]/inputs/main-page", "sys", "STRING"),
];
var main_page_knob = [
	props.globals.initNode("instrumentation/mfd[0]/inputs/main-page-knob", 1, "INT"),
	props.globals.initNode("instrumentation/mfd[1]/inputs/main-page-knob", 2, "INT"),
];
var sys_page = [
	props.globals.initNode("instrumentation/mfd[0]/inputs/sys-page", "elec", "STRING"),
	props.globals.initNode("instrumentation/mfd[1]/inputs/sys-page", "elec", "STRING"),
];
#	Properties for ESID and ENG/FUEL pages of the MFD
var eng = {
	torque: [
		props.globals.getNode("engines/engine[0]/thruster/torque"),
		props.globals.getNode("engines/engine[1]/thruster/torque"),
	],
	rpm: [
		props.globals.getNode("engines/engine[0]/thruster/rpm", 1),
		props.globals.getNode("engines/engine[1]/thruster/rpm", 1),
	],
	itt: [
		props.globals.initNode("engines/engine[0]/itt_degc", 0.0, "DOUBLE"),
		props.globals.initNode("engines/engine[1]/itt_degc", 0.0, "DOUBLE"),
	],
	fuel_flow: [
		props.globals.getNode("engines/engine[0]/fuel-flow_pph"),
		props.globals.getNode("engines/engine[1]/fuel-flow_pph"),
	],
	oil: {
		pressure: [
			props.globals.initNode("engines/engine[0]/oil-pressure-psi", 0.0, "DOUBLE"),
			props.globals.initNode("engines/engine[1]/oil-pressure-psi", 0.0, "DOUBLE"),
		],
		temperature: [
			props.globals.getNode("engines/engine[0]/oil-temperature-degc"),
			props.globals.getNode("engines/engine[1]/oil-temperature-degc"),
		],
	},
	n1: [
		props.globals.getNode("engines/engine[0]/n1"),
		props.globals.getNode("engines/engine[0]/n1"),
	],
	n2: [
		props.globals.getNode("engines/engine[0]/n2"),
		props.globals.getNode("engines/engine[1]/n2"),
	],
	thrustmode: [
		props.globals.getNode("FADEC/thrust-mode[0]"),
		props.globals.getNode("FADEC/thrust-mode[1]"),
	],
};
var fuel = {
	quantity: [
		props.globals.getNode("consumables/fuel/tank[0]/level-lbs"),
		props.globals.getNode("consumables/fuel/tank[1]/level-lbs"),
	],
	temperature: [
		props.globals.getNode("consumables/fuel/tank[0]/temperature_degC",1),
		props.globals.getNode("consumables/fuel/tank[1]/temperature_degC",1),
	],
	transfer:	props.globals.initNode("controls/fuel/transfer", 0, "INT"),
	total_quantity:	props.globals.getNode("consumables/fuel/total-fuel-lbs"),
	boost_pump: [
		props.globals.getNode("controls/fuel/tank[0]/boost-pump"),
		props.globals.getNode("controls/fuel/tank[1]/boost-pump"),
	],
};
var sat = props.globals.getNode("environment/temperature-degc");

#	Display Unit Status
var du_status = [ 0, 0, 0, 0, 0 ];	# 0 = OFF; 1 = TEST; 2 = ON
var du_status_prop = [
	props.globals.initNode("instrumentation/eis/du[0]/status", 0, "INT"),
	props.globals.initNode("instrumentation/eis/du[1]/status", 0, "INT"),
	props.globals.initNode("instrumentation/eis/du[2]/status", 0, "INT"),
	props.globals.initNode("instrumentation/eis/du[3]/status", 0, "INT"),
	props.globals.initNode("instrumentation/eis/du[4]/status", 0, "INT"),
];

var du_status_update = maketimer( 0.1, func() {	forindex( var i; du_status ){ du_status_prop[ i ].setIntValue( du_status[ i ] ); } } );
du_status_update.simulatedTime = 1;
du_status_update.start();

setlistener( volts.pfd[0], func () {
	if( volts.pfd[0].getDoubleValue() > 10 and du_status[0] == 0 ){
		du_status[0] = 1;
		settimer( func() { du_status[0] = 2; }, 5 * rand() );
	} else if( volts.pfd[0].getDoubleValue() <= 10 and du_status[0] > 0 ){
		du_status[0] = 0;
	}
});
setlistener( volts.pfd[1], func () {
	if( volts.pfd[1].getDoubleValue() > 10 and du_status[4] == 0 ){
		du_status[4] = 1;
		settimer( func() { du_status[4] = 2; }, 5 * rand() );
	} else if( volts.pfd[1].getDoubleValue() <= 10 and du_status[4] > 0 ){
		du_status[4] = 0;
	}
});

setlistener( volts.ed, func () {
	if( volts.ed.getDoubleValue() > 10 and du_status[2] == 0 ){
		du_status[2] = 1;
		settimer( func() { du_status[2] = 2; }, 5 * rand() );
	} else if( volts.ed.getDoubleValue() <= 10 and du_status[2] > 0 ){
		du_status[2] = 0;
	}
});

setlistener( volts.mfd[0], func () {
	if( volts.mfd[1].getDoubleValue() > 10 and du_status[1] == 0 ){
		du_status[1] = 1;
		settimer( func() { du_status[1] = 2; }, 5 * rand() );
	} else if( volts.mfd[1].getDoubleValue() <= 10 and du_status[1] > 0 ){
		du_status[1] = 0;
	}
});
setlistener( volts.mfd[1], func () {
	if( volts.mfd[1].getDoubleValue() > 10 and du_status[3] == 0 ){
		du_status[3] = 1;
		settimer( func() { du_status[3] = 2; }, 5 * rand() );
	} else if( volts.mfd[1].getDoubleValue() <= 10 and du_status[3] > 0 ){
		du_status[3] = 0;
	}
});

var showDU = func( i ){
	# Create a window showing the instrument that is currently displayed on the selected DU
	var dlg = canvas.Window.new([512, 638], "dialog").set("resize", 1);
	if( i == 1 ){
		if( main_page[0].getValue() == "pfd" ){
			dlg.setCanvas( PFD[0].canvas_avail );
		} else {
			dlg.setCanvas( PFD[0].canvas );
		}
	} else if ( i == 2 ){
		if( main_page[0].getValue() == "pfd" ){
			dlg.setCanvas( PFD[0].canvas );
		} else if( main_page[0].getValue() == "ed" ){
			dlg.setCanvas( ED_display );
		} else if( main_page[0].getValue() == "nd" ){
			dlg.setCanvas( nd_display[0] );
		} else {
			dlg.setCanvas( MFD[0].canvas );
		}
	} else if ( i == 3 ){
		if( main_page[0].getValue() == "ed" ){
			dlg.setCanvas( ED_avail );
		} else {
			dlg.setCanvas( ED_display );
		}
	} else if ( i == 4 ){
		if( main_page[1].getValue() == "pfd" ){
			dlg.setCanvas( PFD[1].canvas );
		} else if( main_page[1].getValue() == "ed" ){
			dlg.setCanvas( ED_display );
		} else if( main_page[1].getValue() == "nd" ){
			dlg.setCanvas( nd_display[1] );
		} else {
			dlg.setCanvas( MFD[1].canvas );
		}
	} else if( i == 5 ){
		if( main_page[1].getValue() == "pfd" ){
			dlg.setCanvas( PFD[1].canvas_avail );
		} else {
			dlg.setCanvas( PFD[1].canvas );
		}
	}
}

#	EFIS Data Btn to display switches mapper
var arpt = [
	props.globals.getNode("instrumentation/efis[0]/inputs/arpt", 1),
	props.globals.getNode("instrumentation/efis[1]/inputs/arpt", 1),
];
var vord = [
	props.globals.getNode("instrumentation/efis[0]/inputs/VORD", 1),
	props.globals.getNode("instrumentation/efis[1]/inputs/VORD", 1),
];
var ndb = [
	props.globals.getNode("instrumentation/efis[0]/inputs/NDB", 1),
	props.globals.getNode("instrumentation/efis[1]/inputs/NDB", 1),
];
var data_btn = [
	props.globals.initNode("instrumentation/efis[0]/inputs/data-btn", 0, "INT"),
	props.globals.initNode("instrumentation/efis[1]/inputs/data-btn", 0, "INT"),
];

var translate_data_btn = func( i ){
	var data_v = data_btn[ i ].getIntValue();
	if( data_v == 1 ){
		arpt[ i ].setBoolValue( 0 );
		vord[ i ].setBoolValue( 0 );
		ndb[ i  ].setBoolValue( 1 );
	}else if( data_v == 2 ){
		arpt[ i ].setBoolValue( 1 );
		vord[ i ].setBoolValue( 0 );
		ndb[ i  ].setBoolValue( 0 );
	}else if( data_v == 3 ){
		arpt[ i ].setBoolValue( 1 );
		vord[ i ].setBoolValue( 1 );
		ndb[ i  ].setBoolValue( 1 );
	}else{
		arpt[ i ].setBoolValue( 0 );
		vord[ i ].setBoolValue( 0 );
		ndb[ i  ].setBoolValue( 0 );
	}
}
setlistener( data_btn[0], func { translate_data_btn(0) } );
setlistener( data_btn[1], func { translate_data_btn(1) } );
