#FADEC loop

var throttle_input = [
	props.globals.getNode("/fdm/jsbsim/fcs/fadec/throttle-input[0]", 1),
	props.globals.getNode("/fdm/jsbsim/fcs/fadec/throttle-input[1]", 1),
];
var reversed = [
	props.globals.getNode("/engines/engine[0]/reversed", 1),
	props.globals.getNode("/engines/engine[1]/reversed", 1),
];
var cond_lever_state = [
	props.globals.getNode("/controls/engines/engine[0]/condition-lever-state", 1),
	props.globals.getNode("/controls/engines/engine[1]/condition-lever-state", 1),
];
var mtop_discrete = props.globals.getNode("/controls/engines/mtop-discrete", 1);
var fadec_mode = [
	props.globals.getNode("/FADEC/thrust-mode[0]", 1),
	props.globals.getNode("/FADEC/thrust-mode[1]", 1),
];
var prop_pitch_cmd = [
	props.globals.getNode("/controls/engines/engine[0]/propeller-pitch", 1),
	props.globals.getNode("/controls/engines/engine[1]/propeller-pitch", 1),
];
var prop_feather_cmd = [
	props.globals.getNode("/controls/engines/engine[0]/propeller-feather", 1),
	props.globals.getNode("/controls/engines/engine[1]/propeller-feather", 1),
];

var last_state = [-1,-1];	# -1: always recheck, 0 = EMERG, 1-4 = normal modes
var last_mtop_discrete = [-1, -1];	# -1: always recheck, 0 = off, 1 = on

var update_FADEC = func{
	for( var i = 0; i <= 1; i += 1 ){
		
		if( throttle_input[i].getDoubleValue() <= 0.8 or reversed[i].getBoolValue() ){
			var state = cond_lever_state[i].getIntValue();
			var mtop_discrete_v = mtop_discrete.getBoolValue();
			if( state != last_state[i] or last_mtop_discrete[i] != mtop_discrete_v ){
				if(state==1 or state==4){
					if( mtop_discrete_v ){
						fadec_mode[i].setValue( "MTOP" );
					}else{
						fadec_mode[i].setValue( "NTOP" );
					}
					last_mtop_discrete[i] = mtop_discrete_v;
				}else if(state==2){
					fadec_mode[i].setValue( "MCR" );
				}else if(state==3){
					fadec_mode[i].setValue( "MCL" );
				}else{
					fadec_mode[i].setValue( "" );
				}
				last_state[i] = state;
			}
		}else{
			if( last_state[i] != 0 ){
				fadec_mode[i].setValue( "EMERG" );
				prop_pitch_cmd[i].setDoubleValue( 1.0 );
				prop_feather_cmd[i].setBoolValue( 0 );
				last_state[i] = 0;
			}
		}
		
	}
}

var fadec_loop = maketimer( 0.0, update_FADEC );
fadec_loop.simulatedTime = 1;

var fadec_lis = setlistener("/sim/signals/fdm-initialized", func {
	fadec_loop.start();
	removelistener( fadec_lis );
	print("FADEC (Full Authority Digital Engine Control) loaded.");
});
