##	Side String
#
#	influenced by
#		air flow ( speed, alpha )
#		random jitter
#		gravity (if airspeed below 10 kts)

var airspeed_p = props.globals.getNode("velocities/airspeed-kt", 1);
var alpha_p = props.globals.getNode("fdm/jsbsim/aero/alpha-deg", 1);
var nx_p = props.globals.getNode("accelerations/pilot/x-accel-fps_sec", 1);
var nz_p = props.globals.getNode("accelerations/pilot/z-accel-fps_sec", 1);
var canopy_norm_p = props.globals.getNode("sim/asw20/canopy-pos-norm", 1);
var sidestring_p = props.globals.initNode("instrumentation/sidestring", 0.0, "DOUBLE");

var sidestring = func {
	
	var airspeed = airspeed_p.getDoubleValue();
	var severity = 0;	   
	if  (  airspeed < 54 ) 
	{
		severity = ( math.sin (  math.pi * airspeed/54 ) * rand() ) ;
	}
	var deflection = alpha_p.getDoubleValue() + severity ;
	
	# influence of gravity on side-string (only for low airspeed)      
	var airspeed_norm = airspeed / 10. ; 
	if( airspeed_norm < 1. ) {
		
		var gravity_direction_deg = math.atan2( nz_p.getDoubleValue(), nx_p.getDoubleValue() ) * 180. / math.pi - canopy_norm_p.getDoubleValue() * 45;
		
		deflection =  (1 - airspeed_norm ) * gravity_direction_deg + airspeed_norm * deflection ;
	}
	
	sidestring_p.setDoubleValue( deflection );
}

var sidestring_loop = maketimer( 0.0, sidestring );
sidestring_loop.simulatedTime = 1;

sidestring_loop.start();
