/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import vlcskineditor.Helper;
import vlcskineditor.Item;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Skin;
import vlcskineditor.Window;
import vlcskineditor.XML;
import vlcskineditor.history.LayoutAddEvent;
import vlcskineditor.history.LayoutEditEvent;
import vlcskineditor.items.Anchor;
import vlcskineditor.items.Button;
import vlcskineditor.items.Checkbox;
import vlcskineditor.items.Group;
import vlcskineditor.items.Image;
import vlcskineditor.items.Panel;
import vlcskineditor.items.Playtree;
import vlcskineditor.items.RadialSlider;
import vlcskineditor.items.Slider;
import vlcskineditor.items.Text;
import vlcskineditor.items.Video;

public class Layout
implements ActionListener {
    public final String ID_DEFAULT = "none";
    public final int MINWIDTH_DEFAULT = -1;
    public final int MINHEIGHT_DEFAULT = -1;
    public final int MAXWIDTH_DEFAULT = -1;
    public final int MAXHEIGHT_DEFAULT = -1;
    public String id = "none";
    public int minwidth = -1;
    public int minheight = -1;
    public int maxwidth = -1;
    public int maxheight = -1;
    public int width;
    public int height;
    Skin s;
    Window parent;
    JFrame frame = null;
    JTextField id_tf;
    JTextField width_tf;
    JTextField height_tf;
    JTextField minwidth_tf;
    JTextField minheight_tf;
    JTextField maxwidth_tf;
    JTextField maxheight_tf;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;
    List<Item> items = new LinkedList<Item>();
    String type = "List";
    boolean created = false;

    public Layout(String string, Window window, Skin skin) {
        int n;
        this.s = skin;
        this.parent = window;
        String[] stringArray = string.split("\n");
        this.width = XML.getIntValue(stringArray[0], "width");
        this.height = XML.getIntValue(stringArray[0], "height");
        this.id = stringArray[0].indexOf("id=\"") != -1 ? XML.getValue(stringArray[0], "id") : "Unnamed layout #" + this.s.getNewId();
        if (stringArray[0].indexOf("minwidth=\"") != -1) {
            this.minwidth = XML.getIntValue(stringArray[0], "minwidth");
        }
        if (stringArray[0].indexOf("maxwidth=\"") != -1) {
            this.maxwidth = XML.getIntValue(stringArray[0], "maxwidth");
        }
        if (stringArray[0].indexOf("minheight=\"") != -1) {
            this.minheight = XML.getIntValue(stringArray[0], "minheight");
        }
        if (stringArray[0].indexOf("maxheight=\"") != -1) {
            this.maxheight = XML.getIntValue(stringArray[0], "maxheight");
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = stringArray[n].trim();
        }
        for (n = 1; n < stringArray.length; ++n) {
            String string2;
            if (stringArray[n].startsWith("<!--")) {
                while (stringArray[n].indexOf("-->") == -1) {
                    ++n;
                }
                continue;
            }
            if (stringArray[n].startsWith("<Anchor")) {
                this.items.add(new Anchor(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Button")) {
                this.items.add(new Button(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Checkbox")) {
                this.items.add(new Checkbox(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Image")) {
                this.items.add(new Image(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Text")) {
                this.items.add(new Text(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Video")) {
                this.items.add(new Video(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<RadialSlider")) {
                this.items.add(new RadialSlider(stringArray[n], this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Group")) {
                string2 = stringArray[n];
                ++n;
                while (!stringArray[n].startsWith("</Group>")) {
                    string2 = string2 + "\n" + stringArray[n];
                    ++n;
                }
                string2 = string2 + "\n" + stringArray[n];
                this.items.add(new Group(string2, this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Panel")) {
                string2 = stringArray[n];
                ++n;
                while (!stringArray[n].startsWith("</Panel>")) {
                    string2 = string2 + "\n" + stringArray[n];
                    ++n;
                }
                string2 = string2 + "\n" + stringArray[n];
                this.items.add(new Panel(string2, this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Playlist")) {
                string2 = stringArray[n];
                ++n;
                while (!stringArray[n].startsWith("</Playlist>")) {
                    string2 = string2 + "\n" + stringArray[n];
                    ++n;
                }
                string2 = string2 + "\n" + stringArray[n];
                this.items.add(new Playtree(string2, this.s));
                continue;
            }
            if (stringArray[n].startsWith("<Playtree")) {
                string2 = stringArray[n];
                ++n;
                while (!stringArray[n].startsWith("</Playtree>")) {
                    string2 = string2 + "\n" + stringArray[n];
                    ++n;
                }
                string2 = string2 + "\n" + stringArray[n];
                this.items.add(new Playtree(string2, this.s));
                continue;
            }
            if (!stringArray[n].startsWith("<Slider")) continue;
            if (stringArray[n].indexOf("/>") != -1) {
                this.items.add(new Slider(stringArray[n], this.s));
                continue;
            }
            string2 = stringArray[n];
            ++n;
            while (!stringArray[n].startsWith("</Slider>")) {
                string2 = string2 + "\n" + stringArray[n];
                ++n;
            }
            string2 = string2 + "\n" + stringArray[n];
            this.items.add(new Slider(string2, this.s));
        }
        this.created = true;
    }

    public Layout(Window window, Skin skin) {
        this.s = skin;
        this.parent = window;
        this.id = "Unnamed layout #" + this.s.getNewId();
        this.width = 0;
        this.height = 0;
        this.showOptions();
    }

    public void update() {
        if (!this.created) {
            LayoutAddEvent layoutAddEvent = new LayoutAddEvent(this.parent, this);
            this.id = this.id_tf.getText();
            this.width = Integer.parseInt(this.width_tf.getText());
            this.height = Integer.parseInt(this.height_tf.getText());
            this.minwidth = Integer.parseInt(this.minwidth_tf.getText());
            this.minheight = Integer.parseInt(this.minheight_tf.getText());
            this.maxwidth = Integer.parseInt(this.maxwidth_tf.getText());
            this.maxheight = Integer.parseInt(this.maxheight_tf.getText());
            this.s.updateWindows();
            this.s.expandLayout(this.id);
            this.created = true;
            this.frame.setDefaultCloseOperation(1);
            this.s.m.hist.addEvent(layoutAddEvent);
        } else {
            LayoutEditEvent layoutEditEvent = new LayoutEditEvent(this);
            this.id = this.id_tf.getText();
            this.width = Integer.parseInt(this.width_tf.getText());
            this.height = Integer.parseInt(this.height_tf.getText());
            this.minwidth = Integer.parseInt(this.minwidth_tf.getText());
            this.minheight = Integer.parseInt(this.minheight_tf.getText());
            this.maxwidth = Integer.parseInt(this.maxwidth_tf.getText());
            this.maxheight = Integer.parseInt(this.maxheight_tf.getText());
            this.s.updateWindows();
            this.s.expandLayout(this.id);
            layoutEditEvent.setNew();
            this.s.m.hist.addEvent(layoutEditEvent);
        }
    }

    public void showOptions() {
        if (this.frame == null) {
            this.frame = new JFrame("Layout settings");
            this.frame.setResizable(false);
            this.frame.setLayout(new FlowLayout());
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel("ID*:");
            this.id_tf = new JTextField();
            this.id_tf.setToolTipText("Name of the layout (it may be used for actions). Two layouts cannot have the same id.");
            JLabel jLabel2 = new JLabel("Initial width*:");
            this.width_tf = new JTextField();
            this.width_tf.setDocument(new NumbersOnlyDocument());
            this.width_tf.setToolTipText("Initial width of the layout. This value is required since VLC is not (yet?) able to calculate it using the sizes and positions of the controls.");
            JLabel jLabel3 = new JLabel("Initial height*:");
            this.height_tf = new JTextField();
            this.height_tf.setDocument(new NumbersOnlyDocument());
            this.height_tf.setToolTipText("Initial height of the layout. This value is required since VLC is not (yet?) able to calculate it using the sizes and positions of the controls.");
            JLabel jLabel4 = new JLabel("Min. width:");
            this.minwidth_tf = new JTextField();
            this.minwidth_tf.setDocument(new NumbersOnlyDocument());
            this.minwidth_tf.setToolTipText("Minimum width of the layout. This value is only used when resizing the layout. If this value is set to \"-1\", the initial width (as specified by the width attribute) will be used as minimum width.");
            JLabel jLabel5 = new JLabel("Min. height:");
            this.minheight_tf = new JTextField();
            this.minheight_tf.setDocument(new NumbersOnlyDocument());
            this.minheight_tf.setToolTipText("Minimum height of the layout. This value is only used when resizing the layout. If this value is set to \"-1\", the initial width (as specified by the width attribute) will be used as minimum width.");
            JLabel jLabel6 = new JLabel("Max. width:");
            this.maxwidth_tf = new JTextField();
            this.maxwidth_tf.setDocument(new NumbersOnlyDocument());
            this.maxwidth_tf.setToolTipText("Maximum width of the layout. This value is only used when resizing the layout. If this value is set to \"-1\", the initial width (as specified by the width attribute) will be used as maximum width.");
            JLabel jLabel7 = new JLabel("Max. height:");
            this.maxheight_tf = new JTextField();
            this.maxheight_tf.setDocument(new NumbersOnlyDocument());
            this.maxheight_tf.setToolTipText("Maximum height of the layout. This value is only used when resizing the layout. If this value is set to \"-1\", the initial width (as specified by the width attribute) will be used as maximum width.");
            this.ok_btn = new JButton("OK");
            this.ok_btn.addActionListener(this);
            this.cancel_btn = new JButton("Cancel");
            this.cancel_btn.addActionListener(this);
            this.help_btn = new JButton("Help");
            this.help_btn.addActionListener(this);
            JLabel jLabel8 = new JLabel("* Attributes marked with a star must be specified.");
            Component[] componentArray = new Component[]{jLabel, jLabel2, jLabel3, jLabel4, jLabel5, jLabel6, jLabel7};
            int n = Helper.maxWidth(componentArray) + 10;
            int n2 = 200;
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            this.id_tf.setPreferredSize(new Dimension(n2, this.id_tf.getPreferredSize().height));
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "General Attributes"));
            SpringLayout springLayout = new SpringLayout();
            jPanel.setLayout(springLayout);
            springLayout.putConstraint("North", (Component)jLabel, 5, "North", (Component)jPanel);
            springLayout.putConstraint("West", (Component)jLabel, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.id_tf, 0, "VerticalCenter", (Component)jLabel);
            springLayout.putConstraint("West", (Component)this.id_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)jPanel, 5, "East", (Component)this.id_tf);
            springLayout.putConstraint("South", (Component)jPanel, 10, "South", (Component)jLabel);
            this.frame.add(jPanel);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel2);
            jPanel2.add(this.width_tf);
            this.width_tf.setPreferredSize(new Dimension(n2, this.width_tf.getPreferredSize().height));
            jPanel2.add(jLabel3);
            jPanel2.add(this.height_tf);
            this.height_tf.setPreferredSize(new Dimension(n2, this.height_tf.getPreferredSize().height));
            jPanel2.add(jLabel4);
            jPanel2.add(this.minwidth_tf);
            this.minwidth_tf.setPreferredSize(new Dimension(n2, this.minwidth_tf.getPreferredSize().height));
            jPanel2.add(jLabel5);
            jPanel2.add(this.minheight_tf);
            this.minheight_tf.setPreferredSize(new Dimension(n2, this.minheight_tf.getPreferredSize().height));
            jPanel2.add(jLabel6);
            jPanel2.add(this.maxwidth_tf);
            this.maxwidth_tf.setPreferredSize(new Dimension(n2, this.maxwidth_tf.getPreferredSize().height));
            jPanel2.add(jLabel7);
            jPanel2.add(this.maxheight_tf);
            this.maxheight_tf.setPreferredSize(new Dimension(n2, this.maxheight_tf.getPreferredSize().height));
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Dimensions"));
            SpringLayout springLayout2 = new SpringLayout();
            jPanel2.setLayout(springLayout2);
            springLayout2.putConstraint("North", (Component)jLabel2, 5, "North", (Component)jPanel2);
            springLayout2.putConstraint("West", (Component)jLabel2, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.width_tf, 0, "VerticalCenter", (Component)jLabel2);
            springLayout2.putConstraint("West", (Component)this.width_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)jPanel2, 5, "East", (Component)this.width_tf);
            springLayout2.putConstraint("North", (Component)jLabel3, 10, "South", (Component)jLabel2);
            springLayout2.putConstraint("West", (Component)jLabel3, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.height_tf, 0, "VerticalCenter", (Component)jLabel3);
            springLayout2.putConstraint("West", (Component)this.height_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.height_tf, 0, "East", (Component)this.width_tf);
            springLayout2.putConstraint("North", (Component)jLabel4, 10, "South", (Component)jLabel3);
            springLayout2.putConstraint("West", (Component)jLabel4, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.minwidth_tf, 0, "VerticalCenter", (Component)jLabel4);
            springLayout2.putConstraint("West", (Component)this.minwidth_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.minwidth_tf, 0, "East", (Component)this.width_tf);
            springLayout2.putConstraint("North", (Component)jLabel5, 10, "South", (Component)jLabel4);
            springLayout2.putConstraint("West", (Component)jLabel5, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.minheight_tf, 0, "VerticalCenter", (Component)jLabel5);
            springLayout2.putConstraint("West", (Component)this.minheight_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.minheight_tf, 0, "East", (Component)this.width_tf);
            springLayout2.putConstraint("North", (Component)jLabel6, 10, "South", (Component)jLabel5);
            springLayout2.putConstraint("West", (Component)jLabel6, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.maxwidth_tf, 0, "VerticalCenter", (Component)jLabel6);
            springLayout2.putConstraint("West", (Component)this.maxwidth_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.maxwidth_tf, 0, "East", (Component)this.width_tf);
            springLayout2.putConstraint("North", (Component)jLabel7, 10, "South", (Component)jLabel6);
            springLayout2.putConstraint("West", (Component)jLabel7, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.maxheight_tf, 0, "VerticalCenter", (Component)jLabel7);
            springLayout2.putConstraint("West", (Component)this.maxheight_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.maxheight_tf, 0, "East", (Component)this.width_tf);
            springLayout2.putConstraint("South", (Component)jPanel2, 10, "South", (Component)jLabel7);
            this.frame.add(jPanel2);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(jLabel8);
            SpringLayout springLayout3 = new SpringLayout();
            this.frame.setLayout(springLayout3);
            springLayout3.putConstraint("North", (Component)jPanel, 5, "North", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("West", (Component)jPanel, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)jPanel2, 5, "South", (Component)jPanel);
            springLayout3.putConstraint("West", (Component)jPanel2, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)jLabel8, 5, "South", (Component)jPanel2);
            springLayout3.putConstraint("West", (Component)jLabel8, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("East", (Component)jLabel8, 5, "East", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.ok_btn, 5, "South", (Component)jLabel8);
            springLayout3.putConstraint("North", (Component)this.cancel_btn, 5, "South", (Component)jLabel8);
            springLayout3.putConstraint("North", (Component)this.help_btn, 5, "South", (Component)jLabel8);
            springLayout3.putConstraint("West", (Component)this.ok_btn, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("West", (Component)this.cancel_btn, 5, "East", (Component)this.ok_btn);
            springLayout3.putConstraint("West", (Component)this.help_btn, 5, "East", (Component)this.cancel_btn);
            springLayout3.putConstraint("South", (Component)this.frame.getContentPane(), 5, "South", (Component)this.ok_btn);
            springLayout3.putConstraint("East", (Component)this.frame.getContentPane(), 5, "East", (Component)jPanel);
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.width_tf.setText(String.valueOf(this.width));
        this.height_tf.setText(String.valueOf(this.height));
        this.minwidth_tf.setText(String.valueOf(this.minwidth));
        this.minheight_tf.setText(String.valueOf(this.minheight));
        this.maxwidth_tf.setText(String.valueOf(this.maxwidth));
        this.maxheight_tf.setText(String.valueOf(this.maxheight));
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "Please enter a valid ID!", "ID not valid", 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, "The ID \"" + this.id_tf.getText() + "\" already exists, please choose another one.", "ID not valid", 1);
                return;
            }
            if (Integer.parseInt(this.width_tf.getText()) <= 0) {
                JOptionPane.showMessageDialog(this.frame, "Please enter a valid width!", "Width not valid", 1);
                return;
            }
            if (Integer.parseInt(this.height_tf.getText()) <= 0) {
                JOptionPane.showMessageDialog(this.frame, "Please enter a valid height!", "Height not valid", 1);
                return;
            }
            this.frame.setVisible(false);
            this.update();
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/layout.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skinedhlp/layout.html", 2);
            }
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            this.frame.setVisible(false);
            if (!this.created) {
                for (Window window : this.s.windows) {
                    if (window.getLayout(this.id) == null) continue;
                    window.layouts.remove(this);
                }
            }
        }
    }

    public void draw(Graphics2D graphics2D, int n) {
        for (Item item : this.items) {
            item.draw(graphics2D, n);
        }
    }

    public String returnCode(String string) {
        String string2 = string + "<Layout";
        if (!this.id.equals("none")) {
            string2 = string2 + " id=\"" + this.id + "\"";
        }
        string2 = string2 + " width=\"" + String.valueOf(this.width) + "\" height=\"" + String.valueOf(this.height) + "\"";
        if (this.minwidth != -1) {
            string2 = string2 + " minwidth=\"" + String.valueOf(this.minwidth) + "\"";
        }
        if (this.maxwidth != -1) {
            string2 = string2 + " maxwidth=\"" + String.valueOf(this.maxwidth) + "\"";
        }
        if (this.minheight != -1) {
            string2 = string2 + " minheight=\"" + String.valueOf(this.minheight) + "\"";
        }
        if (this.maxheight != -1) {
            string2 = string2 + " maxheight=\"" + String.valueOf(this.maxheight) + "\"";
        }
        string2 = string2 + ">";
        for (int i = 0; i < this.items.size(); ++i) {
            string2 = string2 + "\n" + this.items.get(i).returnCode(string + Skin.indentation);
        }
        string2 = string2 + "\n" + string + "</Layout>";
        return string2;
    }

    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Layout: " + this.id);
        return defaultMutableTreeNode;
    }

    public Item getItem(String string) {
        for (int i = 0; i < this.items.size(); ++i) {
            Item item = this.items.get(i).getItem(string);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public List<Item> getParentListOf(String string) {
        for (int i = 0; i < this.items.size(); ++i) {
            List<Item> list;
            Item item = this.items.get(i);
            if (item.id.equals(string)) {
                return this.items;
            }
            if (!item.type.equals("Group") && !item.type.equals("Panel") || (list = item.getParentListOf(string)) == null) continue;
            return list;
        }
        return null;
    }

    public Item getParentOf(String string) {
        for (int i = 0; i < this.items.size(); ++i) {
            Item item = this.items.get(i);
            if (item.id.equals(string)) {
                return null;
            }
            Item item2 = item.getParentOf(string);
            if (item2 == null) continue;
            return item2;
        }
        return null;
    }

    public boolean uses(String string) {
        for (Item item : this.items) {
            if (!item.uses(string)) continue;
            return true;
        }
        return false;
    }

    public void renameForCopy(String string) {
        String string2;
        String string3 = string;
        String string4 = string2 = (string = string.replaceAll("%oldid%", this.id));
        int n = 1;
        while (this.s.idExists(string4)) {
            string4 = string2 + "_" + String.valueOf(++n);
        }
        this.id = string4;
        for (Item item : this.items) {
            item.renameForCopy(string3);
        }
    }
}

