/*
 * Decompiled with CFR 0.152.
 */
package com.ice.tar;

import com.ice.tar.InvalidHeaderException;
import com.ice.tar.TarArchive;
import com.ice.tar.TarEntry;
import com.ice.tar.TarProgressDisplay;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;

public class tar
implements TarProgressDisplay {
    private boolean debug = false;
    private boolean verbose = false;
    private boolean compressed = false;
    private boolean listingArchive = false;
    private boolean writingArchive = true;
    private boolean unixArchiveFormat = false;
    private boolean keepOldFiles = false;
    private boolean asciiTranslate = false;
    private boolean mimeFileLoaded;
    private String archiveName = null;
    private int blockSize = 10240;
    private int userId;
    private String userName;
    private int groupId;
    private String groupName;

    public static void main(String[] stringArray) {
        tar tar2 = new tar();
        tar2.instanceMain(stringArray);
    }

    public tar() {
        String string = System.getProperty("user.name");
        this.userId = 0;
        this.userName = string == null ? "" : string;
        this.groupId = 0;
        this.groupName = "";
    }

    public void instanceMain(String[] stringArray) {
        Object object;
        Object object2;
        TarArchive tarArchive = null;
        int n = this.processArguments(stringArray);
        if (this.writingArchive) {
            object2 = System.out;
            if (this.archiveName != null && !this.archiveName.equals("-")) {
                try {
                    object2 = new FileOutputStream(this.archiveName);
                }
                catch (IOException iOException) {
                    object2 = null;
                    iOException.printStackTrace(System.err);
                }
            }
            if (object2 != null) {
                if (this.compressed) {
                    try {
                        object2 = new GZIPOutputStream((OutputStream)object2);
                    }
                    catch (IOException iOException) {
                        object2 = null;
                        iOException.printStackTrace(System.err);
                    }
                }
                tarArchive = new TarArchive((OutputStream)object2, this.blockSize);
            }
        } else {
            object2 = System.in;
            if (this.archiveName != null && !this.archiveName.equals("-")) {
                try {
                    object2 = new FileInputStream(this.archiveName);
                }
                catch (IOException iOException) {
                    object2 = null;
                    iOException.printStackTrace(System.err);
                }
            }
            if (object2 != null) {
                if (this.compressed) {
                    try {
                        object2 = new GZIPInputStream((InputStream)object2);
                    }
                    catch (IOException iOException) {
                        object2 = null;
                        iOException.printStackTrace(System.err);
                    }
                }
                tarArchive = new TarArchive((InputStream)object2, this.blockSize);
            }
        }
        if (tarArchive != null) {
            tarArchive.setDebug(this.debug);
            tarArchive.setVerbose(this.verbose);
            tarArchive.setTarProgressDisplay(this);
            tarArchive.setKeepOldFiles(this.keepOldFiles);
            tarArchive.setAsciiTranslation(this.asciiTranslate);
            tarArchive.setUserInfo(this.userId, this.userName, this.groupId, this.groupName);
        }
        if (tarArchive == null) {
            System.err.println("no processing due to errors");
        } else if (this.writingArchive) {
            while (n < stringArray.length) {
                try {
                    object2 = new File(stringArray[n]);
                    object = new TarEntry((File)object2);
                    if (this.unixArchiveFormat) {
                        ((TarEntry)object).setUnixTarFormat();
                    } else {
                        ((TarEntry)object).setUSTarFormat();
                    }
                    tarArchive.writeEntry((TarEntry)object, true);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
                ++n;
            }
        } else if (this.listingArchive) {
            try {
                tarArchive.listContents();
            }
            catch (InvalidHeaderException invalidHeaderException) {
                invalidHeaderException.printStackTrace(System.err);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        } else {
            object2 = System.getProperty("user.dir", null);
            object = new File((String)object2);
            if (!((File)object).exists() && !((File)object).mkdirs()) {
                object = null;
                Throwable throwable = new Throwable("ERROR, mkdirs() on '" + ((File)object).getPath() + "' returned false.");
                throwable.printStackTrace(System.err);
            }
            if (object != null) {
                try {
                    tarArchive.extractContents((File)object);
                }
                catch (InvalidHeaderException invalidHeaderException) {
                    invalidHeaderException.printStackTrace(System.err);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
            }
        }
        if (tarArchive != null) {
            try {
                tarArchive.closeArchive();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
    }

    private int processArguments(String[] stringArray) {
        String string;
        int n;
        boolean bl = false;
        for (n = 0; n < stringArray.length && (string = stringArray[n]).startsWith("-"); ++n) {
            if (string.startsWith("--")) {
                Serializable serializable;
                Serializable serializable2;
                if (string.equals("--usage")) {
                    this.usage();
                    System.exit(1);
                    continue;
                }
                if (string.equals("--version")) {
                    this.version();
                    System.exit(1);
                    continue;
                }
                if (string.equals("--trans")) {
                    this.asciiTranslate = true;
                    String string2 = "javax.activation.FileTypeMap";
                    try {
                        serializable2 = Class.forName(string2);
                        if (this.mimeFileLoaded) continue;
                        serializable = tar.class.getResource("/com/ice/tar/asciimime.txt");
                        URLConnection uRLConnection = serializable.openConnection();
                        InputStream inputStream = uRLConnection.getInputStream();
                        FileTypeMap.setDefaultFileTypeMap((FileTypeMap)new MimetypesFileTypeMap(inputStream));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.err.println("Could not load the class named '" + string2 + "'.\n" + "The Java Activation package must " + "be installed to use ascii translation.");
                        System.exit(1);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                        System.exit(1);
                    }
                    continue;
                }
                if (string.equals("--mime")) {
                    this.mimeFileLoaded = true;
                    String string3 = "javax.activation.FileTypeMap";
                    serializable2 = new File(stringArray[++n]);
                    try {
                        serializable = Class.forName(string3);
                        FileTypeMap.setDefaultFileTypeMap((FileTypeMap)new MimetypesFileTypeMap((InputStream)new FileInputStream((File)serializable2)));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.err.println("Could not load the class named '" + string3 + "'.\n" + "The Java Activation package must " + "be installed to use ascii translation.");
                        System.exit(1);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.err.println("Could not open the mimetypes file '" + ((File)serializable2).getPath() + "', " + fileNotFoundException.getMessage());
                    }
                    continue;
                }
                System.err.println("unknown option: " + string);
                this.usage();
                System.exit(1);
                continue;
            }
            for (int i = 1; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '?') {
                    this.usage();
                    System.exit(1);
                    continue;
                }
                if (c == 'f') {
                    this.archiveName = stringArray[++n];
                    continue;
                }
                if (c == 'z') {
                    this.compressed = true;
                    continue;
                }
                if (c == 'c') {
                    bl = true;
                    this.writingArchive = true;
                    this.listingArchive = false;
                    continue;
                }
                if (c == 'x') {
                    bl = true;
                    this.writingArchive = false;
                    this.listingArchive = false;
                    continue;
                }
                if (c == 't') {
                    bl = true;
                    this.writingArchive = false;
                    this.listingArchive = true;
                    continue;
                }
                if (c == 'k') {
                    this.keepOldFiles = true;
                    continue;
                }
                if (c == 'o') {
                    this.unixArchiveFormat = true;
                    continue;
                }
                if (c == 'b') {
                    try {
                        int n2 = Integer.parseInt(stringArray[++n]);
                        this.blockSize = n2 * 512;
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace(System.err);
                    }
                    continue;
                }
                if (c == 'u') {
                    this.userName = stringArray[++n];
                    continue;
                }
                if (c == 'U') {
                    String string4 = stringArray[++n];
                    try {
                        this.userId = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.userId = 0;
                        numberFormatException.printStackTrace(System.err);
                    }
                    continue;
                }
                if (c == 'g') {
                    this.groupName = stringArray[++n];
                    continue;
                }
                if (c == 'G') {
                    String string5 = stringArray[++n];
                    try {
                        this.groupId = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.groupId = 0;
                        numberFormatException.printStackTrace(System.err);
                    }
                    continue;
                }
                if (c == 'v') {
                    this.verbose = true;
                    continue;
                }
                if (c == 'D') {
                    this.debug = true;
                    continue;
                }
                System.err.println("unknown option: " + c);
                this.usage();
                System.exit(1);
            }
        }
        if (!bl) {
            System.err.println("you must specify an operation option (c, x, or t)");
            this.usage();
            System.exit(1);
        }
        return n;
    }

    @Override
    public void showTarProgressMessage(String string) {
        System.out.println(string);
    }

    private void version() {
        System.err.println("Release 2.4 - $Revision: 1.10 $ $Name:  $");
    }

    private void usage() {
        System.err.println("usage: com.ice.tar.tar has three basic modes:");
        System.err.println("  com.ice.tar -c [options] archive files...");
        System.err.println("    Create new archive containing files.");
        System.err.println("  com.ice.tar -t [options] archive");
        System.err.println("    List contents of tar archive");
        System.err.println("  com.ice.tar -x [options] archive");
        System.err.println("    Extract contents of tar archive.");
        System.err.println("");
        System.err.println("options:");
        System.err.println("   -f file, use 'file' as the tar archive");
        System.err.println("   -v, verbose mode");
        System.err.println("   -z, use GZIP compression");
        System.err.println("   -D, debug archive and buffer operation");
        System.err.println("   -b blks, set blocking size to (blks * 512) bytes");
        System.err.println("   -o, write a V7 format archive rather than ANSI");
        System.err.println("   -u name, set user name to 'name'");
        System.err.println("   -U id, set user id to 'id'");
        System.err.println("   -g name, set group name to 'name'");
        System.err.println("   -G id, set group id to 'id'");
        System.err.println("   -?, print usage information");
        System.err.println("   --trans, translate 'text/*' files");
        System.err.println("   --mime file, use this mime types file and translate");
        System.err.println("   --usage, print usage information");
        System.err.println("   --version, print version information");
        System.err.println("");
        System.err.println("The translation options will translate from local line");
        System.err.println("endings to UNIX line endings of '\\n' when writing tar");
        System.err.println("archives, and from UNIX line endings into local line endings");
        System.err.println("when extracting archives.");
        System.err.println("");
        System.err.println("Written by Tim Endres");
        System.err.println("");
        System.err.println("This software has been placed into the public domain.");
        System.err.println("");
        this.version();
        System.exit(1);
    }
}

