/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import vlcskineditor.FrameUpdater;
import vlcskineditor.Item;
import vlcskineditor.Language;
import vlcskineditor.Layout;
import vlcskineditor.Main;
import vlcskineditor.Window;
import vlcskineditor.history.ItemMoveEvent;

public class PreviewWindow
extends JPanel
implements MouseListener,
MouseMotionListener,
ActionListener {
    public static final long serialVersionUID = 57L;
    public JInternalFrame frame;
    JScrollPane scroll_pane;
    JPanel zoom_panel;
    JButton zoom_more;
    JButton zoom_less;
    JLabel zoom_label;
    int z = 1;
    Layout l;
    FrameUpdater fu;
    Item selected_item;
    boolean starteddragging = false;
    int dragstartx;
    int dragstarty;
    int dragstartitemx;
    int dragstartitemy;
    JMenuItem up;
    JMenuItem down;
    JMenuItem right;
    JMenuItem left;
    ItemMoveEvent ime = null;
    Main m;

    public PreviewWindow(Main main) {
        this.m = main;
        this.frame = new JInternalFrame();
        this.frame.setLayout(new BorderLayout());
        this.zoom_panel = new JPanel();
        this.zoom_panel.setLayout(new FlowLayout());
        this.zoom_less = new JButton("-");
        this.zoom_less.addActionListener(this);
        this.zoom_panel.add(this.zoom_less);
        this.zoom_label = new JLabel(Language.get("ZOOM_FACTOR") + " 1x");
        this.zoom_panel.add(this.zoom_label);
        this.zoom_more = new JButton("+");
        this.zoom_more.addActionListener(this);
        this.zoom_panel.add(this.zoom_more);
        this.zoom_panel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.frame.add((Component)this.zoom_panel, "First");
        this.scroll_pane = new JScrollPane(this);
        this.frame.add((Component)this.scroll_pane, "Center");
        this.frame.pack();
        this.frame.setMinimumSize(this.zoom_panel.getPreferredSize());
        this.frame.setVisible(false);
        this.frame.setResizable(true);
        this.frame.setFrameIcon(Main.preview_icon);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void clearLayout() {
        this.l = null;
        if (this.selected_item != null) {
            this.selected_item.setSelected(false);
        }
        this.selected_item = null;
        this.frame.setVisible(false);
        if (this.fu != null) {
            this.fu.stopRunning();
        }
        this.fu = null;
    }

    public void setLayout(Window window, Layout layout) {
        if (layout == null) {
            this.clearLayout();
            return;
        }
        this.l = layout;
        this.setPreferredSize(new Dimension(this.l.width * this.z, this.l.height * this.z));
        int n = this.l.width * this.z + this.scroll_pane.getBorder().getBorderInsets((Component)this.scroll_pane).left + this.scroll_pane.getBorder().getBorderInsets((Component)this.scroll_pane).right;
        int n2 = this.l.height * this.z;
        this.scroll_pane.setPreferredSize(new Dimension(n, n2));
        this.frame.setTitle("Window: " + window.id + " - Layout: " + this.l.id);
        this.frame.pack();
        this.frame.setVisible(true);
        if (this.fu == null) {
            this.fu = new FrameUpdater(this, 5);
            this.fu.start();
        }
    }

    public void selectItem(Item item) {
        if (this.selected_item != null) {
            this.selected_item.setSelected(false);
        }
        if (item == null) {
            return;
        }
        this.selected_item = item;
        this.selected_item.setSelected(true);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.l == null) {
            return;
        }
        BufferedImage bufferedImage = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setColor(Color.LIGHT_GRAY);
        for (int i = 0; i < this.getWidth(); i += 20) {
            for (int j = 0; j < this.getHeight(); j += 20) {
                graphics2D.fillRect(i, j, 10, 10);
                graphics2D.fillRect(i + 10, j + 10, 10, 10);
            }
        }
        try {
            this.l.draw(graphics2D, this.z);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        graphics.drawImage(bufferedImage, 0, 0, this);
    }

    @Override
    public void update(Graphics graphics) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.zoom_less)) {
            if (this.z > 1) {
                --this.z;
            }
            this.zoom_label.setText(Language.get("ZOOM_FACTOR") + " " + this.z + "x");
            this.setSize(this.l.width * this.z, this.l.height * this.z);
            this.setPreferredSize(new Dimension(this.l.width * this.z, this.l.height * this.z));
        } else if (actionEvent.getSource().equals(this.zoom_more)) {
            if (this.z < 16) {
                ++this.z;
            }
            this.zoom_label.setText(Language.get("ZOOM_FACTOR") + " " + this.z + "x");
            this.setSize(this.l.width * this.z, this.l.height * this.z);
            this.setPreferredSize(new Dimension(this.l.width * this.z, this.l.height * this.z));
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selected_item == null) {
            return;
        }
        if (!this.starteddragging && this.selected_item.contains(mouseEvent.getX() / this.z, mouseEvent.getY() / this.z)) {
            this.dragstartx = mouseEvent.getX() / this.z;
            this.dragstarty = mouseEvent.getY() / this.z;
            this.ime = new ItemMoveEvent(this.selected_item);
            this.dragstartitemx = this.selected_item.x;
            this.dragstartitemy = this.selected_item.y;
            this.starteddragging = true;
        } else if (this.starteddragging) {
            this.selected_item.x = this.dragstartitemx + mouseEvent.getX() / this.z - this.dragstartx;
            this.selected_item.y = this.dragstartitemy + mouseEvent.getY() / this.z - this.dragstarty;
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.selected_item == null) {
            return;
        }
        if (this.selected_item.contains(mouseEvent.getX() / this.z, mouseEvent.getY() / this.z)) {
            this.selected_item.setHover(true);
            this.setCursor(new Cursor(13));
        } else {
            this.selected_item.setHover(false);
            this.setCursor(new Cursor(0));
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.fu.fps = 25;
        if (this.selected_item != null) {
            this.selected_item.setClicked(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.fu.fps = 5;
        if (this.starteddragging) {
            this.ime.setNew();
            this.m.hist.addEvent(this.ime);
            this.ime = null;
        }
        this.starteddragging = false;
        if (this.selected_item == null) {
            return;
        }
        this.selected_item.setClicked(false);
        this.dragstartx = this.selected_item.x + this.selected_item.offsetx;
        this.dragstarty = this.selected_item.y + this.selected_item.offsety;
        this.dragstartitemx = this.selected_item.x;
        this.dragstartitemy = this.selected_item.y;
    }

    public void moveItem(int n, int n2) {
        try {
            if (this.ime == null) {
                this.ime = new ItemMoveEvent(this.selected_item);
                this.m.hist.addEvent(this.ime);
            }
            this.selected_item.x += n;
            this.selected_item.y += n2;
            if (this.ime.getNext() == null) {
                this.ime.setNew();
            } else {
                this.ime = null;
            }
            this.repaint();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void savePNG(File file) {
        BufferedImage bufferedImage = new BufferedImage(this.l.width, this.l.height, 2);
        if (this.selected_item != null) {
            this.selected_item.setSelected(false);
        }
        this.l.draw(bufferedImage.createGraphics(), 1);
        if (this.selected_item != null) {
            this.selected_item.setSelected(true);
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.m, Language.get("ERROR_SAVEPNG_MSG") + "\n" + exception.toString(), Language.get("ERROR_SAVEPNG_TITLE"), 0);
            return;
        }
    }
}

