/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.common.adapters;

import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.exceptions.AdapterParameterDoesNotExistException;
import org.videolan.vlma.common.medias.IVlMedia;
import org.videolan.vlma.common.VlServer;

/**
 * External device of a server. All classes which define devices like DVB cards 
 * must implement this interface.
 * 
 * @see VlAdapter
 * @author SylV
 * @version 1.0
 * 
 */
public interface IVlAdapter {
    /**
     * Returns the device name.
     * 
     * @return the device name
     */
    public String getName();

    /**
     * Sets the device name.
     * 
     * @param name
     *            the new device name
     */
    public void setName(String name);

    /**
     * Sets the value of a device property. Properties depend on the device type.
     *
     * @param parameter
     *            the property name
     * @param value
     *            the property value
     * @param data
     *            the data interface
     * @throws AdapterParameterDoesNotExistException
     *             specified parameter is not appropriate
     */
    public void setParameter(String parameter, String value, IVlData data)
            throws AdapterParameterDoesNotExistException;

    /**
     * Returns the state of the device.
     * 
     * @return the state of the device (true if up, false otherwise)
     */
    public boolean isUp();

    /**
     * Sets the state of the device.
     * 
     * @param isUp
     *            the new device state
     */
    public void setUp(boolean isUp);

    /**
     * Returns the hashType of the adapter.
     * 
     * @return the adaptater hashType
     */
    public int hashType();

    /**
     * Indicates whether a media is readable.
     * 
     * @param media
     *            the media to test
     * @return the readability of the media
     */
    public boolean canRead(IVlMedia media);

    /**
     * Returns the device type. 
     *
     * @return the device type
     */
    public String getType();
    
    
    /**
     * Returns the server of this adapter.
     * 
     * @return VlServer the server
     */    
    public VlServer getServer();

    /**
     * Sets the server of this adapter.
     * 
     */    
    public void setServer(VlServer server);
}
