/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.common.programs;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;

/**
 * Basic implementation of IVlProgram which represents a programmation.
 * 
 * @author SylV
 */
public class VlProgram implements IVlProgram, Serializable {
    private Date liveStart;

    private int liveInterval;

    private int liveLength;

    private int liveRepetitions;

    private int priority;

    private String sapName;

    private InetAddress player;

    private InetAddress ip;

    private String sapGroup;
    
    private boolean broadcastState;

    /**
     * Gets the SAP group.
     * 
     * @return the sap group
     */
    public String getSapGroup() {
        return sapGroup;
    }

    /**
     * Sets the SAP group.
     * 
     * @param sapGroup
     *            the SAP group to set
     */
    public void setSapGroup(String sapGroup) {
        this.sapGroup = sapGroup;
    }

    public InetAddress getIp() {
        return ip;
    }

    public void setIp(InetAddress ip) {
        this.ip = ip;
    }

    public int getLiveInterval() {
        return liveInterval;
    }

    public void setLiveInterval(int liveInterval) {
        this.liveInterval = liveInterval;
    }

    public int getLiveLength() {
        return liveLength;
    }

    public void setLiveLength(int liveLength) {
        this.liveLength = liveLength;
    }

    public int getLiveRepetitions() {
        return liveRepetitions;
    }

    public void setLiveRepetitions(int liveRepetitions) {
        this.liveRepetitions = liveRepetitions;
    }

    public Date getLiveStart() {
        return liveStart;
    }

    public void setLiveStart(Date liveStart) {
        this.liveStart = liveStart;
    }

    public VlProgram() {
        setLiveInterval(-1);
        setLiveRepetitions(1);
        setLiveLength(-1);
        liveStart = new Date();
        setIp(null);
        setPriority(50);
        setPlayer(null);
    }

    public int getPriority() {
        return priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isTimeToPlay() {
        long now = System.currentTimeMillis();
        long when = getLiveStart().getTime();
        if (getLiveInterval() > 0) {
            return (now >= when)
                    && ((now - when) % getLiveInterval() < getLiveLength());
        } else {
            return (now >= when);
        }
    }

    public InetAddress getPlayer() {
        return player;
    }
    
    public String getPlayerHostName()
    {
        return player.getHostName();
    }

    public void setPlayer(InetAddress player) {
        this.player = player;
    }

    public String getSapName() {
        return sapName;
    }

    public void setSapName(String sapName) {
        this.sapName = sapName;
    }

    public void setBroadcastState(boolean broadcastStateGiven) {
        broadcastState = broadcastStateGiven;
    }
    
    public boolean getBroadcastState() {
        return broadcastState;
    }

}
