/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.daemon;

import jargs.gnu.CmdLineParser;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This function contains the boot process of VLMA software.
 */
public class VLMad {
    private static final Logger logger = Logger.getLogger(VLMad.class);

    static VlData data;

    public static void main(String[] args) {
        // parsing of cmdline

        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option springxml = parser.addStringOption("springxml");
        CmdLineParser.Option IPsDevel = parser.addBooleanOption("IPsDevel");

        try {
            parser.parse(args);
        } catch (CmdLineParser.OptionException e) {
            logger.log(Level.ERROR, "Erreur dans la ligne de commande : " + e.getMessage());
            logger.log(Level.INFO, "Usage: VLMad [{--springxml} daemon.xml]\n");
            System.exit(2);
        }

        String springxmlvalue = (String) parser.getOptionValue(springxml);
        if (springxmlvalue == null) {
            springxmlvalue = "daemon.xml";
        }

        boolean IPsDevelvalue;
        if (parser.getOptionValue(IPsDevel) != null) {
            IPsDevelvalue = true;
        } else {
            IPsDevelvalue = false;
        }

        // Lancement de l'application serveur
        logger.log(Level.DEBUG, "Début de l'application");
        logger.log(Level.DEBUG, "Chargement de l'application Spring à partir du fichier de config XML : " + springxmlvalue);
        ApplicationContext ac = new ClassPathXmlApplicationContext(springxmlvalue);
        data = (VlData) ac.getBean("dataSource");
        data.initIPs(IPsDevelvalue);
        logger.log(Level.DEBUG, "Lancement du thread de surveillance des serveurs");
        data.startServerMonitoringDaemon();
        logger.log(Level.DEBUG, "Lancement du thread de surveillance de la diffusion");
        data.startOrderMonitoringDaemon();
    }
}
