/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 * 
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.web.servers;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.servlet.view.RedirectView;
import org.videolan.vlma.common.IVlData;
import org.videolan.vlma.common.VlServer;


public class ServersRemoveFormController extends SimpleFormController {

    private IVlData data;

    public IVlData getData() {
        return data;
    }

    public void setData(IVlData data) {
        this.data = data;
    }

    public ModelAndView onSubmit(Object command) throws ServletException,
            UnknownHostException
    {
        int server = ((ServersAdd) command).getId();
        data.removeServer(server);
        return new ModelAndView(new RedirectView(getSuccessView()));
    }

    protected Object formBackingObject(HttpServletRequest request)
            throws ServletException
    {
        ServersAdd serversAdd = new ServersAdd();
        int Id = Integer.parseInt(request.getParameter("server"));
        serversAdd.setId(Id);
        serversAdd.setName(data.getServer(Id).getName());
        serversAdd.setData(data);
        return serversAdd;
    }

    @Override
    protected ModelAndView showForm(HttpServletRequest arg0,
            HttpServletResponse arg1, BindException arg2, Map arg3)
            throws Exception
    {
        Map<String, Object> m = new HashMap<String, Object>();
        int Id = Integer.parseInt(arg0.getParameter("server"));
        VlServer server = (VlServer)data.getServer(Id);
        m.put("server", server);
        return super.showForm(arg0, arg1, arg2, m);
    }

}
