
<%@ include file="/WEB-INF/jsp/include.jsp" %>

<h1><fmt:message key="files.list" /></h1>


<table width="100%">
    <tr>
        <th><fmt:message key="medias.list.name" /></th>
        <th><fmt:message key="medias.list.server" /></th>
        <th><fmt:message key="medias.list.status" /></th>
        <th><fmt:message key="medias.list.action" /></th>
    </tr>

    <c:forEach items="${filesChannels}" var="filesChannel">
    <tr>
        <td>
            <strong>
                <a name="<c:out value="${filesChannel.id}" />">
                    <c:out value="${filesChannel.name}" />
                </a>    
            </strong>
        </td>
        <td>
            <c:out value="${filesChannel.server.name}"/>
        </td>
        <!-- Construction de l'URL pour supprimer la chane  de la liste -->
        <c:url value="tntchannelremove.htm" var="tntChannelRemoveUrl">
            <c:param name="Id" value="${filesChannel.id}" />
        </c:url>
        <!-- Construction of the URL to delete the channel -->
        <c:url value="fileschannelsedit.htm" var="filesChannelEditUrl">
            <c:param name="Id" value="${filesChannel.id}" />
        </c:url>
        <c:choose>
            <c:when test="${filesChannel.program == null}">
                <td><fmt:message key="medias.list.status.non-programmed" /></td>
                <c:url value="mediasprogramadd.htm" var="programAddUrl">
                <c:param name="media" value="${filesChannel.id}" />
                </c:url>
                <td>
                    <p class="lien"><a href="${programAddUrl}"><fmt:message key="medias.list.action.run" /></a></p>
                    <p class="lien"><a href="${tntChannelRemoveUrl}"><fmt:message key="medias.list.action.removechannel" /></a></p>
                    <p class="lien"><a href="${filesChannelEditUrl}"><fmt:message key="medias.list.action.edit-files-channel" /></a></p>
                </td>
            </c:when>
            <c:otherwise>
                <td>
                <c:choose>
                    <c:when test="${filesChannel.program.player == null}">
                        <fmt:message key="medias.list.status.programmed-nonrunning">
                            <fmt:param value="${filesChannel.program.priority}" />
                        </fmt:message>
                    </c:when>
                    <c:otherwise>
                        <c:choose>
                            <c:when test="${filesChannel.program.broadcastState}">
                                <fmt:message key="medias.list.status.programmed-running">
                                    <fmt:param value="${filesChannel.program.priority}" />
                                    <fmt:param value="${filesChannel.program.playerHostName}" />
                                </fmt:message>
                            </c:when>
                            <c:otherwise>
                                <fmt:message key="medias.list.status.programmed-assigned">
                                    <fmt:param value="${filesChannel.program.priority}" />
                                    <fmt:param value="${filesChannel.program.playerHostName}" />
                                </fmt:message>
                            </c:otherwise>
                        </c:choose>
                    </c:otherwise>
                </c:choose>
                </td>
                <c:url value="mediasprogramremove.htm" var="programRemoveUrl">
                    <c:param name="media" value="${filesChannel.id}" />
                </c:url>
                <td><a href="${programRemoveUrl}"><fmt:message key="medias.list.action.stop" /></a></td>            
            </c:otherwise>
        </c:choose>
    </tr>
    </c:forEach>
</table>


