/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdOpener;
import org.jrobin.core.Util;
import org.jrobin.graph.Cdef;
import org.jrobin.graph.Def;
import org.jrobin.graph.ExportData;
import org.jrobin.graph.FetchSource;
import org.jrobin.graph.FetchSourceList;
import org.jrobin.graph.Pdef;
import org.jrobin.graph.RpnCalculator;
import org.jrobin.graph.RrdExportDef;
import org.jrobin.graph.Sdef;
import org.jrobin.graph.Source;
import org.jrobin.graph.ValueExtractor;

class RrdExporter {
    private RrdExportDef def;
    private RrdOpener rrdOpener;
    protected int numRows;
    protected int reducedNumRows;
    protected long startTime;
    protected long endTime;
    protected long reducedStartTime;
    protected long reducedEndTime;
    protected long reducedStep;
    protected long[] timestamps;
    protected Source[] sources;
    protected HashMap sourceIndex;

    RrdExporter(RrdExportDef rrdExportDef) {
        this.setRrdOpener(new RrdOpener(false, true));
        this.setExportDef(rrdExportDef);
    }

    RrdExporter(RrdExportDef rrdExportDef, RrdOpener rrdOpener) {
        this.setRrdOpener(rrdOpener);
        this.setExportDef(rrdExportDef);
    }

    void setExportDef(RrdExportDef rrdExportDef) {
        this.def = rrdExportDef;
    }

    void setRrdOpener(RrdOpener rrdOpener) {
        this.rrdOpener = rrdOpener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateSeries(int n) throws RrdException, IOException {
        long l;
        long l2;
        int n2;
        int n3;
        int n4;
        Source[] sourceArray;
        int[] nArray;
        Object[] objectArray;
        int n5;
        FetchSourceList fetchSourceList = this.def.getFetchSources();
        fetchSourceList.setRrdOpener(this.rrdOpener);
        long l3 = Long.MAX_VALUE;
        boolean bl = false;
        long l4 = this.def.getStartTime();
        long l5 = this.def.getEndTime();
        bl = l5 == 0L;
        this.numRows = n;
        this.reducedNumRows = n;
        int n6 = this.def.getNumDefs();
        int n7 = this.def.getNumSdefs();
        Cdef[] cdefArray = this.def.getCdefs();
        int n8 = cdefArray.length;
        Pdef[] pdefArray = this.def.getPdefs();
        int n9 = pdefArray.length;
        ExportData[] exportDataArray = this.def.getExportData();
        if (exportDataArray.length > 0) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(30);
            ArrayList<Source> arrayList2 = new ArrayList<Source>(30);
            for (n5 = 0; n5 < exportDataArray.length; ++n5) {
                objectArray = exportDataArray[n5].getSources();
                for (int i = 0; i < objectArray.length; ++i) {
                    arrayList2.add(objectArray[i]);
                    arrayList.add(new Integer(n5));
                }
            }
            nArray = new int[arrayList.size()];
            for (n5 = 0; n5 < nArray.length; ++n5) {
                nArray[n5] = (Integer)arrayList.get(n5);
            }
            sourceArray = arrayList2.toArray(new Source[0]);
        } else {
            nArray = new int[]{};
            sourceArray = new Source[]{};
        }
        int n10 = sourceArray.length;
        this.sources = new Source[n6 + n10 + n8 + n9];
        this.sourceIndex = new HashMap(n6 + n10 + n8 + n9);
        int n11 = 0;
        n5 = 0;
        objectArray = new ValueExtractor[fetchSourceList.size()];
        long l6 = (l5 - l4) / (long)n;
        if (l6 <= 0L) {
            l6 = 1L;
        }
        int n12 = 1;
        long l7 = Integer.MAX_VALUE;
        long l8 = Integer.MIN_VALUE;
        if (fetchSourceList.size() > 0 || n10 > 0) {
            try {
                FetchSource fetchSource;
                fetchSourceList.openAll();
                for (n4 = 0; n4 < fetchSourceList.size(); ++n4) {
                    fetchSource = fetchSourceList.get(n4);
                    if (bl) {
                        if ((l5 = fetchSource.getLastSampleTime(l4, l5, this.def.getResolution())) < l3) {
                            l3 = l5;
                        }
                        if ((l6 = (l5 - l4) / (long)n) <= 0L) {
                            l6 = 1L;
                        }
                    }
                    long[] lArray = fetchSource.getFetchStep(l4, l5, this.def.getResolution());
                    n3 = (int)Math.ceil((double)l6 / (double)lArray[0]);
                    lArray[0] = lArray[0] * (long)n3;
                    if (lArray[0] < l7) {
                        l7 = lArray[0];
                        n12 = n3;
                    }
                    if (lArray[1] <= l8) continue;
                    l8 = lArray[1];
                }
                for (n4 = 0; n4 < exportDataArray.length; ++n4) {
                    long l9 = exportDataArray[n4].getStep();
                    if ((l9 *= (long)(n2 = (int)Math.ceil((double)l6 / (double)l9))) < l7) {
                        l7 = l9;
                        n12 = n2;
                    }
                    if (l9 <= l8) continue;
                    l8 = l9;
                }
                l2 = Util.normalize(l4, l7);
                long l10 = l2 = l2 > l4 ? l2 - l7 : l2;
                l = !bl ? ((l = Util.normalize(l5, l7)) < l5 ? l + l7 : l) : ((l = Util.normalize(l3, l7)) < l3 ? l + l7 : l);
                this.reducedEndTime = l;
                this.reducedStartTime = l2;
                this.reducedStep = l7;
                this.reducedNumRows = (int)((this.reducedEndTime - this.reducedStartTime) / this.reducedStep) + 1;
                long l11 = Util.normalize(l, l8);
                l11 = l11 < l ? l + l8 : l11;
                l = Util.normalize(l11, l7);
                l = l < l11 ? l + l7 : l;
                this.numRows = (int)((l - l2) / l7) + 1;
                for (n4 = 0; n4 < fetchSourceList.size(); ++n4) {
                    fetchSource = fetchSourceList.get(n4);
                    ValueExtractor valueExtractor = fetchSource.fetch(l2, l, this.def.getResolution(), n12);
                    String[] stringArray = valueExtractor.getNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.sources[n11] = new Def(stringArray[i], this.numRows, this.reducedNumRows);
                        this.sourceIndex.put(stringArray[i], new Integer(n11++));
                    }
                    objectArray[n5++] = valueExtractor;
                }
            }
            finally {
                fetchSourceList.releaseAll();
            }
        } else {
            l7 = l6;
            l2 = Util.normalize(l4, l7);
            long l12 = l2 = l2 > l4 ? l2 - l7 : l2;
            l = !bl ? ((l = Util.normalize(l5, l7)) < l5 ? l + l7 : l) : ((l = Util.normalize(Util.getTime(), l7)) < l5 ? l + l7 : l);
            this.reducedEndTime = l;
            this.reducedStartTime = l2;
            this.reducedStep = l7;
            this.reducedNumRows = (int)((this.reducedEndTime - this.reducedStartTime) / this.reducedStep) + 1;
            l3 = l5;
            l += l7;
            this.numRows = this.reducedNumRows;
        }
        for (n4 = 0; n4 < sourceArray.length; ++n4) {
            this.sources[n11] = new Def(sourceArray[n4].getName(), this.numRows, this.reducedNumRows);
            this.sources[n11].setFetchedStep(sourceArray[n4].getStep());
            this.sourceIndex.put(sourceArray[n4].getName(), new Integer(n11++));
        }
        for (n4 = 0; n4 < pdefArray.length; ++n4) {
            pdefArray[n4].prepare(this.numRows, this.reducedNumRows);
            pdefArray[n4].setFetchedStep(l7);
            this.sources[n11] = pdefArray[n4];
            this.sourceIndex.put(pdefArray[n4].getName(), new Integer(n11++));
        }
        n4 = n11;
        for (int i = 0; i < cdefArray.length; ++i) {
            cdefArray[i].prepare(this.sourceIndex, this.numRows, this.reducedNumRows);
            cdefArray[i].setFetchedStep(l7);
            this.sources[n11] = cdefArray[i];
            this.sourceIndex.put(cdefArray[i].getName(), new Integer(n11++));
        }
        this.timestamps = new long[this.numRows];
        RpnCalculator rpnCalculator = new RpnCalculator(this.sources, l7);
        n3 = 0;
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            n3 = ((ValueExtractor)objectArray[n2]).prepareSources(this.sources, n3);
        }
        if (n7 > 0) {
            n2 = 0;
            int[] nArray2 = new int[this.sources.length];
            for (int i = n4; i < this.sources.length; ++i) {
                int n13 = ((Cdef)this.sources[i]).calculateLevel(nArray2);
                n2 = n13 > n2 ? n13 : n2;
                nArray2[i] = n13;
            }
            for (int i = 0; i <= n2; ++i) {
                long l13 = l2 - l7;
                for (int j = 0; j < this.numRows; ++j) {
                    int n14;
                    n3 = n4;
                    if (i == 0) {
                        n3 = 0;
                        l13 += l7;
                        for (n14 = 0; n14 < objectArray.length; ++n14) {
                            n3 = ((ValueExtractor)objectArray[n14]).extract(l13, this.sources, j, n3);
                        }
                        for (n14 = n3; n14 < n3 + n10; ++n14) {
                            this.sources[n14].set(j, l13, sourceArray[n14 - n3].get(l13, exportDataArray[nArray[n14 - n3]].getTimestamps()));
                        }
                        for (n14 = n3 += n10; n14 < n3 + n9; ++n14) {
                            ((Pdef)this.sources[n14]).set(j, l13);
                        }
                        n3 += n9;
                        this.timestamps[j] = l13;
                    } else {
                        l13 = this.timestamps[j];
                    }
                    for (n14 = n3; n14 < this.sources.length; ++n14) {
                        if (nArray2[n14] != i) continue;
                        if (this.sources[n14] instanceof Sdef) {
                            ((Sdef)this.sources[n14]).set(this.sources);
                            continue;
                        }
                        this.sources[n14].set(j, l13, rpnCalculator.evaluate((Cdef)this.sources[n14], j, l13));
                    }
                }
            }
        } else {
            long l14 = l2 - l7;
            for (int i = 0; i < this.numRows; ++i) {
                int n15;
                l14 += l7;
                n3 = 0;
                for (n15 = 0; n15 < objectArray.length; ++n15) {
                    n3 = ((ValueExtractor)objectArray[n15]).extract(l14, this.sources, i, n3);
                }
                for (n15 = n3; n15 < n3 + n10; ++n15) {
                    this.sources[n15].set(i, l14, sourceArray[n15 - n3].get(l14, exportDataArray[nArray[n15 - n3]].getTimestamps()));
                }
                for (n15 = n3 += n10; n15 < n3 + n9; ++n15) {
                    ((Pdef)this.sources[n15]).set(i, l14);
                }
                for (n15 = n3 += n9; n15 < this.sources.length; ++n15) {
                    this.sources[n15].set(i, l14, rpnCalculator.evaluate((Cdef)this.sources[n15], i, l14));
                }
                this.timestamps[i] = l14;
            }
        }
        objectArray = null;
        this.startTime = l4;
        this.endTime = bl ? l3 : l5;
    }

    private Source getSource(String string) throws RrdException {
        if (!this.sourceIndex.containsKey(string)) {
            throw new RrdException("No such datasource: " + string);
        }
        return this.sources[(Integer)this.sourceIndex.get(string)];
    }

    protected ExportData createExportData() throws RrdException {
        int n;
        Source[] sourceArray;
        if (this.sources == null) {
            throw new RrdException("Sources not calculated, no data to return.");
        }
        String[][] stringArray = this.def.getExportDatasources();
        HashMap<String, String> hashMap = new HashMap<String, String>(stringArray.length);
        if (this.def.isStrict()) {
            sourceArray = new Def[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                sourceArray[n] = this.createReducedDef(this.getSource(stringArray[n][0]));
            }
        } else {
            sourceArray = new Def[this.sources.length];
            for (n = 0; n < this.sources.length; ++n) {
                sourceArray[n] = this.createReducedDef(this.sources[n]);
                hashMap.put(sourceArray[n].getName(), sourceArray[n].getName());
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            hashMap.put(stringArray[n][0], stringArray[n][1]);
        }
        long[] lArray = new long[this.reducedNumRows];
        System.arraycopy(this.timestamps, 0, lArray, 0, this.reducedNumRows);
        return new ExportData(lArray, sourceArray, hashMap);
    }

    private Def createReducedDef(Source source) {
        Def def = new Def(source.getName(), this.reducedNumRows, this.reducedNumRows);
        def.setFetchedStep(this.reducedStep);
        for (int i = 0; i < this.reducedNumRows; ++i) {
            def.set(i, this.timestamps[i], source.get(i));
        }
        return def;
    }

    protected synchronized ExportData fetch(int n) throws RrdException, IOException {
        this.calculateSeries(n);
        return this.createExportData();
    }

    public RrdExportDef getExportDef() {
        return this.def;
    }

    public RrdOpener getRrdOpener() {
        return this.rrdOpener;
    }
}

