/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.jemNets;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.jemNets.Visitor;
import com.sun.electric.tool.ncc.processing.HierarchyInfo;
import java.util.ArrayList;

public class NccNetlist {
    private final NccGlobals globals;
    private final Cell rootCell;
    private ArrayList wires;
    private ArrayList parts;
    private ArrayList ports;

    public NccNetlist(Cell root, VarContext context, Netlist netlist, HierarchyInfo hierInfo, NccGlobals globals) {
        this.globals = globals;
        this.rootCell = root;
        Visitor v = new Visitor(globals, hierInfo);
        HierarchyEnumerator.enumerateCell(root, context, netlist, v);
        this.wires = v.getWireList();
        this.parts = v.getPartList();
        this.ports = v.getPortList();
    }

    public ArrayList getWireArray() {
        return this.wires;
    }

    public ArrayList getPartArray() {
        return this.parts;
    }

    public ArrayList getPortArray() {
        return this.ports;
    }

    public Cell getRootCell() {
        return this.rootCell;
    }
}

