/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.io.output.Topology;
import java.util.HashMap;
import java.util.Iterator;

public class MOSSIM
extends Topology {
    public static final Variable.Key MOSSIM_STRENGTH_KEY = ElectricObject.newKey("SIM_mossim_strength");

    public static void writeMOSSIMFile(Cell cell, VarContext context, String filePath) {
        MOSSIM out = new MOSSIM();
        if (out.openTextOutputStream(filePath)) {
            return;
        }
        if (out.writeCell(cell, context)) {
            return;
        }
        if (out.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
    }

    MOSSIM() {
    }

    protected void start() {
    }

    protected void done() {
    }

    protected void writeCellTopology(Cell cell, Topology.CellNetInfo cni, VarContext context) {
        boolean inst = true;
        if (cell == this.topCell) {
            this.printWriter.println("| Top-level cell " + cell.describe() + " ;");
            this.printWriter.println("i VDD ;");
            this.printWriter.println("i GND ;");
        } else {
            this.printWriter.println("| Cell " + cell.describe() + " ;");
            this.printWriter.print("c " + cell.getName());
            Iterator it = cni.getCellSignals();
            while (it.hasNext()) {
                Topology.CellSignal cs = (Topology.CellSignal)it.next();
                if (!cs.isExported()) continue;
                this.printWriter.print(" " + cs.getName());
            }
            this.printWriter.println(" ;");
        }
        Netlist netList = cni.getNetList();
        HashMap<Network, String> strengthMap = new HashMap<Network, String>();
        Iterator it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            Variable var = ai.getVar(MOSSIM_STRENGTH_KEY);
            if (var == null) continue;
            Network net = netList.getNetwork(ai, 0);
            strengthMap.put(net, var.getPureValue(-1));
        }
        it = cni.getCellSignals();
        while (it.hasNext()) {
            Topology.CellSignal cs = (Topology.CellSignal)it.next();
            if (cs.isPower()) {
                if (cs.getName().equalsIgnoreCase("vdd")) continue;
                this.printWriter.println("e VDD " + cs.getName() + " ;");
                continue;
            }
            if (cs.isGround()) {
                if (cs.getName().equalsIgnoreCase("gnd")) continue;
                this.printWriter.println("e GND " + cs.getName() + " ;");
                continue;
            }
            if (cs.isExported()) {
                if (cell != this.topCell) continue;
                Export e = cs.getExport();
                if (e.getCharacteristic() == PortCharacteristic.IN) {
                    this.printWriter.println("i " + cs.getName() + " ;");
                    continue;
                }
                this.printWriter.println("s 1 " + cs.getName() + " ;");
                continue;
            }
            String strength = (String)strengthMap.get(cs.getNetwork());
            if (strength == null) {
                strength = "1";
            }
            this.printWriter.println("s " + strength + " " + cs.getName());
        }
        Iterator nIt = netList.getNodables();
        while (nIt.hasNext()) {
            Topology.CellSignal cs;
            Nodable no = (Nodable)nIt.next();
            NodeProto subnp = no.getProto();
            if (subnp instanceof Cell) {
                String nodeName = this.parameterizedName(no, context);
                StringBuffer infstr = new StringBuffer();
                infstr.append("h " + nodeName + " " + no.getName());
                Topology.CellNetInfo subCni = this.getCellNetInfo(nodeName);
                Iterator sIt = subCni.getCellSignals();
                while (sIt.hasNext()) {
                    Topology.CellSignal subCs = (Topology.CellSignal)sIt.next();
                    if (!subCs.isExported()) continue;
                    Export pp = subCs.getExport();
                    Network net = netList.getNetwork(no, pp, subCs.getExportIndex());
                    cs = cni.getCellSignal(net);
                    infstr.append(" " + cs.getName());
                }
                infstr.append(" ;");
                this.printWriter.println(infstr.toString());
                continue;
            }
            NodeInst ni = (NodeInst)no;
            PrimitiveNode.Function type = ni.getFunction();
            if (type != PrimitiveNode.Function.TRANMOS && type != PrimitiveNode.Function.TRADMOS && type != PrimitiveNode.Function.TRAPMOS) continue;
            PortInst gate = ni.getTransistorGatePort();
            PortInst source = ni.getTransistorSourcePort();
            PortInst drain = ni.getTransistorDrainPort();
            StringBuffer infstr = new StringBuffer();
            if (type == PrimitiveNode.Function.TRANMOS) {
                infstr.append("n");
            } else if (type == PrimitiveNode.Function.TRAPMOS) {
                infstr.append("p");
            } else if (type == PrimitiveNode.Function.TRADMOS) {
                infstr.append("d");
            }
            Variable var = ni.getVar(MOSSIM_STRENGTH_KEY);
            if (var != null) {
                infstr.append(" " + var.getPureValue(-1));
            } else {
                infstr.append(" 2");
            }
            cs = cni.getCellSignal(netList.getNetwork(gate));
            if (cs == null) {
                System.out.println("CELL " + ni.getParent().describe() + " CANNOT DETERMINE GATE NETWORK ON NODE " + ni.describe());
            }
            infstr.append(" " + cs.getName());
            cs = cni.getCellSignal(netList.getNetwork(source));
            if (cs == null) {
                System.out.println("CELL " + ni.getParent().describe() + " CANNOT DETERMINE SOURCE NETWORK ON NODE " + ni.describe());
            }
            infstr.append(" " + cs.getName());
            cs = cni.getCellSignal(netList.getNetwork(drain));
            if (cs == null) {
                System.out.println("CELL " + ni.getParent().describe() + " CANNOT DETERMINE DRAIN NETWORK ON NODE " + ni.describe());
            }
            infstr.append(" " + cs.getName());
            infstr.append(" ;   | " + ni.getName() + ";");
            this.printWriter.println(infstr.toString());
        }
        this.printWriter.println(".");
    }

    protected String getSafeCellName(String name) {
        return name;
    }

    protected String getPowerName(Network net) {
        return "VDD";
    }

    protected String getGroundName(Network net) {
        return "GND";
    }

    protected String getGlobalName(Global glob) {
        return glob.getName();
    }

    protected boolean isNetworksUseExportedNames() {
        return true;
    }

    protected boolean isLibraryNameAlwaysAddedToCellName() {
        return false;
    }

    protected boolean isAggregateNamesSupported() {
        return false;
    }

    protected String getSafeNetName(String name) {
        return name;
    }

    protected Netlist getNetlistForCell(Cell cell) {
        boolean shortResistors = true;
        Netlist netList = cell.getNetlist(shortResistors);
        return netList;
    }

    protected boolean canParameterizeNames() {
        return true;
    }
}

