/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PixelDrawing {
    public static final int MINIMUMTEXTSIZE = 5;
    private static final boolean TAKE_STATS = false;
    private static int tinyCells;
    private static int tinyPrims;
    private static int totalCells;
    private static int totalPrims;
    private static int tinyArcs;
    private static int totalArcs;
    private static int offscreensCreated;
    private static int offscreensUsed;
    private EditWindow wnd;
    private Dimension sz;
    private Rectangle2D drawBounds;
    private BufferedImage img;
    private int[] opaqueData;
    private int total;
    private int backgroundColor;
    private int backgroundValue;
    private byte[][][] layerBitMaps;
    private byte[][] compositeRows;
    private int numLayerBitMaps;
    private int numBytesPerRow;
    private int numLayerBitMapsCreated;
    private Technology curTech;
    private HashMap patternedOpaqueLayers;
    private boolean renderedWindow;
    private boolean periodicRefresh;
    private int objectCount;
    private long lastRefreshTime;
    private static Dimension topSz;
    private static Technology techWithLayers;
    private static HashMap expandedCells;
    private static double expandedScale;
    private static TextDescriptor noCellTextDescriptor;
    private static final Rectangle2D CENTERRECT;
    private static EGraphics blackGraphics;
    private static EGraphics portGraphics;
    private static final boolean DEBUGRENDERTIMING = false;
    private static long renderTextTime;
    private static long renderPolyTime;
    private float[] hsbTempArray = new float[3];
    private boolean[] arcOctTable = new boolean[9];
    private Point arcCenter;
    private int arcRadius;
    private int arcCol;
    private byte[][] arcLayerBitMap;
    private boolean arcThick;

    public PixelDrawing(EditWindow wnd) {
        this.wnd = wnd;
        this.sz = wnd.getScreenSize();
        this.img = new BufferedImage(this.sz.width, this.sz.height, 1);
        WritableRaster raster = this.img.getRaster();
        DataBufferInt dbi = (DataBufferInt)raster.getDataBuffer();
        this.opaqueData = dbi.getData();
        this.total = this.sz.height * this.sz.width;
        this.numBytesPerRow = (this.sz.width + 7) / 8;
        this.backgroundColor = User.getColorBackground() & 0xFFFFFF;
        this.backgroundValue = this.backgroundColor | 0xFF000000;
        this.patternedOpaqueLayers = new HashMap();
        this.renderedWindow = true;
        this.curTech = null;
        this.initForTechnology();
        this.clearImage(false);
    }

    public void setBackgroundColor(Color bg) {
        this.backgroundColor = bg.getRGB() & 0xFFFFFF;
    }

    protected BufferedImage getBufferedImage() {
        return this.img;
    }

    public static void clearSubCellCache() {
        expandedCells = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawImage(Rectangle2D expandBounds) {
        Cell cell = this.wnd.getCell();
        if (this.wnd.isInPlaceEdit()) {
            cell = this.wnd.getInPlaceEditTopCell();
        }
        this.drawBounds = this.wnd.getDisplayedBounds();
        long startTime = 0L;
        if (expandedScale != this.wnd.getScale()) {
            expandedCells = new HashMap();
            expandedScale = this.wnd.getScale();
        }
        topSz = this.sz;
        this.clearImage(true);
        if (cell == null) {
            if (noCellTextDescriptor == null) {
                noCellTextDescriptor = new TextDescriptor(null);
                noCellTextDescriptor.setAbsSize(18);
                noCellTextDescriptor.setBold(true);
            }
            Rectangle rect = new Rectangle(this.sz);
            blackGraphics.setColor(new Color(User.getColorText()));
            this.drawText(rect, Poly.Type.TEXTBOX, noCellTextDescriptor, "No cell in this window", null, blackGraphics, false);
        } else {
            this.countCell(cell, expandBounds, DBMath.MATID);
            this.drawCell(cell, expandBounds, DBMath.MATID, true);
        }
        BufferedImage bufferedImage = this.img;
        synchronized (bufferedImage) {
            this.composite();
        }
    }

    public void clearImage(boolean periodicRefresh) {
        this.initForTechnology();
        for (int i = 0; i < this.numLayerBitMaps; ++i) {
            byte[][] layerBitMap = this.layerBitMaps[i];
            if (layerBitMap == null) continue;
            for (int y = 0; y < this.sz.height; ++y) {
                byte[] row = layerBitMap[y];
                for (int x = 0; x < this.numBytesPerRow; ++x) {
                    row[x] = 0;
                }
            }
        }
        Iterator it = this.patternedOpaqueLayers.entrySet().iterator();
        while (it.hasNext()) {
            PatternedOpaqueLayer pol = (PatternedOpaqueLayer)((Object)it.next());
            byte[][] layerBitMap = pol.bitMap;
            for (int y = 0; y < this.sz.height; ++y) {
                byte[] row = layerBitMap[y];
                for (int x = 0; x < this.numBytesPerRow; ++x) {
                    row[x] = 0;
                }
            }
        }
        for (int i = 0; i < this.total; ++i) {
            this.opaqueData[i] = this.backgroundValue;
        }
        this.periodicRefresh = periodicRefresh;
        if (periodicRefresh) {
            this.objectCount = 0;
            this.lastRefreshTime = System.currentTimeMillis();
        }
    }

    public Image composite() {
        if (this.numLayerBitMapsCreated > 0) {
            Color[] colorMap = this.curTech.getColorMap();
            boolean dimmedTransparentLayers = false;
            Iterator it = this.curTech.getLayers();
            while (it.hasNext()) {
                Layer layer = (Layer)it.next();
                if (!layer.isDimmed() || layer.getGraphics().getTransparentLayer() == 0) continue;
                dimmedTransparentLayers = true;
                break;
            }
            if (dimmedTransparentLayers) {
                Color[] newColorMap = new Color[colorMap.length];
                int numTransparents = this.curTech.getNumTransparentLayers();
                boolean[] dimLayer = new boolean[numTransparents];
                for (int i = 0; i < numTransparents; ++i) {
                    dimLayer[i] = true;
                }
                Iterator it2 = this.curTech.getLayers();
                while (it2.hasNext()) {
                    int tIndex;
                    Layer layer = (Layer)it2.next();
                    if (layer.isDimmed() || (tIndex = layer.getGraphics().getTransparentLayer()) == 0) continue;
                    dimLayer[tIndex - 1] = false;
                }
                for (int i = 0; i < colorMap.length; ++i) {
                    newColorMap[i] = colorMap[i];
                    if (i == 0) continue;
                    boolean dimThisEntry = true;
                    for (int j = 0; j < numTransparents; ++j) {
                        if ((i & 1 << j) == 0 || dimLayer[j]) continue;
                        dimThisEntry = false;
                        break;
                    }
                    if (!dimThisEntry) continue;
                    newColorMap[i] = new Color(this.dimColor(colorMap[i].getRGB()));
                }
                colorMap = newColorMap;
            }
            for (int y = 0; y < this.sz.height; ++y) {
                for (int i = 0; i < this.numLayerBitMaps; ++i) {
                    byte[][] layerBitMap = this.layerBitMaps[i];
                    this.compositeRows[i] = (byte[])(layerBitMap == null ? null : layerBitMap[y]);
                }
                int baseIndex = y * this.sz.width;
                for (int x = 0; x < this.sz.width; ++x) {
                    int index = baseIndex + x;
                    int pixelValue = this.opaqueData[index];
                    int alpha = pixelValue >> 24 & 0xFF;
                    if (alpha == 0) continue;
                    int bits = 0;
                    int entry = x >> 3;
                    int maskBit = 1 << (x & 7);
                    for (int i = 0; i < this.numLayerBitMaps; ++i) {
                        byte byt;
                        if (this.compositeRows[i] == null || ((byt = this.compositeRows[i][entry]) & maskBit) == 0) continue;
                        bits |= 1 << i;
                    }
                    int newColor = this.backgroundColor;
                    if (bits != 0) {
                        newColor = colorMap[bits].getRGB() & 0xFFFFFF;
                    }
                    if (alpha != 255) {
                        newColor = this.alphaBlend(pixelValue, newColor, alpha);
                    }
                    this.opaqueData[index] = newColor;
                }
            }
        } else {
            for (int i = 0; i < this.total; ++i) {
                int pixelValue = this.opaqueData[i];
                if (pixelValue == this.backgroundValue) {
                    this.opaqueData[i] = this.backgroundColor;
                    continue;
                }
                if ((pixelValue & 0xFF000000) == 0) continue;
                int alpha = pixelValue >> 24 & 0xFF;
                this.opaqueData[i] = this.alphaBlend(pixelValue, this.backgroundColor, alpha);
            }
        }
        return this.img;
    }

    private void initForTechnology() {
        Technology tech = Technology.getCurrent();
        if (tech == null) {
            return;
        }
        if (tech == this.curTech) {
            return;
        }
        int transLayers = tech.getNumTransparentLayers();
        if (transLayers != 0) {
            techWithLayers = this.curTech = tech;
        }
        if (this.curTech == null) {
            this.curTech = techWithLayers;
        }
        if (this.curTech == null) {
            return;
        }
        this.numLayerBitMaps = this.curTech.getNumTransparentLayers();
        this.layerBitMaps = new byte[this.numLayerBitMaps][][];
        this.compositeRows = new byte[this.numLayerBitMaps][];
        for (int i = 0; i < this.numLayerBitMaps; ++i) {
            this.layerBitMaps[i] = null;
        }
        this.numLayerBitMapsCreated = 0;
    }

    private void drawCell(Cell cell, Rectangle2D expandBounds, AffineTransform prevTrans, boolean topLevel) {
        renderPolyTime = 0L;
        renderTextTime = 0L;
        Iterator arcs = cell.getArcs();
        while (arcs.hasNext()) {
            this.drawArc((ArcInst)arcs.next(), prevTrans, false);
        }
        Iterator nodes = cell.getNodes();
        while (nodes.hasNext()) {
            this.drawNode((NodeInst)nodes.next(), prevTrans, topLevel, expandBounds, false);
        }
        if (topLevel && User.isTextVisibilityOnCell()) {
            int numPolys = cell.numDisplayableVariables(true);
            Poly[] polys = new Poly[numPolys];
            cell.addDisplayableVariables(CENTERRECT, polys, 0, this.wnd, true);
            this.drawPolys(polys, prevTrans, false);
        }
    }

    public void drawNode(NodeInst ni, AffineTransform trans, boolean topLevel, Rectangle2D expandBounds, boolean forceVisible) {
        NodeProto np = ni.getProto();
        AffineTransform localTrans = ni.rotateOut(trans);
        if (np instanceof Cell) {
            List path;
            ++totalCells;
            double halfWidth = Math.max(ni.getXSize(), ni.getYSize()) / 2.0;
            if (halfWidth * this.wnd.getScale() < 1.0) {
                ++tinyCells;
                return;
            }
            Cell subCell = (Cell)np;
            AffineTransform subTrans = ni.translateOut(localTrans);
            Rectangle2D cellBounds = subCell.getBounds();
            Poly poly = new Poly(cellBounds);
            poly.transform(subTrans);
            if (this.wnd.isInPlaceEdit()) {
                poly.transform(this.wnd.getInPlaceTransformIn());
            }
            cellBounds = poly.getBounds2D();
            Rectangle screenBounds = this.wnd.databaseToScreen(cellBounds);
            if (screenBounds.width <= 0 || screenBounds.height <= 0) {
                return;
            }
            if (screenBounds.x > this.sz.width || screenBounds.x + screenBounds.width < 0) {
                return;
            }
            if (screenBounds.y > this.sz.height || screenBounds.y + screenBounds.height < 0) {
                return;
            }
            boolean expanded = ni.isExpanded();
            if (!expanded && expandBounds != null && cellBounds.intersects(expandBounds)) {
                expanded = true;
            }
            if (!expanded && (path = this.wnd.getInPlaceEditNodePath()) != null) {
                for (int pathIndex = 0; pathIndex < path.size(); ++pathIndex) {
                    NodeInst niOnPath = (NodeInst)path.get(pathIndex);
                    if (niOnPath.getProto() != subCell) continue;
                    expanded = true;
                    break;
                }
            }
            if (expanded) {
                if (!this.expandedCellCached(subCell, subTrans)) {
                    this.drawCell(subCell, expandBounds, subTrans, false);
                }
                this.showCellPorts(ni, trans, Color.BLACK);
            } else {
                this.drawUnexpandedCell(ni, trans);
                this.showCellPorts(ni, trans, null);
            }
            if (User.isTextVisibilityOnNode()) {
                int numPolys = ni.numDisplayableVariables(true);
                Poly[] polys = new Poly[numPolys];
                Rectangle2D rect = ni.getUntransformedBounds();
                ni.addDisplayableVariables(rect, polys, 0, this.wnd, true);
                this.drawPolys(polys, localTrans, false);
            }
        } else {
            Point2D ctr = ni.getTrueCenter();
            trans.transform(ctr, ctr);
            double halfWidth = Math.max(ni.getXSize(), ni.getYSize()) / 2.0;
            Rectangle2D databaseBounds = this.wnd.getDisplayedBounds();
            double ctrX = ctr.getX();
            double ctrY = ctr.getY();
            if (ctrX + halfWidth < databaseBounds.getMinX()) {
                return;
            }
            if (ctrX - halfWidth > databaseBounds.getMaxX()) {
                return;
            }
            if (ctrY + halfWidth < databaseBounds.getMinY()) {
                return;
            }
            if (ctrY - halfWidth > databaseBounds.getMaxY()) {
                return;
            }
            PrimitiveNode prim = (PrimitiveNode)np;
            ++totalPrims;
            if (!prim.isCanBeZeroSize() && halfWidth * this.wnd.getScale() < 1.0) {
                ++tinyPrims;
                Point scrPt = this.wnd.databaseToScreen(ctrX, ctrY);
                if (scrPt.x >= 0 && scrPt.x < this.sz.width && scrPt.y >= 0 && scrPt.y < this.sz.height) {
                    this.drawTinyLayers(prim.layerIterator(), scrPt.x, scrPt.y);
                }
                return;
            }
            if (topLevel || !ni.isVisInside()) {
                EditWindow nodeWnd = this.wnd;
                if (!User.isTextVisibilityOnNode()) {
                    nodeWnd = null;
                }
                if (prim == Generic.tech.invisiblePinNode && !User.isTextVisibilityOnAnnotation()) {
                    nodeWnd = null;
                }
                Technology tech = prim.getTechnology();
                Poly[] polys = tech.getShapeOfNode(ni, nodeWnd);
                this.drawPolys(polys, localTrans, forceVisible);
            }
        }
        if (topLevel && User.isTextVisibilityOnExport()) {
            int exportDisplayLevel = User.getExportDisplayLevel();
            Iterator it = ni.getExports();
            blackGraphics.setColor(new Color(User.getColorText()));
            while (it.hasNext()) {
                int numPolys;
                Export e = (Export)it.next();
                Poly poly = e.getNamePoly();
                Rectangle2D rect = (Rectangle2D)poly.getBounds2D().clone();
                if (exportDisplayLevel == 2) {
                    this.drawCross(poly, blackGraphics, false);
                } else {
                    TextDescriptor descript = poly.getTextDescriptor();
                    Poly.Type type = descript.getPos().getPolyType();
                    String portName = e.getName();
                    if (exportDisplayLevel == 1) {
                        portName = e.getShortName();
                    }
                    Point pt = this.wnd.databaseToScreen(poly.getCenterX(), poly.getCenterY());
                    Rectangle textRect = new Rectangle(pt);
                    type = Poly.rotateType(type, ni);
                    this.drawText(textRect, type, descript, portName, null, blackGraphics, false);
                }
                if ((numPolys = e.numDisplayableVariables(true)) <= 0) continue;
                Poly[] polys = new Poly[numPolys];
                e.addDisplayableVariables(rect, polys, 0, this.wnd, true);
                this.drawPolys(polys, localTrans, false);
            }
        }
    }

    public void drawArc(ArcInst ai, AffineTransform trans, boolean forceVisible) {
        Rectangle2D arcBounds = ai.getBounds();
        Rectangle2D dbBounds = new Rectangle2D.Double(arcBounds.getX(), arcBounds.getY(), arcBounds.getWidth(), arcBounds.getHeight());
        Poly p = new Poly(dbBounds);
        p.transform(trans);
        dbBounds = p.getBounds2D();
        if (dbBounds.getWidth() == 0.0 || dbBounds.getHeight() == 0.0) {
            dbBounds = new Rectangle2D.Double(dbBounds.getX(), dbBounds.getY(), dbBounds.getWidth() + 0.001, dbBounds.getHeight() + 0.001);
        }
        if (this.drawBounds != null && !this.drawBounds.intersects(dbBounds)) {
            return;
        }
        double arcSize = Math.max(arcBounds.getWidth(), arcBounds.getHeight());
        ++totalArcs;
        if (arcSize * this.wnd.getScale() < 2.0) {
            ++tinyArcs;
            Point2D ctr = ai.getTrueCenter();
            trans.transform(ctr, ctr);
            Point scrPt = this.wnd.databaseToScreen(ctr.getX(), ctr.getY());
            if (scrPt.x >= 0 && scrPt.x < this.sz.width && scrPt.y >= 0 && scrPt.y < this.sz.height) {
                PrimitiveArc prim = (PrimitiveArc)ai.getProto();
                this.drawTinyLayers(prim.layerIterator(), scrPt.x, scrPt.y);
            }
            return;
        }
        ArcProto ap = ai.getProto();
        Technology tech = ap.getTechnology();
        EditWindow arcWnd = this.wnd;
        if (!User.isTextVisibilityOnArc()) {
            arcWnd = null;
        }
        Poly[] polys = tech.getShapeOfArc(ai, arcWnd);
        this.drawPolys(polys, trans, forceVisible);
    }

    private void showCellPorts(NodeInst ni, AffineTransform trans, Color col) {
        PortInst pi;
        int numPorts = ni.getProto().getNumPorts();
        boolean[] shownPorts = new boolean[numPorts];
        Iterator it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            pi = con.getPortInst();
            shownPorts[pi.getPortIndex()] = true;
        }
        it = ni.getExports();
        while (it.hasNext()) {
            Export exp = (Export)it.next();
            pi = exp.getOriginalPort();
            shownPorts[pi.getPortIndex()] = true;
        }
        int portDisplayLevel = User.getPortDisplayLevel();
        for (int i = 0; i < numPorts; ++i) {
            Export pp;
            Poly portPoly;
            if (shownPorts[i] || (portPoly = ni.getShapeOfPort(pp = (Export)ni.getProto().getPort(i))) == null) continue;
            portPoly.transform(trans);
            Color portColor = col;
            if (portColor == null) {
                portColor = pp.getBasePort().getPortColor();
            }
            portGraphics.setColor(portColor);
            if (portDisplayLevel == 2) {
                this.drawCross(portPoly, portGraphics, false);
                continue;
            }
            if (!User.isTextVisibilityOnPort()) continue;
            TextDescriptor descript = portPoly.getTextDescriptor();
            TextDescriptor portDescript = pp.getTextDescriptor();
            TextDescriptor newDescript = new TextDescriptor(pp, portDescript);
            newDescript.lowLevelSetColorIndex(descript.getColorIndex());
            Poly.Type type = descript.getPos().getPolyType();
            String portName = pp.getName();
            if (portDisplayLevel == 1) {
                portName = pp.getShortName();
            }
            Point pt = this.wnd.databaseToScreen(portPoly.getCenterX(), portPoly.getCenterY());
            Rectangle rect = new Rectangle(pt);
            this.drawText(rect, type, newDescript, portName, null, portGraphics, false);
        }
    }

    private void drawUnexpandedCell(NodeInst ni, AffineTransform trans) {
        NodeProto np = ni.getProto();
        Poly poly = new Poly(ni.getTrueCenterX(), ni.getTrueCenterY(), ni.getXSize(), ni.getYSize());
        AffineTransform localPureTrans = ni.rotateOutAboutTrueCenter(trans);
        poly.transform(localPureTrans);
        if (this.wnd.isInPlaceEdit()) {
            poly.transform(this.wnd.getInPlaceTransformIn());
        }
        Point2D[] points = poly.getPoints();
        for (int i = 0; i < points.length; ++i) {
            int lastI = i - 1;
            if (lastI < 0) {
                lastI = points.length - 1;
            }
            Point from = this.wnd.databaseToScreen(points[lastI]);
            Point to = this.wnd.databaseToScreen(points[i]);
            blackGraphics.setColor(new Color(User.getColorInstanceOutline()));
            this.drawLine(from, to, null, blackGraphics, 0, false);
        }
        if (User.isTextVisibilityOnInstance()) {
            Rectangle2D bounds = poly.getBounds2D();
            Rectangle rect = this.wnd.databaseToScreen(bounds);
            TextDescriptor descript = ni.getProtoTextDescriptor();
            blackGraphics.setColor(new Color(User.getColorText()));
            this.drawText(rect, Poly.Type.TEXTBOX, descript, np.describe(), null, blackGraphics, false);
        }
    }

    private void drawTinyLayers(Iterator layerIterator, int x, int y) {
        Iterator it = layerIterator;
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            if (layer == null) continue;
            int layerNum = -1;
            int col = 0;
            EGraphics graphics = layer.getGraphics();
            if (graphics != null) {
                int pat;
                int[] pattern;
                if (graphics.isPatternedOnDisplay() && (pattern = graphics.getPattern()) != null && ((pat = pattern[y & 0xF]) == 0 || (pat & 32768 >> (x & 0xF)) == 0)) continue;
                layerNum = graphics.getTransparentLayer() - 1;
                col = graphics.getColor().getRGB() & 0xFFFFFF;
            }
            if (layerNum >= this.numLayerBitMaps) continue;
            byte[][] layerBitMap = this.getLayerBitMap(layerNum);
            if (layerBitMap == null) {
                int index = y * this.sz.width + x;
                int alpha = this.opaqueData[index] >> 24 & 0xFF;
                if (alpha != 255) continue;
                this.opaqueData[index] = col;
                continue;
            }
            byte[] byArray = layerBitMap[y];
            int n = x >> 3;
            byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
        }
    }

    private boolean expandedCellCached(Cell subCell, AffineTransform origTrans) {
        PixelDrawing offscreen;
        String expandedName;
        ExpandedCellInfo expandedCellCount;
        if (expandedCells == null) {
            return false;
        }
        if (subCell.isIcon()) {
            return false;
        }
        AffineTransform subTrans = origTrans;
        if (this.wnd.isInPlaceEdit()) {
            AffineTransform newTrans;
            subTrans = newTrans = new AffineTransform(subTrans);
            subTrans.preConcatenate(this.wnd.getInPlaceTransformIn());
        }
        if ((expandedCellCount = (ExpandedCellInfo)expandedCells.get(expandedName = this.makeExpandedName(subCell, subTrans))) != null && expandedCellCount.instanceCount < 2) {
            return false;
        }
        Rectangle2D.Double cellBounds = new Rectangle2D.Double();
        ((Rectangle2D)cellBounds).setRect(subCell.getBounds());
        Poly poly = new Poly(cellBounds);
        poly.transform(subTrans);
        Rectangle screenBounds = new Rectangle(this.wnd.databaseToScreen(poly.getBounds2D()));
        if (screenBounds.width <= 0 || screenBounds.height <= 0) {
            return true;
        }
        if (screenBounds.width >= PixelDrawing.topSz.width / 2 && screenBounds.height >= PixelDrawing.topSz.height / 2) {
            return false;
        }
        if (expandedCellCount == null) {
            expandedCellCount = new ExpandedCellInfo();
            expandedCellCount.instanceCount = 0;
            expandedCellCount.offscreen = null;
            expandedCells.put(expandedName, expandedCellCount);
        }
        if ((offscreen = expandedCellCount.offscreen) == null) {
            EditWindow renderedCell = EditWindow.CreateElectricDoc(subCell, null);
            renderedCell.setInPlaceEditNodePath(this.wnd.getInPlaceEditNodePath());
            Undo.removeDatabaseChangeListener(renderedCell);
            renderedCell.setScreenSize(new Dimension(screenBounds.width + 1, screenBounds.height + 1));
            renderedCell.setScale(this.wnd.getScale());
            renderedCell.getOffscreen().clearImage(true);
            Point2D.Double cellCtr = new Point2D.Double(cellBounds.getCenterX(), cellBounds.getCenterY());
            origTrans.transform(cellCtr, cellCtr);
            renderedCell.setOffset(cellCtr);
            renderedCell.getOffscreen().renderedWindow = false;
            renderedCell.getOffscreen().drawCell(subCell, null, origTrans, false);
            expandedCellCount.offscreen = renderedCell.getOffscreen();
            offscreen = expandedCellCount.offscreen;
            offscreen.wnd = null;
            renderedCell.finished();
            ++offscreensCreated;
        }
        this.copyBits(offscreen, screenBounds);
        ++offscreensUsed;
        return true;
    }

    private void countCell(Cell cell, Rectangle2D expandBounds, AffineTransform prevTrans) {
        Iterator nodes = cell.getNodes();
        while (nodes.hasNext()) {
            NodeInst ni = (NodeInst)nodes.next();
            if (!(ni.getProto() instanceof Cell)) continue;
            this.countNode(ni, expandBounds, prevTrans);
        }
    }

    private void countNode(NodeInst ni, Rectangle2D expandBounds, AffineTransform trans) {
        List path;
        double halfWidth = Math.max(ni.getXSize(), ni.getYSize()) / 2.0;
        if (halfWidth * this.wnd.getScale() < 1.0) {
            return;
        }
        AffineTransform localTrans = ni.rotateOut(trans);
        AffineTransform subTrans = ni.translateOut(localTrans);
        NodeProto np = ni.getProto();
        Cell subCell = (Cell)np;
        Rectangle2D cellBounds = subCell.getBounds();
        Poly poly = new Poly(cellBounds);
        poly.transform(subTrans);
        if (this.wnd.isInPlaceEdit()) {
            poly.transform(this.wnd.getInPlaceTransformIn());
        }
        cellBounds = poly.getBounds2D();
        Rectangle screenBounds = this.wnd.databaseToScreen(cellBounds);
        if (screenBounds.width <= 0 || screenBounds.height <= 0) {
            return;
        }
        if (screenBounds.x > this.sz.width || screenBounds.x + screenBounds.width < 0) {
            return;
        }
        if (screenBounds.y > this.sz.height || screenBounds.y + screenBounds.height < 0) {
            return;
        }
        boolean expanded = ni.isExpanded();
        if (!expanded && expandBounds != null && cellBounds.intersects(expandBounds)) {
            expanded = true;
        }
        if (!expanded && (path = this.wnd.getInPlaceEditNodePath()) != null) {
            for (int pathIndex = 0; pathIndex < path.size(); ++pathIndex) {
                NodeInst niOnPath = (NodeInst)path.get(pathIndex);
                if (niOnPath.getProto() != subCell) continue;
                expanded = true;
                break;
            }
        }
        if (!expanded) {
            return;
        }
        if (screenBounds.width < this.sz.width / 2 || screenBounds.height <= this.sz.height / 2) {
            String expandedName = this.makeExpandedName(subCell, subTrans);
            ExpandedCellInfo expansionCount = (ExpandedCellInfo)expandedCells.get(expandedName);
            if (expansionCount == null) {
                expansionCount = new ExpandedCellInfo();
                expansionCount.instanceCount = 1;
                expandedCells.put(expandedName, expansionCount);
            } else {
                expansionCount.instanceCount++;
                return;
            }
        }
        this.countCell(subCell, expandBounds, subTrans);
    }

    public static void forceRedraw(Cell cell) {
        ArrayList keys = new ArrayList();
        Iterator it = expandedCells.keySet().iterator();
        while (it.hasNext()) {
            keys.add(it.next());
        }
        String description = cell.describe();
        Iterator it2 = keys.iterator();
        while (it2.hasNext()) {
            String expandedName = (String)it2.next();
            String cellName = expandedName;
            int spacePos = cellName.indexOf(32);
            if (spacePos >= 0) {
                cellName = cellName.substring(0, spacePos);
            }
            if (!cellName.equals(description)) continue;
            expandedCells.remove(expandedName);
        }
    }

    private String makeExpandedName(Cell subCell, AffineTransform subTrans) {
        int t00 = (int)(subTrans.getScaleX() * 100.0);
        int t01 = (int)(subTrans.getShearX() * 100.0);
        int t10 = (int)(subTrans.getShearY() * 100.0);
        int t11 = (int)(subTrans.getScaleY() * 100.0);
        String expandedName = subCell.describe() + " " + t00 + " " + t01 + " " + t10 + " " + t11;
        return expandedName;
    }

    private void copyBits(PixelDrawing srcOffscreen, Rectangle screenBounds) {
        if (srcOffscreen == null) {
            return;
        }
        Dimension dim = srcOffscreen.sz;
        for (int srcY = 0; srcY < dim.height; ++srcY) {
            int destY = srcY + screenBounds.y;
            if (destY < 0 || destY >= this.sz.height) continue;
            int srcBase = srcY * dim.width;
            int destBase = destY * this.sz.width;
            for (int srcX = 0; srcX < dim.width; ++srcX) {
                int destX = srcX + screenBounds.x;
                if (destX < 0 || destX >= this.sz.width) continue;
                int srcColor = srcOffscreen.opaqueData[srcBase + srcX];
                if (srcColor != this.backgroundValue) {
                    this.opaqueData[destBase + destX] = srcColor;
                }
                for (int i = 0; i < this.numLayerBitMaps; ++i) {
                    byte[][] srcLayerBitMap = srcOffscreen.layerBitMaps[i];
                    if (srcLayerBitMap == null) continue;
                    byte[] srcRow = srcLayerBitMap[srcY];
                    byte[][] destLayerBitMap = this.getLayerBitMap(i);
                    byte[] destRow = destLayerBitMap[destY];
                    if ((srcRow[srcX >> 3] & 1 << (srcX & 7)) == 0) continue;
                    int n = destX >> 3;
                    destRow[n] = (byte)(destRow[n] | 1 << (destX & 7));
                }
            }
        }
        Iterator it = srcOffscreen.patternedOpaqueLayers.keySet().iterator();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            PatternedOpaqueLayer polSrc = (PatternedOpaqueLayer)srcOffscreen.patternedOpaqueLayers.get(layer);
            byte[][] srcLayerBitMap = polSrc.bitMap;
            if (srcLayerBitMap == null) continue;
            if (this.renderedWindow) {
                EGraphics desc = layer.getGraphics();
                int col = desc.getColor().getRGB() & 0xFFFFFF;
                int[] pattern = desc.getPattern();
                for (int srcY = 0; srcY < dim.height; ++srcY) {
                    int destY = srcY + screenBounds.y;
                    if (destY < 0 || destY >= this.sz.height) continue;
                    int destBase = destY * this.sz.width;
                    int pat = pattern[destY & 0xF];
                    if (pat == 0) continue;
                    byte[] srcRow = srcLayerBitMap[srcY];
                    for (int srcX = 0; srcX < dim.width; ++srcX) {
                        int destX = srcX + screenBounds.x;
                        if (destX < 0 || destX >= this.sz.width || (srcRow[srcX >> 3] & 1 << (srcX & 7)) == 0 || (pat & 32768 >> (destX & 0xF)) == 0) continue;
                        this.opaqueData[destBase + destX] = col;
                    }
                }
                continue;
            }
            PatternedOpaqueLayer polDest = (PatternedOpaqueLayer)this.patternedOpaqueLayers.get(layer);
            if (polDest == null) {
                polDest = new PatternedOpaqueLayer();
                PatternedOpaqueLayer.access$002(polDest, new byte[this.sz.height][]);
                for (int y = 0; y < this.sz.height; ++y) {
                    byte[] row = new byte[this.numBytesPerRow];
                    for (int x = 0; x < this.numBytesPerRow; ++x) {
                        row[x] = 0;
                    }
                    ((PatternedOpaqueLayer)polDest).bitMap[y] = row;
                }
                this.patternedOpaqueLayers.put(layer, polDest);
            }
            byte[][] destLayerBitMap = polDest.bitMap;
            for (int srcY = 0; srcY < dim.height; ++srcY) {
                int destY = srcY + screenBounds.y;
                if (destY < 0 || destY >= this.sz.height) continue;
                int destBase = destY * this.sz.width;
                byte[] srcRow = srcLayerBitMap[srcY];
                byte[] destRow = destLayerBitMap[destY];
                for (int srcX = 0; srcX < dim.width; ++srcX) {
                    int destX = srcX + screenBounds.x;
                    if (destX < 0 || destX >= this.sz.width || (srcRow[srcX >> 3] & 1 << (srcX & 7)) == 0) continue;
                    int n = destX >> 3;
                    destRow[n] = (byte)(destRow[n] | 1 << (destX & 7));
                }
            }
        }
    }

    private void drawPolys(Poly[] polys, AffineTransform trans, boolean forceVisible) {
        if (polys == null) {
            return;
        }
        for (int i = 0; i < polys.length; ++i) {
            Poly poly = polys[i];
            if (poly == null) continue;
            Layer layer = poly.getLayer();
            EGraphics graphics = null;
            boolean dimmed = false;
            if (layer != null) {
                if (!forceVisible && !layer.isVisible()) continue;
                graphics = layer.getGraphics();
                dimmed = layer.isDimmed();
            }
            poly.transform(trans);
            if (this.wnd.isInPlaceEdit()) {
                poly.transform(this.wnd.getInPlaceTransformIn());
            }
            long startTime = System.currentTimeMillis();
            this.renderPoly(poly, graphics, dimmed);
            renderPolyTime += System.currentTimeMillis() - startTime;
            if (!this.periodicRefresh) continue;
            ++this.objectCount;
            if (this.objectCount <= 100) continue;
            this.objectCount = 0;
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastRefreshTime <= 1000L) continue;
            this.lastRefreshTime = currentTime;
            this.wnd.repaint();
        }
    }

    private byte[][] getLayerBitMap(int layerNum) {
        if (layerNum < 0) {
            return null;
        }
        Object layerBitMap = this.layerBitMaps[layerNum];
        if (layerBitMap == null) {
            layerBitMap = new byte[this.sz.height][];
            for (int y = 0; y < this.sz.height; ++y) {
                byte[] row = new byte[this.numBytesPerRow];
                for (int x = 0; x < this.numBytesPerRow; ++x) {
                    row[x] = 0;
                }
                layerBitMap[y] = row;
            }
            this.layerBitMaps[layerNum] = layerBitMap;
            ++this.numLayerBitMapsCreated;
        }
        return layerBitMap;
    }

    private void renderPoly(Poly poly, EGraphics graphics, boolean dimmed) {
        Point center;
        Point pt2;
        Rectangle2D bounds;
        int layerNum = -1;
        if (graphics != null) {
            layerNum = graphics.getTransparentLayer() - 1;
        }
        if (layerNum >= this.numLayerBitMaps) {
            return;
        }
        byte[][] layerBitMap = this.getLayerBitMap(layerNum);
        Poly.Type style = poly.getStyle();
        if (!this.renderedWindow && (style == Poly.Type.FILLED || style == Poly.Type.DISC) && layerBitMap == null && graphics.isPatternedOnDisplay()) {
            Layer layer = poly.getLayer();
            PatternedOpaqueLayer pol = (PatternedOpaqueLayer)this.patternedOpaqueLayers.get(layer);
            if (pol == null) {
                pol = new PatternedOpaqueLayer();
                PatternedOpaqueLayer.access$002(pol, new byte[this.sz.height][]);
                for (int y = 0; y < this.sz.height; ++y) {
                    byte[] row = new byte[this.numBytesPerRow];
                    for (int x = 0; x < this.numBytesPerRow; ++x) {
                        row[x] = 0;
                    }
                    ((PatternedOpaqueLayer)pol).bitMap[y] = row;
                }
                this.patternedOpaqueLayers.put(layer, pol);
            }
            layerBitMap = pol.bitMap;
            graphics = null;
        }
        Point2D[] points = poly.getPoints();
        if (style == Poly.Type.FILLED) {
            bounds = poly.getBox();
            if (bounds != null) {
                Point llPt = this.wnd.databaseToScreen(bounds.getMinX(), bounds.getMinY());
                Point urPt = this.wnd.databaseToScreen(bounds.getMaxX(), bounds.getMaxY());
                int lX = Math.min(llPt.x, urPt.x);
                int hX = Math.max(llPt.x, urPt.x);
                int lY = Math.min(llPt.y, urPt.y);
                int hY = Math.max(llPt.y, urPt.y);
                if (lX < 0) {
                    lX = 0;
                }
                if (hX >= this.sz.width) {
                    hX = this.sz.width - 1;
                }
                if (lY < 0) {
                    lY = 0;
                }
                if (hY >= this.sz.height) {
                    hY = this.sz.height - 1;
                }
                this.drawBox(lX, hX, lY, hY, layerBitMap, graphics, dimmed);
                return;
            }
            Point[] intPoints = new Point[points.length];
            for (int i = 0; i < points.length; ++i) {
                intPoints[i] = this.wnd.databaseToScreen(points[i]);
            }
            Point[] clippedPoints = GenMath.clipPoly(intPoints, 0, this.sz.width - 1, 0, this.sz.height - 1);
            this.drawPolygon(clippedPoints, layerBitMap, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.CROSSED) {
            Point pt0a = this.wnd.databaseToScreen(points[0]);
            Point pt1a = this.wnd.databaseToScreen(points[1]);
            Point pt2a = this.wnd.databaseToScreen(points[2]);
            Point pt3a = this.wnd.databaseToScreen(points[3]);
            Point pt0b = new Point(pt0a);
            Point pt0c = new Point(pt0a);
            Point pt1b = new Point(pt1a);
            Point pt1c = new Point(pt1a);
            Point pt2b = new Point(pt2a);
            Point pt2c = new Point(pt2a);
            Point pt3b = new Point(pt3a);
            Point pt3c = new Point(pt3a);
            this.drawLine(pt0a, pt1a, layerBitMap, graphics, 0, dimmed);
            this.drawLine(pt1b, pt2a, layerBitMap, graphics, 0, dimmed);
            this.drawLine(pt2b, pt3a, layerBitMap, graphics, 0, dimmed);
            this.drawLine(pt3b, pt0b, layerBitMap, graphics, 0, dimmed);
            this.drawLine(pt0c, pt2c, layerBitMap, graphics, 0, dimmed);
            this.drawLine(pt1c, pt3c, layerBitMap, graphics, 0, dimmed);
            return;
        }
        if (style.isText()) {
            bounds = poly.getBounds2D();
            Rectangle rect = this.wnd.databaseToScreen(bounds);
            TextDescriptor descript = poly.getTextDescriptor();
            String str = poly.getString();
            this.drawText(rect, style, descript, str, layerBitMap, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.CLOSED || style == Poly.Type.OPENED || style == Poly.Type.OPENEDT1 || style == Poly.Type.OPENEDT2 || style == Poly.Type.OPENEDT3) {
            int lineType = 0;
            if (style == Poly.Type.OPENEDT1) {
                lineType = 1;
            } else if (style == Poly.Type.OPENEDT2) {
                lineType = 2;
            } else if (style == Poly.Type.OPENEDT3) {
                lineType = 3;
            }
            for (int j = 1; j < points.length; ++j) {
                Point pt1 = this.wnd.databaseToScreen(points[j - 1]);
                Point pt22 = this.wnd.databaseToScreen(points[j]);
                this.drawLine(pt1, pt22, layerBitMap, graphics, lineType, dimmed);
            }
            if (style == Poly.Type.CLOSED) {
                Point pt1 = this.wnd.databaseToScreen(points[points.length - 1]);
                pt2 = this.wnd.databaseToScreen(points[0]);
                this.drawLine(pt1, pt2, layerBitMap, graphics, lineType, dimmed);
            }
            return;
        }
        if (style == Poly.Type.VECTORS) {
            for (int j = 0; j < points.length; j += 2) {
                Point pt1 = this.wnd.databaseToScreen(points[j]);
                pt2 = this.wnd.databaseToScreen(points[j + 1]);
                this.drawLine(pt1, pt2, layerBitMap, graphics, 0, dimmed);
            }
            return;
        }
        if (style == Poly.Type.CIRCLE) {
            center = this.wnd.databaseToScreen(points[0]);
            Point edge = this.wnd.databaseToScreen(points[1]);
            this.drawCircle(center, edge, layerBitMap, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.THICKCIRCLE) {
            center = this.wnd.databaseToScreen(points[0]);
            Point edge = this.wnd.databaseToScreen(points[1]);
            this.drawThickCircle(center, edge, layerBitMap, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.DISC) {
            center = this.wnd.databaseToScreen(points[0]);
            Point edge = this.wnd.databaseToScreen(points[1]);
            this.drawDisc(center, edge, layerBitMap, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.CIRCLEARC || style == Poly.Type.THICKCIRCLEARC) {
            center = this.wnd.databaseToScreen(points[0]);
            Point edge1 = this.wnd.databaseToScreen(points[1]);
            Point edge2 = this.wnd.databaseToScreen(points[2]);
            this.drawCircleArc(center, edge1, edge2, style == Poly.Type.THICKCIRCLEARC, layerBitMap, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.CROSS) {
            this.drawCross(poly, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.BIGCROSS) {
            center = this.wnd.databaseToScreen(points[0]);
            int size = 5;
            this.drawLine(new Point(center.x - size, center.y), new Point(center.x + size, center.y), layerBitMap, graphics, 0, dimmed);
            this.drawLine(new Point(center.x, center.y - size), new Point(center.x, center.y + size), layerBitMap, graphics, 0, dimmed);
            return;
        }
    }

    private int getTheColor(EGraphics desc, boolean dimmed) {
        int col = desc.getColor().getRGB() & 0xFFFFFF;
        if (dimmed) {
            col = this.dimColor(col);
        }
        return col;
    }

    private int dimColor(int col) {
        int r = col & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col >> 16 & 0xFF;
        Color.RGBtoHSB(r, g, b, this.hsbTempArray);
        this.hsbTempArray[1] = (float)((double)this.hsbTempArray[1] * 0.2);
        col = Color.HSBtoRGB(this.hsbTempArray[0], this.hsbTempArray[1], this.hsbTempArray[2]) & 0xFFFFFF;
        return col;
    }

    private void drawBox(int lX, int hX, int lY, int hY, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        int col = 0;
        int[] pattern = null;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
            if (desc.isPatternedOnDisplay()) {
                pattern = desc.getPattern();
            }
        }
        if (pattern == null) {
            if (layerBitMap == null) {
                for (int y = lY; y <= hY; ++y) {
                    int baseIndex = y * this.sz.width + lX;
                    for (int x = lX; x <= hX; ++x) {
                        int index;
                        int alpha;
                        if ((alpha = this.opaqueData[index = baseIndex++] >> 24 & 0xFF) != 255) continue;
                        this.opaqueData[index] = col;
                    }
                }
            } else {
                for (int y = lY; y <= hY; ++y) {
                    byte[] row = layerBitMap[y];
                    for (int x = lX; x <= hX; ++x) {
                        int n = x >> 3;
                        row[n] = (byte)(row[n] | 1 << (x & 7));
                    }
                }
            }
        } else if (layerBitMap == null) {
            for (int y = lY; y <= hY; ++y) {
                int pat = pattern[y & 0xF];
                if (pat == 0) continue;
                int baseIndex = y * this.sz.width;
                for (int x = lX; x <= hX; ++x) {
                    if ((pat & 32768 >> (x & 0xF)) == 0) continue;
                    this.opaqueData[baseIndex + x] = col;
                }
            }
        } else {
            for (int y = lY; y <= hY; ++y) {
                int pat = pattern[y & 0xF];
                if (pat == 0) continue;
                byte[] row = layerBitMap[y];
                for (int x = lX; x <= hX; ++x) {
                    if ((pat & 32768 >> (x & 0xF)) == 0) continue;
                    int n = x >> 3;
                    row[n] = (byte)(row[n] | 1 << (x & 7));
                }
            }
        }
    }

    private void drawLine(Point pt1, Point pt2, byte[][] layerBitMap, EGraphics desc, int texture, boolean dimmed) {
        if (GenMath.clipLine(pt1, pt2, 0, this.sz.width - 1, 0, this.sz.height - 1)) {
            return;
        }
        switch (texture) {
            case 0: {
                this.drawSolidLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, desc, dimmed);
                break;
            }
            case 1: {
                this.drawPatLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, desc, 136, dimmed);
                break;
            }
            case 2: {
                this.drawPatLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, desc, 231, dimmed);
                break;
            }
            case 3: {
                this.drawThickLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, desc, dimmed);
            }
        }
    }

    private void drawCross(Poly poly, EGraphics graphics, boolean dimmed) {
        Point2D[] points = poly.getPoints();
        Point center = this.wnd.databaseToScreen(points[0]);
        int size = 3;
        this.drawLine(new Point(center.x - size, center.y), new Point(center.x + size, center.y), null, graphics, 0, dimmed);
        this.drawLine(new Point(center.x, center.y - size), new Point(center.x, center.y + size), null, graphics, 0, dimmed);
    }

    private void drawSolidLine(int x1, int y1, int x2, int y2, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        int dy;
        int dx;
        int col = 0;
        int[] pattern = null;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
            if (desc.isPatternedOnDisplay()) {
                pattern = desc.getPattern();
            }
        }
        if ((dx = Math.abs(x2 - x1)) > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            if (layerBitMap == null) {
                this.opaqueData[y * this.sz.width + x] = col;
            } else {
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
            while (x < xend) {
                ++x;
                if (d < 0) {
                    d += incr1;
                } else {
                    y += yincr;
                    d += incr2;
                }
                if (layerBitMap == null) {
                    this.opaqueData[y * this.sz.width + x] = col;
                    continue;
                }
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
        } else {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x ? -1 : 1;
            if (layerBitMap == null) {
                this.opaqueData[y * this.sz.width + x] = col;
            } else {
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
            while (y < yend) {
                ++y;
                if (d < 0) {
                    d += incr1;
                } else {
                    x += xincr;
                    d += incr2;
                }
                if (layerBitMap == null) {
                    this.opaqueData[y * this.sz.width + x] = col;
                    continue;
                }
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
        }
    }

    private void drawPatLine(int x1, int y1, int x2, int y2, byte[][] layerBitMap, EGraphics desc, int pattern, boolean dimmed) {
        int dy;
        int col = 0;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
        }
        int i = 0;
        int dx = Math.abs(x2 - x1);
        if (dx > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            if (layerBitMap == null) {
                this.opaqueData[y * this.sz.width + x] = col;
            } else {
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
            while (x < xend) {
                ++x;
                if (d < 0) {
                    d += incr1;
                } else {
                    y += yincr;
                    d += incr2;
                }
                i = i == 7 ? 0 : ++i;
                if ((pattern & 1 << i) == 0) continue;
                if (layerBitMap == null) {
                    this.opaqueData[y * this.sz.width + x] = col;
                    continue;
                }
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
        } else {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x ? -1 : 1;
            if (layerBitMap == null) {
                this.opaqueData[y * this.sz.width + x] = col;
            } else {
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
            while (y < yend) {
                ++y;
                if (d < 0) {
                    d += incr1;
                } else {
                    x += xincr;
                    d += incr2;
                }
                i = i == 7 ? 0 : ++i;
                if ((pattern & 1 << i) == 0) continue;
                if (layerBitMap == null) {
                    this.opaqueData[y * this.sz.width + x] = col;
                    continue;
                }
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
        }
    }

    private void drawThickLine(int x1, int y1, int x2, int y2, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        int dy;
        int dx;
        int col = 0;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
        }
        if ((dx = Math.abs(x2 - x1)) > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            this.drawThickPoint(x, y, layerBitMap, col);
            while (x < xend) {
                ++x;
                if (d < 0) {
                    d += incr1;
                } else {
                    y += yincr;
                    d += incr2;
                }
                this.drawThickPoint(x, y, layerBitMap, col);
            }
        } else {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x ? -1 : 1;
            this.drawThickPoint(x, y, layerBitMap, col);
            while (y < yend) {
                ++y;
                if (d < 0) {
                    d += incr1;
                } else {
                    x += xincr;
                    d += incr2;
                }
                this.drawThickPoint(x, y, layerBitMap, col);
            }
        }
    }

    private void drawPolygon(Point[] points, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        int i;
        int col = 0;
        int[] pattern = null;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
            if (desc.isPatternedOnDisplay()) {
                pattern = desc.getPattern();
            }
        }
        PolySeg edgelist = null;
        PolySeg[] polySegs = new PolySeg[points.length];
        for (i = 0; i < points.length; ++i) {
            polySegs[i] = new PolySeg();
            if (i == 0) {
                polySegs[i].fx = points[points.length - 1].x;
                polySegs[i].fy = points[points.length - 1].y;
            } else {
                polySegs[i].fx = points[i - 1].x;
                polySegs[i].fy = points[i - 1].y;
            }
            polySegs[i].tx = points[i].x;
            polySegs[i].ty = points[i].y;
        }
        block1: for (i = 0; i < points.length; ++i) {
            int j;
            if (pattern != null && desc.isOutlinedOnDisplay()) {
                this.drawSolidLine(polySegs[i].fx, polySegs[i].fy, polySegs[i].tx, polySegs[i].ty, layerBitMap, desc, dimmed);
            }
            if ((j = polySegs[i].ty - polySegs[i].fy) > 0) {
                polySegs[i].direction = 1;
            } else if (j < 0) {
                polySegs[i].direction = -1;
            } else {
                polySegs[i].direction = 0;
            }
            if (j == 0) {
                polySegs[i].increment = 0;
            } else {
                polySegs[i].increment = polySegs[i].tx - polySegs[i].fx;
                if (polySegs[i].increment != 0) {
                    polySegs[i].increment = (polySegs[i].increment * 65536 - j + 1) / j;
                }
            }
            polySegs[i].tx <<= 16;
            polySegs[i].fx <<= 16;
            if (polySegs[i].fy > polySegs[i].ty) {
                j = polySegs[i].tx;
                polySegs[i].tx = polySegs[i].fx;
                polySegs[i].fx = j;
                j = polySegs[i].ty;
                polySegs[i].ty = polySegs[i].fy;
                polySegs[i].fy = j;
            }
            if (edgelist == null) {
                edgelist = polySegs[i];
                polySegs[i].nextedge = null;
                continue;
            }
            if (edgelist.fy > polySegs[i].fy) {
                polySegs[i].nextedge = edgelist;
                edgelist = polySegs[i];
                continue;
            }
            PolySeg a = edgelist;
            while (a != null) {
                if (a.nextedge == null || a.nextedge.fy > polySegs[i].fy) {
                    polySegs[i].nextedge = a.nextedge;
                    a.nextedge = polySegs[i];
                    continue block1;
                }
                a = a.nextedge;
            }
        }
        int ycur = 0;
        PolySeg active = null;
        while (active != null || edgelist != null) {
            if (active == null) {
                active = edgelist;
                active.nextactive = null;
                edgelist = edgelist.nextedge;
                ycur = active.fy;
            }
            block4: while (edgelist != null && edgelist.fy <= ycur) {
                if (active.fx > edgelist.fx || active.fx == edgelist.fx && active.increment > edgelist.increment) {
                    edgelist.nextactive = active;
                    active = edgelist;
                    edgelist = edgelist.nextedge;
                    continue;
                }
                PolySeg a = active;
                while (a != null) {
                    if (a.nextactive == null || a.nextactive.fx > edgelist.fx || a.nextactive.fx == edgelist.fx && a.nextactive.increment > edgelist.increment) {
                        edgelist.nextactive = a.nextactive;
                        a.nextactive = edgelist;
                        edgelist = edgelist.nextedge;
                        continue block4;
                    }
                    a = a.nextactive;
                }
            }
            int wrap = 0;
            PolySeg left = active;
            PolySeg edge = active;
            while (edge != null) {
                if ((wrap += edge.direction) == 0) {
                    int x;
                    int j = left.fx + 32768 >> 16;
                    int k = edge.fx + 32768 >> 16;
                    if (pattern != null) {
                        int pat = pattern[ycur & 0xF];
                        if (pat != 0) {
                            int x2;
                            if (layerBitMap == null) {
                                int baseIndex = ycur * this.sz.width;
                                for (x2 = j; x2 <= k; ++x2) {
                                    if ((pat & 1 << 15 - (x2 & 0xF)) == 0) continue;
                                    this.opaqueData[baseIndex + x2] = col;
                                }
                            } else {
                                byte[] row = layerBitMap[ycur];
                                for (x2 = j; x2 <= k; ++x2) {
                                    if ((pat & 1 << 15 - (x2 & 0xF)) == 0) continue;
                                    int n = x2 >> 3;
                                    row[n] = (byte)(row[n] | 1 << (x2 & 7));
                                }
                            }
                        }
                    } else if (layerBitMap == null) {
                        int baseIndex = ycur * this.sz.width;
                        for (x = j; x <= k; ++x) {
                            this.opaqueData[baseIndex + x] = col;
                        }
                    } else {
                        byte[] row = layerBitMap[ycur];
                        for (x = j; x <= k; ++x) {
                            int n = x >> 3;
                            row[n] = (byte)(row[n] | 1 << (x & 7));
                        }
                    }
                    left = edge.nextactive;
                }
                edge = edge.nextactive;
            }
            ++ycur;
            PolySeg lastedge = null;
            PolySeg edge2 = active;
            while (edge2 != null) {
                if (ycur >= edge2.ty) {
                    if (lastedge == null) {
                        active = edge2.nextactive;
                    } else {
                        lastedge.nextactive = edge2.nextactive;
                    }
                } else {
                    edge2.fx += edge2.increment;
                    lastedge = edge2;
                }
                edge2 = edge2.nextactive;
            }
        }
    }

    private void drawText(Rectangle rect, Poly.Type style, TextDescriptor descript, String s, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        if (s == null) {
            return;
        }
        int len = s.length();
        if (len == 0) {
            return;
        }
        int col = 0;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
        }
        int size = EditWindow.getDefaultFontSize();
        boolean fontStyle = false;
        String fontName = User.getDefaultFont();
        boolean italic = false;
        boolean bold = false;
        boolean underline = false;
        int rotation = 0;
        if (descript != null) {
            TextDescriptor.ActiveFont af;
            double dSize;
            Color full;
            rotation = descript.getRotation().getIndex();
            int colorIndex = descript.getColorIndex();
            if (colorIndex != 0 && (full = EGraphics.getColorFromIndex(colorIndex)) != null) {
                col = full.getRGB() & 0xFFFFFF;
            }
            if ((size = (int)(dSize = descript.getTrueSize(this.wnd))) < 5) {
                int lY;
                int sizeIndent = (size + 1) / 4;
                int fakeWidth = (int)((double)len * dSize * 0.75);
                Point pt = PixelDrawing.getTextCorner(fakeWidth, size, style, rect, rotation);
                int lX = pt.x;
                int hX = lX + fakeWidth;
                int hY = lY = pt.y + sizeIndent;
                if (lX < 0) {
                    lX = 0;
                }
                if (hX >= this.sz.width) {
                    hX = this.sz.width - 1;
                }
                if (lY < 0) {
                    lY = 0;
                }
                if (hY >= this.sz.height) {
                    hY = this.sz.height - 1;
                }
                this.drawBox(lX, hX, lY, hY, layerBitMap, desc, dimmed);
                return;
            }
            italic = descript.isItalic();
            bold = descript.isBold();
            underline = descript.isUnderline();
            int fontIndex = descript.getFace();
            if (fontIndex != 0 && (af = TextDescriptor.ActiveFont.findActiveFont(fontIndex)) != null) {
                fontName = af.getName();
            }
        }
        int boxedWidth = -1;
        int boxedHeight = -1;
        if (style == Poly.Type.TEXTBOX) {
            boxedWidth = (int)rect.getWidth();
            boxedHeight = (int)rect.getHeight();
            Rectangle2D dbBounds = this.wnd.screenToDatabase(rect);
            if (this.drawBounds != null && this.drawBounds.getWidth() > 0.0 && !this.drawBounds.intersects(dbBounds)) {
                return;
            }
        }
        long startTime = System.currentTimeMillis();
        RenderTextInfo renderInfo = new RenderTextInfo();
        if (!renderInfo.buildInfo(s, fontName, size, italic, bold, underline, rect, style, rotation)) {
            return;
        }
        Rectangle2D dbBounds = this.wnd.screenToDatabase(renderInfo.bounds);
        if (this.wnd.isInPlaceEdit() && dbBounds != null) {
            AffineTransform xOut = this.wnd.getInPlaceTransformOut();
            GenMath.transformRect(dbBounds, xOut);
        }
        if (this.drawBounds != null && this.drawBounds.getWidth() > 0.0 && !this.drawBounds.intersects(dbBounds)) {
            return;
        }
        Raster ras = PixelDrawing.renderText(renderInfo);
        renderTextTime += System.currentTimeMillis() - startTime;
        if (ras == null) {
            return;
        }
        Point pt = PixelDrawing.getTextCorner(ras.getWidth(), ras.getHeight(), style, rect, rotation);
        int atX = pt.x;
        int atY = pt.y;
        DataBufferByte dbb = (DataBufferByte)ras.getDataBuffer();
        byte[] samples = dbb.getData();
        int rasWidth = ras.getWidth();
        int rasHeight = ras.getHeight();
        switch (rotation) {
            case 0: {
                int sx = atX < 0 ? -atX : 0;
                int ex = atX + rasWidth >= this.sz.width ? this.sz.width - 1 - atX : rasWidth;
                for (int y = 0; y < rasHeight; ++y) {
                    int trueY = atY + y;
                    if (trueY < 0 || trueY >= this.sz.height) continue;
                    byte[] row = null;
                    int baseIndex = 0;
                    if (layerBitMap == null) {
                        baseIndex = trueY * this.sz.width;
                    } else {
                        row = layerBitMap[trueY];
                    }
                    int samp = y * rasWidth + sx;
                    for (int x = sx; x < ex; ++x) {
                        int alpha;
                        int trueX = atX + x;
                        if ((alpha = samples[samp++] & 0xFF) == 0) continue;
                        if (layerBitMap == null) {
                            int fullIndex = baseIndex + trueX;
                            int pixelValue = this.opaqueData[fullIndex];
                            int oldAlpha = pixelValue >> 24 & 0xFF;
                            int color = col;
                            if (oldAlpha == 0) {
                                if (alpha != 255) {
                                    color = this.alphaBlend(color, pixelValue, alpha);
                                }
                            } else if (oldAlpha == 255 && alpha < 255) {
                                color = color & 0xFFFFFF | alpha << 24;
                            }
                            this.opaqueData[fullIndex] = color;
                            continue;
                        }
                        if (alpha < 128) continue;
                        int n = trueX >> 3;
                        row[n] = (byte)(row[n] | 1 << (trueX & 7));
                    }
                }
                break;
            }
            case 1: {
                int sx = atX - rasHeight < 0 ? rasHeight - atX : 0;
                int ex = atX >= this.sz.height ? this.sz.height - atX : rasHeight;
                for (int y = 0; y < rasWidth; ++y) {
                    int trueY = atY + y;
                    if (trueY < 0 || trueY >= this.sz.height) continue;
                    byte[] row = null;
                    int baseIndex = 0;
                    if (layerBitMap == null) {
                        baseIndex = trueY * this.sz.width;
                    } else {
                        row = layerBitMap[trueY];
                    }
                    for (int x = sx; x < ex; ++x) {
                        int trueX = atX + x;
                        int alpha = samples[x * rasWidth + (rasWidth - y - 1)] & 0xFF;
                        if (alpha == 0) continue;
                        if (layerBitMap == null) {
                            int fullIndex = baseIndex + trueX;
                            int pixelValue = this.opaqueData[fullIndex];
                            int oldAlpha = pixelValue >> 24 & 0xFF;
                            int color = col;
                            if (oldAlpha == 0) {
                                if (alpha != 255) {
                                    color = this.alphaBlend(color, pixelValue, alpha);
                                }
                            } else if (oldAlpha == 255 && alpha < 255) {
                                color = color & 0xFFFFFF | alpha << 24;
                            }
                            this.opaqueData[fullIndex] = color;
                            continue;
                        }
                        if (alpha < 128) continue;
                        int n = trueX >> 3;
                        row[n] = (byte)(row[n] | 1 << (trueX & 7));
                    }
                }
                break;
            }
            case 2: {
                atY -= rasHeight;
                int sx = (atX -= rasWidth) < 0 ? -atX : 0;
                int ex = atX + rasWidth >= this.sz.width ? this.sz.width - 1 - atX : rasWidth;
                for (int y = 0; y < rasHeight; ++y) {
                    int trueY = atY + y;
                    if (trueY < 0 || trueY >= this.sz.height) continue;
                    byte[] row = null;
                    int baseIndex = 0;
                    if (layerBitMap == null) {
                        baseIndex = trueY * this.sz.width;
                    } else {
                        row = layerBitMap[trueY];
                    }
                    for (int x = sx; x < ex; ++x) {
                        int trueX = atX + x;
                        int alpha = samples[(rasHeight - y - 1) * rasWidth + (rasWidth - x - 1)] & 0xFF;
                        if (alpha == 0) continue;
                        if (layerBitMap == null) {
                            int fullIndex = baseIndex + trueX;
                            int pixelValue = this.opaqueData[fullIndex];
                            int oldAlpha = pixelValue >> 24 & 0xFF;
                            int color = col;
                            if (oldAlpha == 0) {
                                if (alpha != 255) {
                                    color = this.alphaBlend(color, pixelValue, alpha);
                                }
                            } else if (oldAlpha == 255 && alpha < 255) {
                                color = color & 0xFFFFFF | alpha << 24;
                            }
                            this.opaqueData[fullIndex] = color;
                            continue;
                        }
                        if (alpha < 128) continue;
                        int n = trueX >> 3;
                        row[n] = (byte)(row[n] | 1 << (trueX & 7));
                    }
                }
                break;
            }
            case 3: {
                int sx = atX - rasHeight < 0 ? rasHeight - atX : 0;
                int ex = atX >= this.sz.height ? this.sz.height - atX : rasHeight;
                for (int y = 0; y < rasWidth; ++y) {
                    int trueY = atY + y;
                    if (trueY < 0 || trueY >= this.sz.height) continue;
                    byte[] row = null;
                    int baseIndex = 0;
                    if (layerBitMap == null) {
                        baseIndex = trueY * this.sz.width;
                    } else {
                        row = layerBitMap[trueY];
                    }
                    for (int x = sx; x < ex; ++x) {
                        int trueX = atX + x;
                        int alpha = samples[(rasHeight - x - 1) * rasWidth + y] & 0xFF;
                        if (alpha == 0) continue;
                        if (layerBitMap == null) {
                            int fullIndex = baseIndex + trueX;
                            int pixelValue = this.opaqueData[fullIndex];
                            int oldAlpha = pixelValue >> 24 & 0xFF;
                            int color = col;
                            if (oldAlpha == 0) {
                                if (alpha != 255) {
                                    color = this.alphaBlend(color, pixelValue, alpha);
                                }
                            } else if (oldAlpha == 255 && alpha < 255) {
                                color = color & 0xFFFFFF | alpha << 24;
                            }
                            this.opaqueData[fullIndex] = color;
                            continue;
                        }
                        if (alpha < 128) continue;
                        int n = trueX >> 3;
                        row[n] = (byte)(row[n] | 1 << (trueX & 7));
                    }
                }
                break;
            }
        }
    }

    private int alphaBlend(int color, int backgroundColor, int alpha) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int inverseAlpha = 254 - alpha;
        int redBack = backgroundColor >> 16 & 0xFF;
        int greenBack = backgroundColor >> 8 & 0xFF;
        int blueBack = backgroundColor & 0xFF;
        red = (red * alpha + redBack * inverseAlpha) / 255;
        green = (green * alpha + greenBack * inverseAlpha) / 255;
        blue = (blue * alpha + blueBack * inverseAlpha) / 255;
        color = red << 16 | (green << 8) + blue;
        return color;
    }

    private static Point getTextCorner(int rasterWidth, int rasterHeight, Poly.Type style, Rectangle rect, int rotation) {
        int textWidth = rasterWidth;
        int textHeight = rasterHeight;
        int offX = 0;
        int offY = 0;
        if (style == Poly.Type.TEXTCENT) {
            offX = -textWidth / 2;
            offY = -textHeight / 2;
        } else if (style == Poly.Type.TEXTTOP) {
            offX = -textWidth / 2;
        } else if (style == Poly.Type.TEXTBOT) {
            offX = -textWidth / 2;
            offY = -textHeight;
        } else if (style == Poly.Type.TEXTLEFT) {
            offY = -textHeight / 2;
        } else if (style == Poly.Type.TEXTRIGHT) {
            offX = -textWidth;
            offY = -textHeight / 2;
        } else if (style != Poly.Type.TEXTTOPLEFT) {
            if (style == Poly.Type.TEXTBOTLEFT) {
                offY = -textHeight;
            } else if (style == Poly.Type.TEXTTOPRIGHT) {
                offX = -textWidth;
            } else if (style == Poly.Type.TEXTBOTRIGHT) {
                offX = -textWidth;
                offY = -textHeight;
            }
        }
        if (style == Poly.Type.TEXTBOX) {
            offX = -textWidth / 2;
            offY = -textHeight / 2;
        }
        if (rotation != 0) {
            int saveOffX = offX;
            switch (rotation) {
                case 1: {
                    offX = offY;
                    offY = saveOffX;
                    break;
                }
                case 2: {
                    offX = -offX;
                    offY = -offY;
                    break;
                }
                case 3: {
                    offX = offY;
                    offY = saveOffX;
                }
            }
        }
        int cX = (int)rect.getCenterX() + offX;
        int cY = (int)rect.getCenterY() + offY;
        return new Point(cX, cY);
    }

    public static Raster renderText(String msg, String font, int tSize, boolean italic, boolean bold, boolean underline, int boxedWidth, int boxedHeight) {
        RenderTextInfo renderInfo = new RenderTextInfo();
        if (!renderInfo.buildInfo(msg, font, tSize, italic, bold, underline, new Rectangle(boxedWidth, boxedHeight), null, 0)) {
            return null;
        }
        return PixelDrawing.renderText(renderInfo);
    }

    private static Raster renderText(RenderTextInfo renderInfo) {
        Font theFont = renderInfo.font;
        if (theFont == null) {
            return null;
        }
        int width = (int)renderInfo.rasBounds.getWidth();
        int height = (int)renderInfo.rasBounds.getHeight();
        GlyphVector gv = renderInfo.gv;
        LineMetrics lm = renderInfo.lm;
        BufferedImage textImage = new BufferedImage(width, height, 10);
        Graphics2D g2 = (Graphics2D)textImage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(new Color(255, 255, 255));
        g2.drawGlyphVector(gv, (float)(-renderInfo.rasBounds.getX()), lm.getAscent() - lm.getLeading());
        if (renderInfo.underline) {
            g2.drawLine(0, height - 1, width, height - 1);
        }
        return textImage.getData();
    }

    public static Font getFont(String msg, String font, int tSize, boolean italic, boolean bold, boolean underline) {
        Font theFont;
        int fontStyle = 0;
        if (italic) {
            fontStyle |= 2;
        }
        if (bold) {
            fontStyle |= 1;
        }
        if ((theFont = new Font(font, fontStyle, tSize)) == null) {
            System.out.println("Could not find font " + font + " to render text: " + msg);
            return null;
        }
        return theFont;
    }

    private void drawCircle(Point center, Point edge, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        int x;
        int radius = (int)center.distance(edge);
        int col = 0;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
        }
        int left = center.x - radius;
        int right = center.x + radius + 1;
        int top = center.y - radius;
        int bottom = center.y + radius + 1;
        int y = radius;
        int d = 3 - 2 * radius;
        if (left >= 0 && right < this.sz.width && top >= 0 && bottom < this.sz.height) {
            for (x = 0; x <= y; ++x) {
                if (layerBitMap == null) {
                    int baseIndex = (center.y + y) * this.sz.width;
                    this.opaqueData[baseIndex + (center.x + x)] = col;
                    this.opaqueData[baseIndex + (center.x - x)] = col;
                    baseIndex = (center.y - y) * this.sz.width;
                    this.opaqueData[baseIndex + (center.x + x)] = col;
                    this.opaqueData[baseIndex + (center.x - x)] = col;
                    baseIndex = (center.y + x) * this.sz.width;
                    this.opaqueData[baseIndex + (center.x + y)] = col;
                    this.opaqueData[baseIndex + (center.x - y)] = col;
                    baseIndex = (center.y - x) * this.sz.width;
                    this.opaqueData[baseIndex + (center.x + y)] = col;
                    this.opaqueData[baseIndex + (center.x - y)] = col;
                } else {
                    byte[] row = layerBitMap[center.y + y];
                    int n = center.x + x >> 3;
                    row[n] = (byte)(row[n] | 1 << (center.x + x & 7));
                    int n2 = center.x - x >> 3;
                    row[n2] = (byte)(row[n2] | 1 << (center.x - x & 7));
                    row = layerBitMap[center.y - y];
                    int n3 = center.x + x >> 3;
                    row[n3] = (byte)(row[n3] | 1 << (center.x + x & 7));
                    int n4 = center.x - x >> 3;
                    row[n4] = (byte)(row[n4] | 1 << (center.x - x & 7));
                    row = layerBitMap[center.y + x];
                    int n5 = center.x + y >> 3;
                    row[n5] = (byte)(row[n5] | 1 << (center.x + y & 7));
                    int n6 = center.x - y >> 3;
                    row[n6] = (byte)(row[n6] | 1 << (center.x - y & 7));
                    row = layerBitMap[center.y - x];
                    int n7 = center.x + y >> 3;
                    row[n7] = (byte)(row[n7] | 1 << (center.x + y & 7));
                    int n8 = center.x - y >> 3;
                    row[n8] = (byte)(row[n8] | 1 << (center.x - y & 7));
                }
                if (d < 0) {
                    d += 4 * x + 6;
                    continue;
                }
                d += 4 * (x - y) + 10;
                --y;
            }
        } else {
            while (x <= y) {
                int thisx;
                int thisy = center.y + y;
                if (thisy >= 0 && thisy < this.sz.height) {
                    thisx = center.x + x;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                    if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                }
                if ((thisy = center.y - y) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + x;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                    if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                }
                if ((thisy = center.y + x) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + y;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                    if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                }
                if ((thisy = center.y - x) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + y;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                    if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                }
                if (d < 0) {
                    d += 4 * x + 6;
                } else {
                    d += 4 * (x - y) + 10;
                    --y;
                }
                ++x;
            }
        }
    }

    private void drawThickCircle(Point center, Point edge, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        int radius = (int)center.distance(edge);
        int col = 0;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
        }
        int y = radius;
        int d = 3 - 2 * radius;
        for (int x = 0; x <= y; ++x) {
            int thisx;
            int thisy = center.y + y;
            if (thisy >= 0 && thisy < this.sz.height) {
                thisx = center.x + x;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
                if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
            }
            if ((thisy = center.y - y) >= 0 && thisy < this.sz.height) {
                thisx = center.x + x;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
                if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
            }
            if ((thisy = center.y + x) >= 0 && thisy < this.sz.height) {
                thisx = center.x + y;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
                if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
            }
            if ((thisy = center.y - x) >= 0 && thisy < this.sz.height) {
                thisx = center.x + y;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
                if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
            }
            if (d < 0) {
                d += 4 * x + 6;
                continue;
            }
            d += 4 * (x - y) + 10;
            --y;
        }
    }

    private void drawDiscRow(int thisy, int startx, int endx, byte[][] layerBitMap, int col, int[] pattern) {
        block12: {
            block11: {
                if (thisy < 0 || thisy >= this.sz.height) {
                    return;
                }
                if (startx < 0) {
                    startx = 0;
                }
                if (endx >= this.sz.width) {
                    endx = this.sz.width - 1;
                }
                if (pattern == null) break block11;
                int pat = pattern[thisy & 0xF];
                if (pat == 0) break block12;
                if (layerBitMap == null) {
                    int baseIndex = thisy * this.sz.width;
                    for (int x = startx; x <= endx; ++x) {
                        if ((pat & 1 << 15 - (x & 0xF)) == 0) continue;
                        this.opaqueData[baseIndex + x] = col;
                    }
                } else {
                    byte[] row = layerBitMap[thisy];
                    for (int x = startx; x <= endx; ++x) {
                        if ((pat & 1 << 15 - (x & 0xF)) == 0) continue;
                        int n = x >> 3;
                        row[n] = (byte)(row[n] | 1 << (x & 7));
                    }
                }
                break block12;
            }
            if (layerBitMap == null) {
                int baseIndex = thisy * this.sz.width;
                for (int x = startx; x <= endx; ++x) {
                    int index = baseIndex + x;
                    int alpha = this.opaqueData[index] >> 24 & 0xFF;
                    if (alpha != 255) continue;
                    this.opaqueData[index] = col;
                }
            } else {
                byte[] row = layerBitMap[thisy];
                for (int x = startx; x <= endx; ++x) {
                    int n = x >> 3;
                    row[n] = (byte)(row[n] | 1 << (x & 7));
                }
            }
        }
    }

    private void drawDisc(Point center, Point edge, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        int radius = (int)center.distance(edge);
        int col = 0;
        int[] pattern = null;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
            if (desc.isPatternedOnDisplay()) {
                pattern = desc.getPattern();
                if (desc.isOutlinedOnDisplay()) {
                    this.drawCircle(center, edge, layerBitMap, desc, dimmed);
                }
            }
        }
        int left = center.x - radius;
        int right = center.x + radius + 1;
        int top = center.y - radius;
        int bottom = center.y + radius + 1;
        if (radius == 1) {
            if (left < 0) {
                left = 0;
            }
            if (right >= this.sz.width) {
                right = this.sz.width - 1;
            }
            for (int y = top; y < bottom; ++y) {
                if (y < 0 || y >= this.sz.height) continue;
                for (int x = left; x < right; ++x) {
                    this.drawPoint(x, y, layerBitMap, col);
                }
            }
            return;
        }
        int y = radius;
        int d = 3 - 2 * radius;
        for (int x = 0; x <= y; ++x) {
            this.drawDiscRow(center.y + y, center.x - x, center.x + x, layerBitMap, col, pattern);
            this.drawDiscRow(center.y - y, center.x - x, center.x + x, layerBitMap, col, pattern);
            this.drawDiscRow(center.y + x, center.x - y, center.x + y, layerBitMap, col, pattern);
            this.drawDiscRow(center.y - x, center.x - y, center.x + y, layerBitMap, col, pattern);
            if (d < 0) {
                d += 4 * x + 6;
                continue;
            }
            d += 4 * (x - y) + 10;
            --y;
        }
    }

    private int arcFindOctant(int x, int y) {
        if (x > 0) {
            if (y >= 0) {
                if (y >= x) {
                    return 7;
                }
                return 8;
            }
            if (x >= -y) {
                return 1;
            }
            return 2;
        }
        if (y > 0) {
            if (y > -x) {
                return 6;
            }
            return 5;
        }
        if (y > x) {
            return 4;
        }
        return 3;
    }

    private Point arcXformOctant(int x, int y, int oct) {
        switch (oct) {
            case 1: {
                return new Point(-y, x);
            }
            case 2: {
                return new Point(x, -y);
            }
            case 3: {
                return new Point(-x, -y);
            }
            case 4: {
                return new Point(-y, -x);
            }
            case 5: {
                return new Point(y, -x);
            }
            case 6: {
                return new Point(-x, y);
            }
            case 7: {
                return new Point(x, y);
            }
            case 8: {
                return new Point(y, x);
            }
        }
        return null;
    }

    private void arcDoPixel(int x, int y) {
        if (x < 0 || x >= this.sz.width || y < 0 || y >= this.sz.height) {
            return;
        }
        if (this.arcThick) {
            this.drawThickPoint(x, y, this.arcLayerBitMap, this.arcCol);
        } else {
            this.drawPoint(x, y, this.arcLayerBitMap, this.arcCol);
        }
    }

    private void arcOutXform(int x, int y) {
        if (this.arcOctTable[1]) {
            this.arcDoPixel(y + this.arcCenter.x, -x + this.arcCenter.y);
        }
        if (this.arcOctTable[2]) {
            this.arcDoPixel(x + this.arcCenter.x, -y + this.arcCenter.y);
        }
        if (this.arcOctTable[3]) {
            this.arcDoPixel(-x + this.arcCenter.x, -y + this.arcCenter.y);
        }
        if (this.arcOctTable[4]) {
            this.arcDoPixel(-y + this.arcCenter.x, -x + this.arcCenter.y);
        }
        if (this.arcOctTable[5]) {
            this.arcDoPixel(-y + this.arcCenter.x, x + this.arcCenter.y);
        }
        if (this.arcOctTable[6]) {
            this.arcDoPixel(-x + this.arcCenter.x, y + this.arcCenter.y);
        }
        if (this.arcOctTable[7]) {
            this.arcDoPixel(x + this.arcCenter.x, y + this.arcCenter.y);
        }
        if (this.arcOctTable[8]) {
            this.arcDoPixel(y + this.arcCenter.x, x + this.arcCenter.y);
        }
    }

    private void arcBresCW(Point pt, Point pt1) {
        int d = 3 - 2 * pt.y + 4 * pt.x;
        while (pt.x < pt1.x && pt.y > pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d < 0) {
                d += 4 * pt.x + 6;
            } else {
                d += 4 * (pt.x - pt.y) + 10;
                --pt.y;
            }
            ++pt.x;
        }
        while (pt.x < pt1.x) {
            this.arcOutXform(pt.x, pt.y);
            ++pt.x;
        }
        while (pt.y > pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            --pt.y;
        }
        this.arcOutXform(pt1.x, pt1.y);
    }

    private void arcBresMidCW(Point pt) {
        int d = 3 - 2 * pt.y + 4 * pt.x;
        while (pt.x < pt.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d < 0) {
                d += 4 * pt.x + 6;
            } else {
                d += 4 * (pt.x - pt.y) + 10;
                --pt.y;
            }
            ++pt.x;
        }
        if (pt.x == pt.y) {
            this.arcOutXform(pt.x, pt.y);
        }
    }

    private void arcBresMidCCW(Point pt) {
        int d = 3 + 2 * pt.y - 4 * pt.x;
        while (pt.x > 0) {
            this.arcOutXform(pt.x, pt.y);
            if (d > 0) {
                d += 6 - 4 * pt.x;
            } else {
                d += 4 * (pt.y - pt.x) + 10;
                ++pt.y;
            }
            --pt.x;
        }
        this.arcOutXform(0, this.arcRadius);
    }

    private void arcBresCCW(Point pt, Point pt1) {
        int d = 3 + 2 * pt.y + 4 * pt.x;
        while (pt.x > pt1.x && pt.y < pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d > 0) {
                d += 6 - 4 * pt.x;
            } else {
                d += 4 * (pt.y - pt.x) + 10;
                ++pt.y;
            }
            --pt.x;
        }
        while (pt.x > pt1.x) {
            this.arcOutXform(pt.x, pt.y);
            --pt.x;
        }
        while (pt.y < pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            ++pt.y;
        }
        this.arcOutXform(pt1.x, pt1.y);
    }

    private void drawCircleArc(Point center, Point p1, Point p2, boolean thick, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        if (p1.x == p2.x && p1.y == p2.y) {
            return;
        }
        this.arcLayerBitMap = layerBitMap;
        this.arcCol = 0;
        if (desc != null) {
            this.arcCol = this.getTheColor(desc, dimmed);
        }
        this.arcCenter = center;
        int pa_x = p2.x - this.arcCenter.x;
        int pa_y = p2.y - this.arcCenter.y;
        int pb_x = p1.x - this.arcCenter.x;
        int pb_y = p1.y - this.arcCenter.y;
        this.arcRadius = (int)this.arcCenter.distance(p2);
        int alternate = (int)this.arcCenter.distance(p1);
        int start_oct = this.arcFindOctant(pa_x, pa_y);
        int end_oct = this.arcFindOctant(pb_x, pb_y);
        this.arcThick = thick;
        if (this.arcRadius != alternate) {
            int diff = this.arcRadius - alternate;
            switch (end_oct) {
                case 6: 
                case 7: {
                    pb_y += diff;
                    break;
                }
                case 1: 
                case 8: {
                    pb_x += diff;
                    break;
                }
                case 2: 
                case 3: {
                    pb_y -= diff;
                    break;
                }
                case 4: 
                case 5: {
                    pb_x -= diff;
                }
            }
        }
        for (int i = 1; i < 9; ++i) {
            this.arcOctTable[i] = false;
        }
        if (start_oct == end_oct) {
            this.arcOctTable[start_oct] = true;
            Point pa = this.arcXformOctant(pa_x, pa_y, start_oct);
            Point pb = this.arcXformOctant(pb_x, pb_y, start_oct);
            if ((start_oct & 1) != 0) {
                this.arcBresCW(pa, pb);
            } else {
                this.arcBresCCW(pa, pb);
            }
            this.arcOctTable[start_oct] = false;
        } else {
            this.arcOctTable[start_oct] = true;
            Point pt = this.arcXformOctant(pa_x, pa_y, start_oct);
            if ((start_oct & 1) != 0) {
                this.arcBresMidCW(pt);
            } else {
                this.arcBresMidCCW(pt);
            }
            this.arcOctTable[start_oct] = false;
            this.arcOctTable[end_oct] = true;
            pt = this.arcXformOctant(pb_x, pb_y, end_oct);
            if ((end_oct & 1) != 0) {
                this.arcBresMidCCW(pt);
            } else {
                this.arcBresMidCW(pt);
            }
            this.arcOctTable[end_oct] = false;
            if (this.MODP(start_oct + 1) != end_oct) {
                if (this.MODP(start_oct + 1) == this.MODM(end_oct - 1)) {
                    this.arcOctTable[this.MODP((int)(start_oct + 1))] = true;
                } else {
                    int i = this.MODP(start_oct + 1);
                    while (i != end_oct) {
                        this.arcOctTable[i] = true;
                        i = this.MODP(i + 1);
                    }
                }
                this.arcBresMidCW(new Point(0, this.arcRadius));
            }
        }
    }

    private int MODM(int x) {
        return x < 1 ? x + 8 : x;
    }

    private int MODP(int x) {
        return x > 8 ? x - 8 : x;
    }

    private void drawPoint(int x, int y, byte[][] layerBitMap, int col) {
        if (layerBitMap == null) {
            this.opaqueData[y * this.sz.width + x] = col;
        } else {
            byte[] byArray = layerBitMap[y];
            int n = x >> 3;
            byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
        }
    }

    private void drawThickPoint(int x, int y, byte[][] layerBitMap, int col) {
        if (layerBitMap == null) {
            this.opaqueData[y * this.sz.width + x] = col;
            if (x > 0) {
                this.opaqueData[y * this.sz.width + (x - 1)] = col;
            }
            if (x < this.sz.width - 1) {
                this.opaqueData[y * this.sz.width + (x + 1)] = col;
            }
            if (y > 0) {
                this.opaqueData[(y - 1) * this.sz.width + x] = col;
            }
            if (y < this.sz.height - 1) {
                this.opaqueData[(y + 1) * this.sz.width + x] = col;
            }
        } else {
            byte[] byArray = layerBitMap[y];
            int n = x >> 3;
            byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            if (x > 0) {
                byte[] byArray2 = layerBitMap[y];
                int n2 = x - 1 >> 3;
                byArray2[n2] = (byte)(byArray2[n2] | 1 << (x - 1 & 7));
            }
            if (x < this.sz.width - 1) {
                byte[] byArray3 = layerBitMap[y];
                int n3 = x + 1 >> 3;
                byArray3[n3] = (byte)(byArray3[n3] | 1 << (x + 1 & 7));
            }
            if (y > 0) {
                byte[] byArray4 = layerBitMap[y - 1];
                int n4 = x >> 3;
                byArray4[n4] = (byte)(byArray4[n4] | 1 << (x & 7));
            }
            if (y < this.sz.height - 1) {
                byte[] byArray5 = layerBitMap[y + 1];
                int n5 = x >> 3;
                byArray5[n5] = (byte)(byArray5[n5] | 1 << (x & 7));
            }
        }
    }

    static {
        techWithLayers = null;
        expandedCells = null;
        expandedScale = 0.0;
        noCellTextDescriptor = null;
        CENTERRECT = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        blackGraphics = new EGraphics(0, 0, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        portGraphics = new EGraphics(0, 0, 0, 255, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    }

    private static class RenderTextInfo {
        private Font font;
        private GlyphVector gv;
        private LineMetrics lm;
        private Point2D anchorPoint;
        private Rectangle2D rasBounds;
        private Rectangle2D bounds;
        private boolean underline;

        private RenderTextInfo() {
        }

        private boolean buildInfo(String msg, String fontName, int tSize, boolean italic, boolean bold, boolean underline, Rectangle probableBoxedBounds, Poly.Type style, int rotation) {
            this.font = PixelDrawing.getFont(msg, fontName, tSize, italic, bold, underline);
            this.underline = underline;
            FontRenderContext frc = new FontRenderContext(null, true, true);
            this.gv = this.font.createGlyphVector(frc, msg);
            this.lm = this.font.getLineMetrics(msg, frc);
            Rectangle2D rasRect = this.gv.getLogicalBounds();
            int width = (int)rasRect.getWidth();
            int height = (int)((double)this.lm.getHeight() + 0.5);
            if (width <= 0 || height <= 0) {
                return false;
            }
            int fontStyle = this.font.getStyle();
            int boxedWidth = (int)probableBoxedBounds.getWidth();
            int boxedHeight = (int)probableBoxedBounds.getHeight();
            if (boxedWidth > 0 && boxedHeight > 0 && (width > boxedWidth || height > boxedHeight)) {
                double scale = Math.min((double)boxedWidth / (double)width, (double)boxedHeight / (double)height);
                this.font = new Font(fontName, fontStyle, (int)((double)tSize * scale));
                if (this.font != null) {
                    this.gv = this.font.createGlyphVector(frc, msg);
                    this.lm = this.font.getLineMetrics(msg, frc);
                    rasRect = this.gv.getLogicalBounds();
                    height = (int)((double)this.lm.getHeight() + 0.5);
                    if (height <= 0) {
                        return false;
                    }
                    width = (int)rasRect.getWidth();
                }
            }
            if (underline) {
                ++height;
            }
            this.rasBounds = new Rectangle2D.Double(0.0, this.lm.getAscent() - this.lm.getLeading(), width, height);
            this.anchorPoint = PixelDrawing.getTextCorner(width, height, style, probableBoxedBounds, rotation);
            this.bounds = rotation == 1 || rotation == 3 ? new Rectangle2D.Double(this.anchorPoint.getX(), this.anchorPoint.getY(), height, width) : new Rectangle2D.Double(this.anchorPoint.getX(), this.anchorPoint.getY(), width, height);
            return true;
        }
    }

    private static class PatternedOpaqueLayer {
        private byte[][] bitMap;
        private byte[] compositeRow;

        private PatternedOpaqueLayer() {
        }

        static /* synthetic */ byte[][] access$002(PatternedOpaqueLayer x0, byte[][] x1) {
            x0.bitMap = x1;
            return x1;
        }
    }

    private static class ExpandedCellInfo {
        private int instanceCount;
        private PixelDrawing offscreen;

        private ExpandedCellInfo() {
        }
    }

    private static class PolySeg {
        private int fx;
        private int fy;
        private int tx;
        private int ty;
        private int direction;
        private int increment;
        private PolySeg nextedge;
        private PolySeg nextactive;

        private PolySeg() {
        }
    }
}

