/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.basic.Primes;
import com.sun.electric.tool.ncc.netlist.NccNameProxy;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.PinType;
import com.sun.electric.tool.ncc.netlist.Wire;
import java.util.HashSet;
import java.util.Set;

public class Bipolar
extends Part {
    private static final Set PIN_TYPE_SET = new HashSet();
    private double area;
    private final Type type;

    public Set getPinTypes() {
        return PIN_TYPE_SET;
    }

    private Bipolar(Type np, NccNameProxy.PartNameProxy name, double area, Wire[] pins) {
        super(name, pins);
        LayoutLib.error(np == null, "null type?");
        this.type = np;
        this.area = area;
    }

    private boolean samePinsAs(Bipolar b) {
        LayoutLib.error(b.pins.length != this.pins.length, "different # pins?");
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] == b.pins[i]) continue;
            return false;
        }
        return true;
    }

    public Bipolar(Type np, NccNameProxy.PartNameProxy name, double area, Wire emit, Wire base, Wire coll) {
        this(np, name, area, new Wire[]{emit, base, coll});
    }

    public Type getType() {
        return this.type;
    }

    public double getArea() {
        return this.area;
    }

    public int[] getPinCoeffs() {
        return this.type.getPinCoeffs();
    }

    public Integer hashCodeForParallelMerge() {
        int hc = this.getClass().hashCode();
        for (int i = 0; i < this.pins.length; ++i) {
            hc += this.pins[i].hashCode() * this.type.getPinCoeffs()[i];
        }
        return new Integer(hc += this.type.hashCode());
    }

    public boolean parallelMerge(Part p) {
        if (!(p instanceof Bipolar)) {
            return false;
        }
        Bipolar b = (Bipolar)p;
        if (this == b) {
            return false;
        }
        if (this.type != b.type) {
            return false;
        }
        if (!this.samePinsAs(b)) {
            return false;
        }
        this.area += b.area;
        b.setDeleted();
        return true;
    }

    public int typeCode() {
        int tw = 4;
        return 1 + (this.type.getOrdinal() << 4);
    }

    public String typeString() {
        return this.type.name;
    }

    public String valueDescription() {
        return "A=" + NccUtils.round(this.area, 2);
    }

    public String connectionDescription(int n) {
        return "E=" + this.pins[0].getName() + " B=" + this.pins[1].getName() + " C=" + this.pins[2].getName();
    }

    public String connectionDescription(Wire w) {
        String s = "";
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] != w) continue;
            if (s.length() != 0) {
                s = s + ",";
            }
            s = i == 0 ? s + "E" : (i == 1 ? s + "B" : s + "C");
        }
        return s;
    }

    public Integer computeHashCode() {
        int sum = 0;
        for (int i = 0; i < this.pins.length; ++i) {
            sum += this.pins[i].getCode() * this.type.getPinCoeffs()[i];
        }
        return new Integer(sum);
    }

    static {
        for (int t = 0; t < 2; ++t) {
            Type type = t == 0 ? Type.NPN : Type.PNP;
            for (int p = 0; p < 3; ++p) {
                PIN_TYPE_SET.add(new BipolarPinType(type, p));
            }
        }
    }

    private static class BipolarPinType
    implements PinType {
        private final Type np;
        private final int pinIndex;
        private static final String[] PIN_NAMES = new String[]{"emitter", "base", "collector"};

        public int numConnectionsToPinOfThisType(Part p, Wire w) {
            if (!(p instanceof Bipolar)) {
                return 0;
            }
            Bipolar b = (Bipolar)p;
            if (b.getType() != this.np) {
                return 0;
            }
            return b.pins[this.pinIndex] == w ? 1 : 0;
        }

        public String description() {
            return this.np.getName() + " " + PIN_NAMES[this.pinIndex];
        }

        public BipolarPinType(Type np, int pinIndex) {
            LayoutLib.error(np == null, "null type?");
            this.np = np;
            this.pinIndex = pinIndex;
        }
    }

    public static class Type {
        public static final Type NPN = new Type(0, "NPN");
        public static final Type PNP = new Type(1, "PNP");
        private final String name;
        private final int ordinal;
        private final int[] pin_coeffs = new int[3];

        private Type(int ord, String s) {
            this.ordinal = ord;
            this.name = s;
            for (int p = 0; p < 3; ++p) {
                this.pin_coeffs[p] = Primes.get(ord * 3 + p);
            }
        }

        public String getName() {
            return this.name;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public int[] getPinCoeffs() {
            return this.pin_coeffs;
        }
    }
}

