/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.variable.VarContext;
import java.util.Iterator;

public abstract class ExportConflict {
    protected Cell cell;
    protected VarContext context;
    protected String name;

    public ExportConflict(Cell cel, VarContext con, String nm) {
        this.cell = cel;
        this.context = con;
        this.name = nm;
    }

    public Cell getCell() {
        return this.cell;
    }

    public VarContext getContext() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    protected abstract String getDescription(int var1);

    public static class CharactConflict
    extends ExportConflict {
        private String localType;
        private String globalType;
        private Export localExport;

        public CharactConflict(Cell cel, VarContext con, String nm, String gType, String lType, Export exp) {
            super(cel, con, nm);
            this.localType = lType;
            this.globalType = gType;
            this.localExport = exp;
        }

        protected String getDescription(int col) {
            if (col == 0) {
                return this.globalType;
            }
            if (col == 1) {
                return this.localType;
            }
            return null;
        }

        public Export getLocalExport() {
            return this.localExport;
        }
    }

    public static class NetworkConflict
    extends ExportConflict {
        private Network localNet;
        private Network globalNet;
        private String[] descr = new String[2];

        public NetworkConflict(Cell cel, VarContext con, String nm, Network lNet, Network gNet) {
            super(cel, con, nm);
            this.localNet = lNet;
            this.globalNet = gNet;
            this.descr[0] = this.createDescription(this.globalNet);
            this.descr[1] = this.createDescription(this.localNet);
        }

        protected String getDescription(int col) {
            if (col != 0 && col != 1) {
                return null;
            }
            return this.descr[col];
        }

        public Network getNetwork(int col) {
            if (col == 0) {
                return this.globalNet;
            }
            if (col == 1) {
                return this.localNet;
            }
            return null;
        }

        public Network getLocalNetwork() {
            return this.localNet;
        }

        public Network getGlobalNetwork() {
            return this.globalNet;
        }

        private String createDescription(Network net) {
            StringBuffer buf = new StringBuffer(10);
            buf.append("{");
            Iterator it = net.getNames();
            while (it.hasNext()) {
                buf.append(" " + (String)it.next());
                if (!it.hasNext()) continue;
                buf.append(",");
            }
            buf.append(" }");
            return buf.toString();
        }
    }
}

