/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ExportChanges;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tecEdit.Manipulate;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TechPalette;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.util.EventListener;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PaletteFrame
implements MouseListener {
    private JPanel topPanel;
    private TechPalette techPalette;
    private JComboBox techSelector;

    private PaletteFrame() {
    }

    public static PaletteFrame newInstance(WindowFrame ww) {
        PaletteFrame palette = new PaletteFrame();
        palette.topPanel = new JPanel();
        palette.initComponents(ww);
        return palette;
    }

    public void loadTechnologies(boolean makeCurrent) {
        Technology cur = Technology.getCurrent();
        if (!makeCurrent) {
            cur = Technology.findTechnology((String)this.techSelector.getSelectedItem());
        }
        this.techSelector.removeAllItems();
        Iterator it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = (Technology)it.next();
            if (tech == Generic.tech) continue;
            this.techSelector.addItem(tech.getTechName());
        }
        this.setSelectedItem(cur.getTechName());
    }

    public void setSelectedItem(Object anObject) {
        this.techSelector.setSelectedItem(anObject);
    }

    private void initComponents(WindowFrame wf) {
        JPanel content = this.topPanel;
        content.setLayout(new GridBagLayout());
        this.techSelector = new JComboBox();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        content.add((Component)this.techSelector, gridBagConstraints);
        this.techPalette = new TechPalette();
        this.techPalette.setFocusable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        content.add((Component)this.techPalette, gridBagConstraints);
        this.techSelector.setLightWeightPopupEnabled(false);
        this.loadTechnologies(true);
        this.techSelector.addActionListener(new WindowFrame.CurTechControlListener(wf));
    }

    public void setCursor(Cursor cursor) {
        this.techPalette.setCursor(cursor);
    }

    public JPanel getTechPalette() {
        return this.topPanel;
    }

    public void arcProtoChanged() {
        this.techPalette.repaint();
    }

    public void loadForTechnology(Technology tech, WindowFrame ww) {
        this.techSelector.setSelectedItem(tech.getTechName());
        Dimension size = this.techPalette.loadForTechnology(tech, ww.getContent().getCell());
        if (this.techPalette.isVisible()) {
            this.setSize(size);
        }
    }

    private void setSize(Dimension size) {
        this.topPanel.setSize(size);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isShiftDown() || e.isControlDown() || e.isAltDown()) {
            return;
        }
    }

    public static PlaceNodeListener placeInstance(Object obj, PlaceNodeEventListener palette, boolean export) {
        NodeProto np = null;
        NodeInst ni = null;
        String placeText = null;
        String whatToCreate = null;
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return null;
        }
        if (obj instanceof String) {
            placeText = (String)obj;
            whatToCreate = Variable.betterVariableName(placeText);
            obj = Generic.tech.invisiblePinNode;
        }
        if (obj instanceof NodeProto) {
            Cell cell;
            Cell iconCell;
            np = (NodeProto)obj;
            if (np instanceof Cell && (iconCell = (cell = (Cell)np).iconView()) != null && iconCell != cell) {
                int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Don't you really want to place the icon " + iconCell.describe(true) + "?");
                if (response == 2) {
                    return null;
                }
                if (response == 0) {
                    np = iconCell;
                    obj = np;
                }
            }
        } else if (obj instanceof NodeInst) {
            ni = (NodeInst)obj;
            np = ni.getProto();
            whatToCreate = ni.getFunction() + " node";
        }
        if (np != null) {
            EventListener oldListener = WindowFrame.getListener();
            Cursor oldCursor = TopLevel.getCurrentCursor();
            if (whatToCreate != null) {
                System.out.println("Click to create " + whatToCreate);
            } else if (np instanceof Cell) {
                System.out.println("Click to create an instance of " + np);
            } else {
                System.out.println("Click to create " + np);
            }
            EventListener newListener = oldListener;
            if (newListener != null && newListener instanceof PlaceNodeListener) {
                ((PlaceNodeListener)newListener).setParameter(obj);
                ((PlaceNodeListener)newListener).makePortWhenCreated(export);
            } else {
                newListener = new PlaceNodeListener(obj, oldListener, oldCursor, palette);
                ((PlaceNodeListener)newListener).makePortWhenCreated(export);
                WindowFrame.setListener(newListener);
            }
            if (placeText != null) {
                ((PlaceNodeListener)newListener).setTextNode(placeText);
            }
            if (palette != null) {
                palette.placeNodeStarted(obj);
            }
            TopLevel.setCurrentCursor(Cursor.getPredefinedCursor(12));
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd != null) {
                wnd.zoomWindowToFitCellInstance(np);
            }
            return (PlaceNodeListener)newListener;
        }
        return null;
    }

    public static class PlaceNewNode
    extends Job {
        Object toDraw;
        Point2D where;
        Cell cell;
        String varName;
        boolean export;

        public PlaceNewNode(String description, Object toDraw, Point2D where, Cell cell, String varName, boolean export) {
            super(description, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.toDraw = toDraw;
            this.where = where;
            this.cell = cell;
            this.varName = varName;
            this.export = export;
            this.startJob();
        }

        public boolean doIt() {
            EditWindow wnd = EditWindow.getCurrent();
            Highlighter highlighter = wnd.getHighlighter();
            NodeProto np = null;
            NodeInst ni = null;
            if (this.toDraw instanceof NodeProto) {
                np = (NodeProto)this.toDraw;
            } else if (this.toDraw instanceof NodeInst) {
                ni = (NodeInst)this.toDraw;
                np = ni.getProto();
            }
            if (np == null) {
                return false;
            }
            double width = np.getDefWidth();
            double height = np.getDefHeight();
            if (this.varName != null) {
                height = 0.0;
                width = 0.0;
            }
            Orientation defOrient = Orientation.IDENT;
            int techBits = 0;
            if (ni != null) {
                defOrient = ni.getOrient();
                techBits = ni.getTechSpecific();
            } else if (np instanceof PrimitiveNode) {
                int defAngle;
                defOrient = Orientation.fromJava(defAngle, (defAngle = ((PrimitiveNode)np).getDefPlacementAngle()) >= 3600, false);
            }
            NodeInst newNi = NodeInst.makeInstance(np, this.where, width, height, this.cell, defOrient, null, techBits);
            if (newNi == null) {
                return false;
            }
            if (np == Generic.tech.cellCenterNode || np == Generic.tech.essentialBoundsNode || np instanceof PrimitiveNode && ((PrimitiveNode)np).isPureWellNode()) {
                newNi.setHardSelect();
            }
            if (this.varName != null) {
                Variable var = newNi.newVar(Variable.newKey(this.varName), (Object)"text", ImmutableTextDescriptor.getAnnotationTextDescriptor());
                Highlight h = highlighter.addText(newNi, this.cell, var, null);
            } else {
                Variable var;
                if (np == Schematics.tech.resistorNode) {
                    var = newNi.newDisplayVar(Schematics.SCHEM_RESISTANCE, "100");
                    if (newNi.getFunction() == PrimitiveNode.Function.PRESIST) {
                        MutableTextDescriptor td = MutableTextDescriptor.getNodeTextDescriptor();
                        td.setOff(1.5, 0.0);
                        if (td.getSize().isAbsolute()) {
                            td.setAbsSize((int)(td.getSize().getSize() - 1.0));
                        } else {
                            td.setRelSize(td.getSize().getSize() - 0.5);
                        }
                        var = newNi.newVar(Schematics.ATTR_WIDTH, (Object)"2", td);
                        td = MutableTextDescriptor.getNodeTextDescriptor();
                        td.setOff(-1.5, 0.0);
                        if (td.getSize().isAbsolute()) {
                            td.setAbsSize((int)(td.getSize().getSize() - 2.0));
                        } else {
                            td.setRelSize(td.getSize().getSize() - 0.7);
                        }
                        var = newNi.newVar(Schematics.ATTR_LENGTH, (Object)"2", td);
                    }
                } else if (np == Schematics.tech.capacitorNode) {
                    var = newNi.newDisplayVar(Schematics.SCHEM_CAPACITANCE, "100M");
                } else if (np == Schematics.tech.inductorNode) {
                    var = newNi.newDisplayVar(Schematics.SCHEM_INDUCTANCE, "100");
                } else if (np == Schematics.tech.diodeNode) {
                    var = newNi.newDisplayVar(Schematics.SCHEM_DIODE, "10");
                } else if (np == Schematics.tech.transistorNode || np == Schematics.tech.transistor4Node) {
                    if (newNi.isFET()) {
                        MutableTextDescriptor td = MutableTextDescriptor.getNodeTextDescriptor();
                        td.setOff(0.5, -1.0);
                        Variable var2 = newNi.newVar(Schematics.ATTR_WIDTH, (Object)"2", td);
                        td = MutableTextDescriptor.getNodeTextDescriptor();
                        td.setOff(-0.5, -1.0);
                        if (td.getSize().isAbsolute()) {
                            td.setAbsSize((int)(td.getSize().getSize() - 2.0));
                        } else {
                            td.setRelSize(td.getSize().getSize() - 0.5);
                        }
                        var2 = newNi.newVar(Schematics.ATTR_LENGTH, (Object)"2", td);
                    } else {
                        var = newNi.newDisplayVar(Schematics.ATTR_AREA, "10");
                    }
                } else if (np == Artwork.tech.circleNode && ni != null) {
                    double[] angles = ni.getArcDegrees();
                    newNi.setArcDegrees(angles[0], angles[1]);
                }
                ElectricObject eObj = newNi;
                if (newNi.getNumPortInsts() > 0) {
                    eObj = (ElectricObject)newNi.getPortInsts().next();
                }
                highlighter.addElectricObject(eObj, this.cell);
            }
            if (this.cell.isInTechnologyLibrary()) {
                Manipulate.completeNodeCreation(newNi, this.toDraw);
            }
            highlighter.finished();
            if (this.export) {
                ExportChanges.newExportCommand();
                System.out.println("SHOULD EXPORT IT NOW");
            }
            return true;
        }
    }

    public static class PlaceNodeListener
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    KeyListener {
        private int oldx;
        private int oldy;
        private Point2D drawnLoc;
        private boolean doingMotionDrag;
        private Object toDraw;
        private EventListener oldListener;
        private Cursor oldCursor;
        private String textNode;
        private boolean makePort;
        private PlaceNodeEventListener palette;

        private PlaceNodeListener(Object toDraw, EventListener oldListener, Cursor oldCursor, PlaceNodeEventListener palette) {
            this.toDraw = toDraw;
            this.oldListener = oldListener;
            this.oldCursor = oldCursor;
            this.textNode = null;
            this.makePort = false;
            this.palette = palette;
        }

        public void makePortWhenCreated(boolean m) {
            this.makePort = m;
        }

        public void setParameter(Object toDraw) {
            this.toDraw = toDraw;
        }

        public void setTextNode(String varName) {
            this.textNode = varName;
        }

        public void mouseReleased(MouseEvent evt) {
            if (!(evt.getSource() instanceof EditWindow)) {
                return;
            }
            EditWindow wnd = (EditWindow)evt.getSource();
            this.oldx = evt.getX();
            this.oldy = evt.getY();
            Cell cell = wnd.getCell();
            if (cell == null) {
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot create node: this window has no cell in it");
                return;
            }
            Point2D where = wnd.screenToDatabase(this.oldx, this.oldy);
            EditWindow.gridAlign(where);
            NodeInst ni = null;
            NodeProto np = null;
            if (this.toDraw instanceof NodeProto) {
                np = (NodeProto)this.toDraw;
            } else if (this.toDraw instanceof NodeInst) {
                ni = (NodeInst)this.toDraw;
                np = ni.getProto();
            }
            if (cell.isInTechnologyLibrary() && Manipulate.invalidCreation(np, cell)) {
                this.finished(wnd, false);
                return;
            }
            String descript = "Create ";
            descript = np instanceof Cell ? descript + ((Cell)np).noLibDescribe() : descript + np.getName() + " Primitive";
            wnd.getHighlighter().clear();
            PlaceNewNode job = new PlaceNewNode(descript, this.toDraw, where, cell, this.textNode, this.makePort);
            this.finished(wnd, false);
        }

        public void finished(EditWindow wnd, boolean cancelled) {
            if (wnd != null) {
                Highlighter highlighter = wnd.getHighlighter();
                highlighter.clear();
                highlighter.finished();
            }
            WindowFrame.setListener(this.oldListener);
            TopLevel.setCurrentCursor(this.oldCursor);
            if (this.palette != null) {
                this.palette.placeNodeFinished(cancelled);
            }
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mouseMoved(MouseEvent evt) {
            if (evt.getSource() instanceof EditWindow) {
                EditWindow wnd = (EditWindow)evt.getSource();
                wnd.showDraggedBox(this.toDraw, evt.getX(), evt.getY());
            }
        }

        public void mouseDragged(MouseEvent evt) {
            if (evt.getSource() instanceof EditWindow) {
                EditWindow wnd = (EditWindow)evt.getSource();
                wnd.showDraggedBox(this.toDraw, evt.getX(), evt.getY());
            }
        }

        public void mouseWheelMoved(MouseWheelEvent evt) {
        }

        public void keyPressed(KeyEvent evt) {
            int chr = evt.getKeyCode();
            if (chr == 65 || chr == 27) {
                this.finished(EditWindow.getCurrent(), true);
            }
        }

        public void keyReleased(KeyEvent evt) {
        }

        public void keyTyped(KeyEvent evt) {
        }
    }

    public static interface PlaceNodeEventListener {
        public void placeNodeStarted(Object var1);

        public void placeNodeFinished(boolean var1);
    }
}

